/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot.provider;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.ibboost.orqa.core.RegexUtils;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.problem.Problem;
import org.ibboost.orqa.report.ReportTools;
import org.ibboost.orqa.report.snapshot.SnapshotParser;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public abstract class XmlSnapshotProvider
implements SnapshotProvider {
    private static final RegexUtils.Regex DECLARATION_PATTERN = RegexUtils.compile((String)"\\s*<\\?xml.*?\\?>\\s*\\r?\\n?");
    private static final String HEADER_PREFIX = "<!-- XML Snapshot - ";
    private static final String HEADER_SUFFIX = " -->";
    private static final String EXTENSION = "xml";

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public synchronized List<Snapshot> getSnapshots(ExecutionContext context, Problem problem) throws IOException {
        String xmlText;
        try {
            xmlText = this.getXmlSnapshot(context);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        if (xmlText == null || xmlText.isEmpty()) {
            return Collections.emptyList();
        }
        String executablePath = ReportTools.getExecutablePath((ExecutionContext)context.getRootContext());
        Map.Entry<String, String> declarationAndBody = XmlSnapshotProvider.splitDeclarationAndBody(xmlText);
        StringBuilder result = new StringBuilder();
        result.append(declarationAndBody.getKey()).append(HEADER_PREFIX).append(StringEscapeUtils.escapeXml11((String)executablePath)).append(HEADER_SUFFIX).append(XmlSnapshotProvider.getLineSeparator(xmlText)).append(declarationAndBody.getValue());
        String resultString = result.toString();
        return Arrays.asList(new Snapshot(resultString, resultString.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public List<Snapshot> getStandaloneSnapshots() throws Exception {
        return null;
    }

    @Override
    public boolean supportsStandalone() {
        return false;
    }

    private static String getLineSeparator(String text) {
        if (text.contains("\r")) {
            return "\r\n";
        }
        if (text.contains("\n")) {
            return "\n";
        }
        return System.lineSeparator();
    }

    private static Map.Entry<String, String> splitDeclarationAndBody(String xmlText) {
        RegexUtils.Matcher matcher = DECLARATION_PATTERN.matcher((CharSequence)xmlText);
        if (matcher.find() && matcher.start() == 0) {
            Object declaration = matcher.group();
            String body = xmlText.substring(((String)declaration).length());
            if (!((String)declaration).endsWith("\n")) {
                declaration = (String)declaration + XmlSnapshotProvider.getLineSeparator(xmlText);
            }
            return new AbstractMap.SimpleEntry<String, String>((String)declaration, body);
        }
        return new AbstractMap.SimpleEntry<String, String>("", xmlText);
    }

    @Override
    public SnapshotParser getSnapshotParser() {
        return new XmlSnapshotReportParser();
    }

    public abstract String getXmlSnapshot(ExecutionContext var1) throws Exception;

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public void initialise(ExecutionContext rootContext) {
    }

    @Override
    public void shutdown(ExecutionContext rootContext) {
    }

    public static class XmlSnapshotReportParser
    extends SnapshotParser {
        public List<String> getSupportedFileExtensions() {
            return Arrays.asList(XmlSnapshotProvider.EXTENSION);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IPath getReportExecutable(File reportFile) throws IOException {
            if (!reportFile.isFile()) {
                return null;
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<String> lines = Files.lines(reportFile.toPath(), StandardCharsets.UTF_8);){
                String line;
                String value;
                Iterator iterator = lines.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return null;
                } while ((value = XmlSnapshotProvider.splitDeclarationAndBody(line = ((String)iterator.next()).trim()).getValue().trim()).isEmpty());
                if (!value.startsWith(XmlSnapshotProvider.HEADER_PREFIX)) return null;
                if (!value.contains(XmlSnapshotProvider.HEADER_SUFFIX)) return null;
                String executablePath = line.substring(XmlSnapshotProvider.HEADER_PREFIX.length(), line.indexOf(XmlSnapshotProvider.HEADER_SUFFIX));
                if (!executablePath.trim().isEmpty()) return Path.fromPortableString((String)executablePath);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
    }
}

