/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot.provider;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.ibboost.orqa.core.ThreadDumper;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.problem.Problem;
import org.ibboost.orqa.report.ReportTools;
import org.ibboost.orqa.report.snapshot.SnapshotParser;
import org.ibboost.orqa.report.snapshot.StandardHeaderSnapshotParser;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class ThreadDumpSnapshotProvider
implements SnapshotProvider {
    public static final String ID = "thread.snapshot";
    private static final String HEADER_PREFIX = "#Thread Dump - ";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return "Thread dump";
    }

    @Override
    public List<Snapshot> getSnapshots(ExecutionContext context, Problem problem) throws Exception {
        String result = ThreadDumper.getThreadDump();
        if (context != null) {
            String executablePath = ReportTools.getExecutablePath((ExecutionContext)context.getRootContext());
            result = StandardHeaderSnapshotParser.addHeader(result, executablePath, HEADER_PREFIX);
        }
        return Arrays.asList(new Snapshot(result, result.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean supportsStandalone() {
        return true;
    }

    @Override
    public List<Snapshot> getStandaloneSnapshots() throws Exception {
        return this.getSnapshots(null, null);
    }

    @Override
    public boolean handlesSnapshot(String operationId, String executorExtension) {
        return true;
    }

    @Override
    public String getExtension() {
        return "threaddump";
    }

    @Override
    public String getFileNameSuffix() {
        return null;
    }

    @Override
    public SnapshotParser getSnapshotParser() {
        return new StandardHeaderSnapshotParser("threaddump", HEADER_PREFIX);
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public void initialise(ExecutionContext rootContext) {
        ThreadDumper.setEnabledForCurrentThread((boolean)false);
    }

    @Override
    public void shutdown(ExecutionContext rootContext) {
        ThreadDumper.setEnabledForCurrentThread((boolean)true);
    }
}

