/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot.provider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.problem.Problem;
import org.ibboost.orqa.report.ReportTools;
import org.ibboost.orqa.report.snapshot.ImageUtils;
import org.ibboost.orqa.report.snapshot.SnapshotParser;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ScreenshotSnapshotProvider
implements SnapshotProvider {
    @Override
    public String getExtension() {
        return "png";
    }

    @Override
    public List<Snapshot> getSnapshots(ExecutionContext context, Problem problem) throws Exception {
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        String executablePath = context == null ? null : ReportTools.getExecutablePath((ExecutionContext)context.getRootContext());
        try {
            for (BufferedImage image : this.getScreenshots(context)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageUtils.encodeImageWithExecutableExifData(image, executablePath, null, outputStream);
                result.add(new Snapshot(image, outputStream.toByteArray()));
            }
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        return result;
    }

    @Override
    public boolean supportsStandalone() {
        return false;
    }

    @Override
    public List<Snapshot> getStandaloneSnapshots() throws Exception {
        return this.getSnapshots(null, null);
    }

    @Override
    public SnapshotParser getSnapshotParser() {
        return new ScreenshotReportParser();
    }

    public abstract List<BufferedImage> getScreenshots(ExecutionContext var1) throws Exception;

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public void initialise(ExecutionContext rootContext) {
    }

    @Override
    public void shutdown(ExecutionContext rootContext) {
    }

    public static class ScreenshotReportParser
    extends SnapshotParser {
        public IPath getReportExecutable(File reportFile) throws IOException {
            if (!reportFile.isFile()) {
                return null;
            }
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("PNG").next();
            imageReader.setInput(ImageIO.createImageInputStream(reportFile));
            IIOMetadata metadata = imageReader.getImageMetadata(0);
            String[] stringArray = metadata.getMetadataFormatNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String metadataFormatName = stringArray[n2];
                Node tree = metadata.getAsTree(metadataFormatName);
                String executablePath = ScreenshotReportParser.findCustomProperty(tree, "root_executable");
                if (executablePath != null && !executablePath.trim().isEmpty()) {
                    return Path.fromPortableString((String)executablePath);
                }
                ++n2;
            }
            return null;
        }

        private static String findCustomProperty(Node root, String propertyName) {
            NodeList childNodes = root.getChildNodes();
            NamedNodeMap attributes = root.getAttributes();
            boolean isTargetNode = false;
            String value = null;
            int attributeIndex = 0;
            while (attributeIndex < attributes.getLength()) {
                Node attribute = attributes.item(attributeIndex);
                if ("keyword".equals(attribute.getNodeName())) {
                    isTargetNode = propertyName.equals(attribute.getNodeValue());
                }
                if ("value".equals(attribute.getNodeName())) {
                    value = attribute.getNodeValue();
                }
                ++attributeIndex;
            }
            if (isTargetNode) {
                return value != null ? value : "";
            }
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                String childResult = ScreenshotReportParser.findCustomProperty(childNode, propertyName);
                if (childResult != null) {
                    return childResult;
                }
                ++i;
            }
            return null;
        }

        public List<String> getSupportedFileExtensions() {
            return Arrays.asList("png");
        }
    }
}

