/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot.provider;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.OSUtils;
import org.ibboost.orqa.core.ProcessUtils;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.problem.Problem;
import org.ibboost.orqa.report.ReportTools;
import org.ibboost.orqa.report.snapshot.SnapshotParser;
import org.ibboost.orqa.report.snapshot.StandardHeaderSnapshotParser;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class ProcessInfoSnapshotProvider
implements SnapshotProvider {
    private static final Logger LOG = Logger.getLogger(ProcessInfoSnapshotProvider.class);
    private static final String HEADER_PREFIX = "#Process Info Snapshot - ";
    private static final String EXTENSION = "procinfo";
    public static final String ID = "process.snapshot";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return "Process info snapshot";
    }

    @Override
    public List<Snapshot> getSnapshots(ExecutionContext context, Problem problem) throws Exception {
        String[] command;
        String osName = System.getProperty("os.name");
        if (OSUtils.isWindows()) {
            command = new String[]{"powershell", "-Command", "Get-WmiObject -Query 'Select * from Win32_PerfFormattedData_PerfProc_Process' | Select-Object -Property IDProcess,Name,PercentProcessorTime,WorkingSet"};
        } else if (OSUtils.isLinux()) {
            command = new String[]{"top", "-b", "-n1"};
        } else if (OSUtils.isMacOs()) {
            command = new String[]{"top", "-l1"};
        } else {
            LOG.info(String.format("Process info snapshot unsupported for os: %s", osName));
            return null;
        }
        Object result = ProcessUtils.runCommand((String)"take top CPU / memory usage snapshot", null, null, (boolean)false, (String[])command).trim() + System.lineSeparator();
        if (context != null) {
            String executablePath = ReportTools.getExecutablePath((ExecutionContext)context.getRootContext());
            result = StandardHeaderSnapshotParser.addHeader((String)result, executablePath, HEADER_PREFIX);
        }
        return Arrays.asList(new Snapshot(result, ((String)result).getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean supportsStandalone() {
        return true;
    }

    @Override
    public List<Snapshot> getStandaloneSnapshots() throws Exception {
        return this.getSnapshots(null, null);
    }

    @Override
    public boolean handlesSnapshot(String operationId, String executorExtension) {
        return true;
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public String getFileNameSuffix() {
        return null;
    }

    @Override
    public SnapshotParser getSnapshotParser() {
        return new StandardHeaderSnapshotParser(EXTENSION, HEADER_PREFIX);
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public void initialise(ExecutionContext rootContext) {
    }

    @Override
    public void shutdown(ExecutionContext rootContext) {
    }
}

