/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.ibboost.orqa.report.snapshot.SnapshotParser;

public class StandardHeaderSnapshotParser
extends SnapshotParser {
    private final String extension;
    private final String headerPrefix;

    public StandardHeaderSnapshotParser(String extension, String headerPrefix) {
        this.extension = extension;
        this.headerPrefix = headerPrefix;
    }

    public List<String> getSupportedFileExtensions() {
        return Arrays.asList(this.extension);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPath getReportExecutable(File reportFile) throws IOException {
        if (!reportFile.isFile()) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<String> lines = Files.lines(reportFile.toPath(), StandardCharsets.UTF_8);){
            Iterator iterator = lines.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            String line = ((String)iterator.next()).trim();
            if (!line.startsWith(this.headerPrefix)) {
                return null;
            }
            String executablePath = line.substring(this.headerPrefix.length());
            if (!executablePath.trim().isEmpty()) return Path.fromPortableString((String)executablePath.trim());
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static String addHeader(String snapshotBody, String executablePath, String headerPrefix) {
        return headerPrefix + executablePath + System.lineSeparator() + snapshotBody;
    }
}

