/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.StringUtils;
import org.ibboost.orqa.core.execution.preferences.ModelPreferenceTools;
import org.ibboost.orqa.core.ui.TableControl;
import org.ibboost.orqa.report.snapshot.SnapshotProviderManager;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class SnapshotReportPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOG = Logger.getLogger(SnapshotReportPreferences.class);
    private static final String ENABLED_BY_DEFAULT_PROPERTY = "snapshotsEnabledByDefault";
    private static final String PREFERENCE_STORE_ID = "org.ibboost.orqa.report.snapshot";
    public static final String INCLUDE_OPERATION_SCREENSHOTS = "logOperationScreenshots";
    private TableControl<SnapshotProviderConfig> snapshotProviderTable;

    public static synchronized IPreferenceStore getStore() {
        boolean storeInitialised = ModelPreferenceTools.isStoreInitialised((String)PREFERENCE_STORE_ID);
        IPreferenceStore store = ModelPreferenceTools.getModelPreferenceStore((String)PREFERENCE_STORE_ID);
        if (!storeInitialised) {
            store.setDefault(INCLUDE_OPERATION_SCREENSHOTS, false);
        }
        return store;
    }

    public static boolean isEnabled(SnapshotProvider snapshotProvider) {
        String enabled = SnapshotReportPreferences.getStore().getString(SnapshotReportPreferences.getEnabledProperty(snapshotProvider));
        if ("true".equalsIgnoreCase(enabled)) {
            return true;
        }
        if ("false".equalsIgnoreCase(enabled)) {
            return false;
        }
        String enabledByDefault = System.getProperty(ENABLED_BY_DEFAULT_PROPERTY, "");
        String[] stringArray = enabledByDefault.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            entry = entry.trim();
            if (snapshotProvider.getId().matches(StringUtils.createWildcardRegex((String)entry.trim()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SnapshotReportPreferences.getStore());
    }

    private static String getEnabledProperty(SnapshotProvider snapshotProvider) {
        return snapshotProvider.getId() + ".enable";
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(INCLUDE_OPERATION_SCREENSHOTS, "Include a copy of all &operation screenshots in the snapshots folder", parent));
    }

    protected Control createContents(Composite parent) {
        super.createContents(parent);
        this.snapshotProviderTable = SnapshotReportPreferences.createProviderConfigTable(this.getSnapshotProivderConfiguration(), parent);
        return null;
    }

    private List<SnapshotProviderConfig> getSnapshotProivderConfiguration() {
        ArrayList<SnapshotProviderConfig> result = new ArrayList<SnapshotProviderConfig>();
        ArrayList<SnapshotProviderConfig> defaultSnapshotProviders = new ArrayList<SnapshotProviderConfig>();
        ArrayList<SnapshotProviderConfig> additionalSnapshotProviders = new ArrayList<SnapshotProviderConfig>();
        for (SnapshotProvider snapshotProvider : SnapshotProviderManager.getSnapshotProviders()) {
            SnapshotProviderConfig entry = new SnapshotProviderConfig(snapshotProvider);
            entry.setEnabled(SnapshotReportPreferences.isEnabled(snapshotProvider));
            if (Arrays.asList("desktop.screenshot", "thread.snapshot", "thread.delayed.snapshot", "process.snapshot").contains(snapshotProvider.getId())) {
                defaultSnapshotProviders.add(entry);
                continue;
            }
            additionalSnapshotProviders.add(entry);
        }
        Comparator<SnapshotProviderConfig> snapshotProivderComparator = new Comparator<SnapshotProviderConfig>(){

            @Override
            public int compare(SnapshotProviderConfig s1, SnapshotProviderConfig s2) {
                return s1.getSnapshotProvider().getDisplayName().compareTo(s2.getSnapshotProvider().getDisplayName());
            }
        };
        Collections.sort(defaultSnapshotProviders, snapshotProivderComparator);
        Collections.sort(additionalSnapshotProviders, snapshotProivderComparator);
        result.addAll(defaultSnapshotProviders);
        result.addAll(additionalSnapshotProviders);
        return result;
    }

    public static void storeProviderConfig(List<SnapshotProviderConfig> snapshotProviderConfig) {
        for (SnapshotProviderConfig entry : snapshotProviderConfig) {
            SnapshotReportPreferences.getStore().setValue(SnapshotReportPreferences.getEnabledProperty(entry.getSnapshotProvider()), Boolean.toString(entry.isEnabled()));
        }
        try {
            ((IPersistentPreferenceStore)SnapshotReportPreferences.getStore()).save();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static TableControl<SnapshotProviderConfig> createProviderConfigTable(List<SnapshotProviderConfig> input, Composite parent) {
        TableControl<SnapshotProviderConfig> table = new TableControl<SnapshotProviderConfig>(parent, 2080){

            public boolean isChecked(SnapshotProviderConfig element) {
                return element.isEnabled();
            }

            public void setChecked(SnapshotProviderConfig element, boolean checked) {
                element.setEnabled(checked);
            }
        };
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableControl<SnapshotProviderConfig> tableControl = table;
        tableControl.getClass();
        new TableControl.Column((TableControl)tableControl, "Log the following snapshots when errors are reported", 16384, 1, 150){

            protected String getText(SnapshotProviderConfig element) {
                return element.getSnapshotProvider().getDisplayName();
            }

            protected void setText(SnapshotProviderConfig element, String value) {
            }
        };
        table.setInput(input);
        GridData layoutData = (GridData)table.getLayoutData();
        layoutData.heightHint = 150;
        return table;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        SnapshotReportPreferences.storeProviderConfig(this.snapshotProviderTable.getInput());
        return result;
    }

    private static class SnapshotProviderConfig {
        private final SnapshotProvider provider;
        private boolean enabled;

        public SnapshotProviderConfig(SnapshotProvider provider) {
            this.provider = provider;
        }

        public SnapshotProvider getSnapshotProvider() {
            return this.provider;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

