/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.ibboost.orqa.report.ReportParser;
import org.ibboost.orqa.report.snapshot.SnapshotProviderManager;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class SnapshotReportParser
extends ReportParser {
    public IPath getReportExecutable(File reportFile) throws IOException {
        ReportParser reportParser = SnapshotReportParser.getReportParserForFile(reportFile);
        if (reportParser == null) {
            return null;
        }
        return reportParser.getReportExecutable(reportFile);
    }

    private static ReportParser getReportParserForFile(File reportFile) {
        String extension;
        String string = extension = reportFile.getName().contains(".") ? reportFile.getName().substring(reportFile.getName().lastIndexOf(".") + 1) : null;
        if (extension == null) {
            return null;
        }
        for (SnapshotProvider snapshotProvider : SnapshotProviderManager.getSnapshotProviders()) {
            if (!snapshotProvider.getExtension().equalsIgnoreCase(extension)) continue;
            return snapshotProvider.getSnapshotParser();
        }
        return null;
    }

    public List<String> getSupportedFileExtensions() {
        HashSet<String> result = new HashSet<String>();
        for (SnapshotProvider snapshotProvider : SnapshotProviderManager.getSnapshotProviders()) {
            result.add(snapshotProvider.getExtension());
        }
        return new ArrayList<String>(result);
    }

    public String getCategory() {
        return "Snapshot";
    }
}

