/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import org.eclipse.core.filesystem.IFileStore;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.execution.registry.FileExecutorDescriptor;
import org.ibboost.orqa.core.execution.registry.IExecutorDescriptor;
import org.ibboost.orqa.core.execution.registry.OperationExecutorDescriptor;
import org.ibboost.orqa.core.execution.results.IExecutionListener;
import org.ibboost.orqa.core.problem.Problem;
import org.ibboost.orqa.core.problem.ProblemLevel;
import org.ibboost.orqa.report.ReportManager;
import org.ibboost.orqa.report.ReportTools;
import org.ibboost.orqa.report.snapshot.ImageUtils;
import org.ibboost.orqa.report.snapshot.SnapshotProviderManager;
import org.ibboost.orqa.report.snapshot.SnapshotReportPreferences;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class SnapshotReportListener
implements IExecutionListener {
    private static final Logger LOG = Logger.getLogger(SnapshotReportListener.class);
    public static final String REPORT_TYPE = "Snapshot";
    public static final String REPORT_EXTENSION = "png";
    public static final String ROOT_EXECUTABLE_PROPERTY = "root_executable";
    private List<SnapshotProvider> snapshotProviders = new ArrayList<SnapshotProvider>();
    private final boolean logScreenshots = SnapshotReportPreferences.getStore().getBoolean("logOperationScreenshots");
    private File reportDirectory;
    private String snapshotFilePrefix;

    public boolean isActive() {
        return true;
    }

    public int getSuportedModes() {
        return 1;
    }

    public void executionStarted(ExecutionContext context) {
        if (context.isRootReport()) {
            for (SnapshotProvider provider : SnapshotProviderManager.getSnapshotProviders()) {
                if (!SnapshotReportPreferences.isEnabled(provider)) continue;
                this.snapshotProviders.add(provider);
                provider.initialise(context);
            }
            try {
                this.reportDirectory = ReportTools.getNewReportFile((ExecutionContext)context, (String)REPORT_TYPE, null);
                this.snapshotFilePrefix = context.getName() + "-";
            }
            catch (Exception e) {
                LOG.error(e.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    public void executionRestarted(ExecutionContext context) {
    }

    public void executionFinished(ExecutionContext context) {
        if (context.isRootReport()) {
            for (SnapshotProvider provider : this.snapshotProviders) {
                provider.shutdown(context);
            }
        }
    }

    public void problemReported(ExecutionContext context, Problem problem) {
        if (problem.getProblemLevel() == ProblemLevel.ERROR && !context.shouldSuppressProblemReports()) {
            this.logSnapshots(context, problem);
        }
    }

    public void logProblem(ExecutionContext problemContext, ExecutionContext suppressorContext, Problem problem) {
        if (problem.getProblemLevel() == ProblemLevel.ERROR && !suppressorContext.shouldSuppressProblemReports()) {
            this.logSnapshots(problemContext, problem);
        }
    }

    private void logSnapshots(final ExecutionContext context, final Problem problem) {
        this.reportDirectory.mkdirs();
        for (final SnapshotProvider snapshotProvider : this.getSnapshotProvidersForContext(context)) {
            if (snapshotProvider.getDelay() == 0) {
                this.logSnapshot(snapshotProvider, context, problem);
                continue;
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(snapshotProvider.getDelay());
                        SnapshotReportListener.this.logSnapshot(snapshotProvider, context, problem);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    private void logSnapshot(SnapshotProvider snapshotProvider, ExecutionContext context, Problem problem) {
        try {
            List<Snapshot> snapshots = snapshotProvider.getSnapshots(context, problem);
            int i = 0;
            while (i < snapshots.size()) {
                Snapshot snapshot = snapshots.get(i);
                String fileName = this.snapshotFilePrefix + ReportTools.REPORT_FILE_TIMESTAMP_FORMAT.format(new Date());
                String fileNameSuffix = snapshotProvider.getFileNameSuffix();
                if (fileNameSuffix != null && !fileNameSuffix.isEmpty()) {
                    fileName = fileName + "_" + fileNameSuffix;
                }
                if (snapshots.size() > 1) {
                    fileName = fileName + "_" + (i + 1);
                }
                fileName = fileName + "." + snapshotProvider.getExtension();
                File snapshotFile = this.getReportFile(fileName);
                snapshotFile.getParentFile().mkdirs();
                Files.write(snapshotFile.toPath(), snapshot.getSerialised(), new OpenOption[0]);
                ReportManager.reportComplete((ExecutionContext)context.getRootContext(), (String)REPORT_TYPE, (File)snapshotFile, null);
                LOG.info(String.format("Stored %s due to error in executable '%s' at '%s'", snapshotProvider.getDisplayName(), context.getName(), snapshotFile.getPath()));
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
        }
    }

    private List<SnapshotProvider> getSnapshotProvidersForContext(ExecutionContext context) {
        ArrayList<SnapshotProvider> result = new ArrayList<SnapshotProvider>();
        IExecutorDescriptor descriptor = context.getDescriptor();
        if (descriptor != null) {
            String operationId = null;
            String executorExtension = null;
            if (descriptor instanceof OperationExecutorDescriptor) {
                operationId = ((OperationExecutorDescriptor)descriptor).getExecutorId();
            } else if (descriptor instanceof FileExecutorDescriptor) {
                executorExtension = ((FileExecutorDescriptor)descriptor).getFilePath().getFileExtension();
            }
            for (SnapshotProvider provider : this.snapshotProviders) {
                if (!provider.handlesSnapshot(operationId, executorExtension)) continue;
                result.add(provider);
            }
        }
        return result;
    }

    public void statusUpdated(ExecutionContext context) {
    }

    public void artifactAdded(ExecutionContext context, IFileStore artifact) {
        if (this.logScreenshots && this.isScreenshot(context, artifact)) {
            this.reportDirectory.mkdirs();
            File reportFile = this.getReportFile(artifact.getName());
            try {
                ExecutionContext rootContext = context.getRootContext();
                SnapshotReportListener.copyArtifactPNG(artifact, reportFile, ReportTools.getExecutablePath((ExecutionContext)context.getRootContext()));
                ReportManager.reportComplete((ExecutionContext)rootContext, (String)REPORT_TYPE, (File)reportFile, null);
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void artifactRemoved(ExecutionContext context, IFileStore artifact) {
    }

    private File getReportFile(String fileName) {
        return new File(this.reportDirectory, fileName);
    }

    private boolean isScreenshot(ExecutionContext context, IFileStore artifact) {
        if (!(context.getDescriptor() instanceof OperationExecutorDescriptor)) {
            return false;
        }
        String opId = context.getDescriptor().getExecutorId();
        return opId.endsWith(".screenshot");
    }

    /*
     * Loose catch block
     */
    private static void copyArtifactPNG(IFileStore artifact, File target, String executablePath) throws Exception {
        if (executablePath != null && !executablePath.trim().isEmpty()) {
            try {
                Throwable throwable = null;
                Object var4_9 = null;
                try {
                    FileOutputStream outputStream;
                    InputStream inputStream;
                    block30: {
                        block29: {
                            inputStream = artifact.openInputStream(0, null);
                            outputStream = new FileOutputStream(target);
                            ImageReader imageReader = ImageIO.getImageReadersByFormatName("PNG").next();
                            imageReader.setInput(ImageIO.createImageInputStream(inputStream));
                            IIOMetadata metadata = imageReader.getImageMetadata(0);
                            BufferedImage image = imageReader.read(0, imageReader.getDefaultReadParam());
                            ImageUtils.encodeImageWithExecutableExifData(image, executablePath, metadata, outputStream);
                            if (outputStream == null) break block29;
                            ((OutputStream)outputStream).close();
                        }
                        if (inputStream == null) break block30;
                        inputStream.close();
                    }
                    return;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (outputStream != null) {
                                    ((OutputStream)outputStream).close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        try {
            Throwable e = null;
            Object var4_12 = null;
            try (InputStream inputStream = artifact.openInputStream(0, null);){
                Files.copy(inputStream, target.toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

