/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class SnapshotProviderManager {
    private static final Logger LOG = Logger.getLogger(SnapshotProviderManager.class);
    private static List<SnapshotProvider> snapshotProviders = null;

    public static synchronized List<SnapshotProvider> getSnapshotProviders() {
        if (snapshotProviders != null) {
            return snapshotProviders;
        }
        final HashMap<SnapshotProvider, Integer> priorities = new HashMap<SnapshotProvider, Integer>();
        snapshotProviders = new ArrayList<SnapshotProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] configElements;
            IConfigurationElement[] iConfigurationElementArray = configElements = registry.getConfigurationElementsFor("org.ibboost.orqa.report.snapshot.provider");
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                try {
                    SnapshotProvider provider = (SnapshotProvider)SnapshotProvider.class.cast(configElement.createExecutableExtension("class"));
                    snapshotProviders.add(provider);
                    String priority = configElement.getAttribute("priority");
                    if (priority != null && !priority.trim().isEmpty()) {
                        priorities.put(provider, Integer.parseInt(priority));
                    }
                }
                catch (CoreException e) {
                    LOG.error(((Object)((Object)e)).getClass().getSimpleName(), (Throwable)e);
                }
                ++n2;
            }
        }
        Collections.sort(snapshotProviders, new Comparator<SnapshotProvider>(){

            @Override
            public int compare(SnapshotProvider left, SnapshotProvider right) {
                int leftPriority = priorities.containsKey(left) ? (Integer)priorities.get(left) : Integer.MAX_VALUE;
                int rightPriority = priorities.containsKey(right) ? (Integer)priorities.get(right) : Integer.MAX_VALUE;
                return Integer.compare(leftPriority, rightPriority);
            }
        });
        return snapshotProviders;
    }
}

