/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.about.InstallationPage;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.execution.results.ExceptionMessages;
import org.ibboost.orqa.core.execution.summaries.ISummary;
import org.ibboost.orqa.core.execution.summaries.ImageSummary;
import org.ibboost.orqa.core.execution.summaries.SummaryFactory;
import org.ibboost.orqa.report.snapshot.SnapshotProviderManager;
import org.ibboost.orqa.report.snapshot.provider.Snapshot;
import org.ibboost.orqa.report.snapshot.provider.SnapshotProvider;

public class SnapshotInstallationPage
extends InstallationPage {
    private static final Logger LOG = Logger.getLogger(SnapshotProviderManager.class);
    private static final SimpleDateFormat FILENAME_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private Combo providerCombo;
    private List<SnapshotProvider> snapshotProviders;
    private SashForm previewContainer;
    private Button saveButton;
    private Button refreshButton;
    private Label errorLabel;
    private Snapshot currentSnapshot;

    public void createControl(Composite parent) {
        int layoutWidth = 5;
        parent.setLayout((Layout)new GridLayout(layoutWidth, false));
        Label label = new Label(parent, 0);
        label.setText("Snapshot Type");
        this.providerCombo = new Combo(parent, 8);
        this.snapshotProviders = new ArrayList<SnapshotProvider>();
        for (SnapshotProvider snapshotProvider : SnapshotProviderManager.getSnapshotProviders()) {
            if (!snapshotProvider.supportsStandalone()) continue;
            this.snapshotProviders.add(snapshotProvider);
            this.providerCombo.add(snapshotProvider.getDisplayName());
        }
        new Label(parent, 0).setLayoutData((Object)new GridData(768));
        this.refreshButton = new Button(parent, 8);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setEnabled(false);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnapshotInstallationPage.this.updateSnapshot(SnapshotInstallationPage.this.getSelection());
            }
        });
        this.saveButton = new Button(parent, 8);
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnapshotInstallationPage.this.saveSnapshot();
            }
        });
        this.previewContainer = new SashForm(parent, 2304);
        GridData previewContainerData = new GridData(1808);
        previewContainerData.horizontalSpan = layoutWidth;
        this.previewContainer.setLayoutData((Object)previewContainerData);
        this.errorLabel = new Label(parent, 0);
        GridData errorLabelLayoutData = new GridData(768);
        errorLabelLayoutData.horizontalSpan = layoutWidth;
        this.errorLabel.setLayoutData((Object)errorLabelLayoutData);
        this.providerCombo.addModifyListener(e -> this.updateSnapshot(this.getSelection()));
    }

    private void saveSnapshot() {
        SnapshotProvider provider = this.getSelection();
        Snapshot snapshot = this.currentSnapshot;
        if (snapshot == null || provider == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.saveButton.getShell(), 8192);
        dialog.setText(String.format("%s Snapshot", provider.getDisplayName()));
        String filename = String.format("%s Snapshot - %s.%s", provider.getDisplayName(), FILENAME_TIMESTAMP_FORMAT.format(snapshot.getTime()), provider.getExtension());
        dialog.setFileName(filename);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        new Thread(() -> {
            File file = new File(result);
            try {
                file.getParentFile().mkdirs();
                Files.write(file.toPath(), snapshot.getSerialised(), new OpenOption[0]);
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                this.errorLabel.getDisplay().asyncExec(() -> {
                    if (!this.errorLabel.isDisposed()) {
                        this.errorLabel.setText("Error saving snapshot: " + ExceptionMessages.getExceptionMessage((Throwable)e));
                    }
                });
            }
        }).start();
    }

    private SnapshotProvider getSelection() {
        if (this.providerCombo.isDisposed()) {
            return null;
        }
        int selectionIndex = this.providerCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.snapshotProviders.size()) {
            return null;
        }
        return this.snapshotProviders.get(selectionIndex);
    }

    private void updateSnapshot(Snapshot snapshot, SnapshotProvider provider, String errorMessage) {
        this.previewContainer.getDisplay().asyncExec(() -> {
            if (this.previewContainer.isDisposed() || provider != null && this.getSelection() != provider) {
                return;
            }
            Control[] controlArray = this.previewContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            this.errorLabel.setText((String)(errorMessage == null || errorMessage.isBlank() ? "" : "Error loading snapshot: " + errorMessage));
            this.refreshButton.setEnabled(provider != null);
            this.saveButton.setEnabled(snapshot != null);
            this.currentSnapshot = snapshot;
            if (snapshot == null || snapshot.getSnapshot() == null) {
                return;
            }
            Object snapshotObject = snapshot.getSnapshot();
            if (snapshotObject instanceof BufferedImage) {
                ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(snapshot.getSerialised()));
                new ImageSummary(imageData).createViewer((Composite)this.previewContainer);
            } else if (snapshotObject instanceof String) {
                Text textControl = new Text((Composite)this.previewContainer, 584);
                textControl.setBackground(this.previewContainer.getDisplay().getSystemColor(25));
                textControl.setText((String)snapshotObject);
            } else {
                ISummary summary = SummaryFactory.createSummary((Object)snapshotObject);
                if (summary != null) {
                    summary.createViewer((Composite)this.previewContainer);
                }
            }
            this.previewContainer.getParent().layout(true, true);
        });
    }

    private void updateSnapshot(SnapshotProvider provider) {
        if (provider == null) {
            return;
        }
        new Thread(() -> {
            try {
                List<Snapshot> snapshots = provider.getStandaloneSnapshots();
                Snapshot snapshot = snapshots == null || snapshots.isEmpty() ? null : snapshots.getFirst();
                this.updateSnapshot(snapshot, provider, null);
            }
            catch (Exception e) {
                this.updateSnapshot(null, null, ExceptionMessages.getExceptionMessage((Throwable)e));
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }).start();
    }
}

