/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.report.snapshot;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;

public class ImageUtils {
    public static final String ROOT_EXECUTABLE_PROPERTY = "root_executable";

    public static void encodeImageWithExecutableExifData(BufferedImage image, String executablePath, IIOMetadata metadata, OutputStream outputStream) throws Exception {
        if (executablePath != null && !executablePath.trim().isEmpty()) {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("PNG").next();
            ImageWriteParam writeParm = imageWriter.getDefaultWriteParam();
            if (metadata == null) {
                metadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromRenderedImage(image), writeParm);
            }
            IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
            textEntry.setAttribute("keyword", ROOT_EXECUTABLE_PROPERTY);
            textEntry.setAttribute("value", executablePath);
            IIOMetadataNode text = new IIOMetadataNode("tEXt");
            text.appendChild(textEntry);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
            root.appendChild(text);
            metadata.mergeTree(root.getNodeName(), root);
            imageWriter.setOutput(ImageIO.createImageOutputStream(outputStream));
            imageWriter.write(metadata, new IIOImage(image, null, metadata), writeParm);
        } else {
            ImageIO.write((RenderedImage)image, "PNG", outputStream);
        }
    }

    public static BufferedImage takeScreenshot() throws Exception {
        GraphicsDevice[] displays = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (displays.length == 0) {
            throw new Exception("Unable to log screenshot, no display detected");
        }
        Double minScale = null;
        GraphicsDevice[] graphicsDeviceArray = displays;
        int n = displays.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice display = graphicsDeviceArray[n2];
            double scale = (double)display.getDisplayMode().getWidth() / display.getDefaultConfiguration().getBounds().getWidth();
            minScale = minScale == null ? scale : Math.min(minScale, scale);
            ++n2;
        }
        Rectangle screenshotBounds = null;
        GraphicsDevice[] graphicsDeviceArray2 = displays;
        int n3 = displays.length;
        n = 0;
        while (n < n3) {
            GraphicsDevice display = graphicsDeviceArray2[n];
            Rectangle scaledBounds = display.getDefaultConfiguration().getBounds();
            int nativeXOffset = (int)Math.ceil((double)scaledBounds.x * minScale);
            int nativeYOffset = (int)Math.ceil((double)scaledBounds.y * minScale);
            DisplayMode displayMode = display.getDisplayMode();
            Rectangle nativeBounds = new Rectangle(nativeXOffset, nativeYOffset, displayMode.getWidth(), displayMode.getHeight());
            screenshotBounds = screenshotBounds == null ? nativeBounds : screenshotBounds.union(nativeBounds);
            ++n;
        }
        return new Robot().createScreenCapture(screenshotBounds);
    }
}

