/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license.commands;

import java.io.File;
import java.util.Map;
import org.ibboost.orqa.core.ArgParser;
import org.ibboost.orqa.core.CommandOptions;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.startup.StartupExtension;
import org.ibboost.orqa.core.startup.StartupResult;
import org.ibboost.orqa.license.ILicense;
import org.ibboost.orqa.license.LicenseManager;
import org.ibboost.orqa.license.LicenseTools;

public class LicenseCommand
implements StartupExtension {
    private static final Logger LOG = Logger.getLogger(LicenseCommand.class);
    private static final String FILE = "file";

    public StartupResult startup(String[] args) {
        CommandOptions options = CommandOptions.parse((String[])args);
        Map params = ArgParser.getParamsMap((String[])args);
        ILicense license = null;
        File licenseFile = null;
        Exception licenseError = null;
        if (params.containsKey(FILE)) {
            File f = new File((String)params.get(FILE));
            if (!f.exists()) {
                System.out.println("Provided license file does not exist");
                return StartupResult.INVALID_ARGUMENT;
            }
            try {
                license = LicenseManager.load(f);
                licenseFile = f;
            }
            catch (Exception e) {
                licenseError = e;
            }
        } else {
            license = LicenseManager.getLicense();
            licenseFile = LicenseManager.getLicenseFile();
            licenseError = LicenseManager.getLicenseError();
        }
        if (license == null) {
            licenseError = LicenseCommand.safeLicenseError(licenseError);
            System.out.println("Error loading license: " + licenseError.getMessage());
            LOG.error("Error loading license", (Throwable)licenseError);
            return StartupResult.ERRORED;
        }
        boolean hasCliSpecificExpiryDate = LicenseTools.hasCliSpecificExpiryDate(license);
        System.out.println("----------------------------------------------------------------------");
        System.out.println("License Information:");
        String filePath = licenseFile != null ? licenseFile.getAbsolutePath() : "";
        System.out.println("\tLicense File: \t\t\t" + filePath);
        System.out.println("\tLicensee: \t\t\t" + license.getLicensee());
        System.out.println("\tExpiry Date: \t\t\t" + license.getExpiryDate());
        if (hasCliSpecificExpiryDate) {
            System.out.println("\tCLI Expiry Date: \t\t" + license.getCliExpiryDate());
        }
        System.out.println("\tExpired: \t\t\t" + license.hasExpired());
        if (hasCliSpecificExpiryDate) {
            System.out.println("\tCLI Expired: \t\t\t" + license.cliHasExpired());
        }
        if (license.getDistributions() != null) {
            System.out.println("\tDistributions: \t\t\t" + license.getDistributions());
        }
        if (license.getHardwareAddresses() != null && license.getHardwareAddresses().length > 0) {
            System.out.println("\tHardware Addresses: \t\t" + LicenseTools.hardwareAddressListToString(license.getHardwareAddresses()));
        }
        System.out.println();
        System.out.println("----------------------------------------------------------------------");
        if (options.isVerbose()) {
            System.out.println("***** License Copy *****\n");
            System.out.println(license.getLicenseCopy());
        }
        return StartupResult.SUCCESS_AND_SHUTDOWN;
    }

    private static Exception safeLicenseError(Exception licenceError) {
        if (licenceError != null) {
            return licenceError;
        }
        return LicenseManager.LicenseException.DEFAULT_LICENSE_EXCEPTION;
    }

    public StartupResult autoStartup() {
        return StartupResult.NOT_EXECUTED;
    }

    public String getUsage() {
        return "Displays detailed licence information.\nUsage: \n\torqac licence <params>\n\tParameters: \n\t\tfile - File path to the licence (optional, will use the orqa instance license by default)\n\tOptions:\n\t\t--verbose Include the licence copy";
    }

    public String getShortDescription() {
        return "Displays detailed license information";
    }
}

