/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.security.MessageDigest;
import org.eclipse.core.runtime.Platform;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.startup.StartupExtension;
import org.ibboost.orqa.core.startup.StartupResult;
import org.ibboost.orqa.license.LicenseManager;
import org.ibboost.orqa.license.LicenseTools;

public class LicenceRequest
implements StartupExtension {
    public static final String MACHINE_NAME = "Machine Name";
    public static final String OS = "OS";
    public static final String HARDWARE_ADDRESSES = "Hardware Addresses";
    public static final String DISTRIBUTION = "Distribution";
    public static final String CHECKSUM = "Checksum";
    public static final String SEPARATOR = ":";
    private static final String REQUEST_HASH_SALT = "UQSVDYF5CCl9wdpAg2p3Ezr5";
    private static final String DISTRIBUTION_PROPERTY = "orqa.distro";
    private static final String REQUEST_FILE_NAME = "license_request.req";
    private static final String REQUEST_FILE_PATH = "licenses/license_request.req";
    private static final String DISPLAY_SEPARATOR = ": ";
    private static final Logger LOG = Logger.getLogger(LicenceRequest.class);

    public StartupResult startup(String[] args) {
        LicenceRequest.requestLicence(true);
        return StartupResult.SUCCESS_AND_SHUTDOWN;
    }

    private static File getLienceRequestFile() throws IOException {
        URL licenseURL = Platform.getInstallLocation().getDataArea(REQUEST_FILE_PATH);
        File licenseFile = new File(licenseURL.getFile());
        return licenseFile;
    }

    public static String getRequestHash(String request) {
        try {
            request = ((String)request).replaceAll("[^\\x20-\\x7F]", "") + REQUEST_HASH_SALT;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(((String)request).getBytes("UTF-8"));
            return String.format("%064x", new BigInteger(1, md.digest()));
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean verifyRequest(String request, String hash) {
        String expectedHash = LicenceRequest.getRequestHash(request);
        return expectedHash != null && expectedHash.equalsIgnoreCase(hash);
    }

    public static void requestLicence(boolean printMessage) {
        try {
            StringBuilder request = new StringBuilder();
            request.append(MACHINE_NAME).append(DISPLAY_SEPARATOR).append(InetAddress.getLocalHost().getHostName()).append("\r\n");
            request.append(OS).append(DISPLAY_SEPARATOR).append(System.getProperty("os.name")).append("\r\n");
            request.append(HARDWARE_ADDRESSES).append(DISPLAY_SEPARATOR);
            byte[][] hardwareAddresses = LicenseManager.getLocalMachineHardwareAddresses();
            request.append(LicenseTools.hardwareAddressListToString(hardwareAddresses));
            request.append("\r\n");
            String distro = System.getProperty(DISTRIBUTION_PROPERTY);
            if (distro == null) {
                distro = "";
            }
            if (!LicenseManager.verifyDistribution(distro = distro.trim())) {
                distro = "";
            }
            request.append(DISTRIBUTION).append(DISPLAY_SEPARATOR).append(distro).append("\r\n");
            String signature = LicenceRequest.getRequestHash(request.toString());
            request.append(CHECKSUM).append(DISPLAY_SEPARATOR).append(signature).append("\r\n");
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter writer = new PrintWriter(LicenceRequest.getLienceRequestFile(), "UTF-8");){
                writer.print(request.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (printMessage) {
                System.out.println(LicenceRequest.getRequestMessage());
            }
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static String getRequestFileDisplayPath() {
        try {
            return LicenceRequest.getLienceRequestFile().getCanonicalPath();
        }
        catch (Exception e) {
            return "Orqa/licenses/license_request.req";
        }
    }

    public static String getRequestMessage() {
        return "A license request file has been generated and stored in:\r\n" + LicenceRequest.getRequestFileDisplayPath() + "\r\n\r\nPlease provide this file to your authorised ORQA reseller or IB Boost at orqa@ibboost.com";
    }

    public StartupResult autoStartup() {
        return StartupResult.NOT_EXECUTED;
    }

    public String getUsage() {
        return "Creates a License Request File specific to this machine that can be sent to your authorised ORQA reseller or IB Boost.\r\nThe file will be stored at:\r\n" + LicenceRequest.getRequestFileDisplayPath();
    }

    public String getShortDescription() {
        return "Displays detailed license information";
    }
}

