/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public abstract class LoggingSocketFactory
extends PlainConnectionSocketFactory {
    public Socket createSocket(HttpContext context) throws IOException {
        return super.createSocket(context);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket wrappedSocket = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        return new LoggingSocket(wrappedSocket, remoteAddress);
    }

    public abstract File getOutputStreamLogFile(InetSocketAddress var1);

    public abstract File getInputStreamLogFile(InetSocketAddress var1);

    private static class LoggedInputStream
    extends InputStream {
        private InputStream source;
        private FileOutputStream logStream;

        public LoggedInputStream(InputStream source, File logFile) throws FileNotFoundException {
            this.source = source;
            logFile.getParentFile().mkdirs();
            this.logStream = new FileOutputStream(logFile);
        }

        @Override
        public int read() throws IOException {
            int result = this.source.read();
            if (result != -1) {
                this.logStream.write(result);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.source.read(b, off, len);
            this.logStream.write(b, off, result);
            return result;
        }

        @Override
        public void close() throws IOException {
            this.source.close();
            this.logStream.close();
        }
    }

    private static class LoggedOutputStream
    extends OutputStream {
        private OutputStream destination;
        private FileOutputStream logStream;

        public LoggedOutputStream(OutputStream destination, File logFile) throws FileNotFoundException {
            this.destination = destination;
            logFile.getParentFile().mkdirs();
            this.logStream = new FileOutputStream(logFile);
        }

        @Override
        public void write(int b) throws IOException {
            this.destination.write(b);
            this.logStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.destination.write(b, off, len);
            this.logStream.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.destination.close();
            this.logStream.close();
        }
    }

    private class LoggingSocket
    extends Socket {
        private final Socket wrappedSocket;
        private final InetSocketAddress remoteAddress;

        public LoggingSocket(Socket wrappedSocket, InetSocketAddress remoteAddress) throws FileNotFoundException {
            this.wrappedSocket = wrappedSocket;
            this.remoteAddress = remoteAddress;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new LoggedOutputStream(this.wrappedSocket.getOutputStream(), LoggingSocketFactory.this.getOutputStreamLogFile(this.remoteAddress));
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new LoggedInputStream(this.wrappedSocket.getInputStream(), LoggingSocketFactory.this.getInputStreamLogFile(this.remoteAddress));
        }
    }
}

