/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.ibboost.orqa.license.ILicense;

public class LicenseTools {
    public static String hardwareAddressListToString(byte[][] hardwareAddresses) {
        return LicenseTools.hardwareAddressListToString(hardwareAddresses, true, null);
    }

    public static String hardwareAddressListToString(byte[][] hardwareAddresses, boolean useWhitespace, Integer maxLength) {
        StringBuilder result = new StringBuilder();
        byte[][] byArray = hardwareAddresses;
        int n = hardwareAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] hardwareAddress = byArray[n2];
            StringBuilder entry = new StringBuilder();
            if (result.length() > 0) {
                entry.append(",");
            }
            if (useWhitespace) {
                entry.append(" ");
            }
            entry.append(LicenseTools.hardwareAddressToString(hardwareAddress));
            if (maxLength != null && maxLength > 0 && result.length() + entry.length() > maxLength) break;
            result.append((CharSequence)entry);
            ++n2;
        }
        return result.toString();
    }

    public static String hardwareAddressToString(byte[] hardwareAddress) {
        StringBuilder result = new StringBuilder();
        byte[] byArray = hardwareAddress;
        int n = hardwareAddress.length;
        int n2 = 0;
        while (n2 < n) {
            byte segment = byArray[n2];
            if (result.length() > 0) {
                result.append(':');
            }
            result.append(String.format("%02x", segment));
            ++n2;
        }
        return result.toString();
    }

    public static boolean addressListContainsAddress(byte[][] addressList, byte[] address) {
        byte[][] byArray = addressList;
        int n = addressList.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] potentialAddress = byArray[n2];
            if (Arrays.equals(potentialAddress, address)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String expiryDateToString(Date expiryDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM d, yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(expiryDate);
    }

    public static boolean hasCliSpecificExpiryDate(ILicense license) {
        if (license.getCliExpiryDate().isEmpty()) {
            return false;
        }
        if (!license.getExpiryDate().equals(license.getCliExpiryDate())) {
            return true;
        }
        if (license.getGraceCliExpiryDate() == null) {
            return false;
        }
        return !Objects.equals(license.getGraceExpiryDate(), license.getGraceCliExpiryDate());
    }
}

