/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.Json;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.ibboost.orqa.core.FileUtils;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.StringUtils;
import org.ibboost.orqa.core.ui.UsernameAndPasswordDialog;
import org.ibboost.orqa.license.LicenseManager;
import org.ibboost.orqa.license.LicenseTools;
import org.ibboost.orqa.license.LoggingSocketFactory;

public class LicenseServerClient {
    private static final SimpleDateFormat LOG_FILENAME_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
    private static final Logger LOG = Logger.getLogger(LicenseServerClient.class);
    private static final String ORQA_SERVER_PROPERTY = "orqa.server";
    private static final String REGISTRATION_ENDPOINT = "/api/license/register";
    private static final String DEREGISTRATION_ENDPOINT = "/api/license/deregister";
    private static final String REGISTRATION_RESULT = "result";
    private static final String REGISTRATION_OK = "OK";
    private static final String REJECTION_REASON = "reason";
    private static final String LICENSEE = "licensee";
    private static final String LICENSE_COPY = "licenseCopy";
    private static final String LEASE_LENGTH_MINUTES = "leaseLength";
    private static final String HARDWARE_ADDRESSES_HEADER = "hardwareAddresses";
    private static final String HOSTNAME_HEADER = "hostname";
    private static final String OS_HEADER = "os";
    private static final String LEASE_REQUIRED = "leaseRequired";
    private static final String RENEW = "renew";
    private static final String LICENSE_REQUEST_LOG_PROPERTY = "logLicenseRequest";
    private static final int MAX_HARDRWARE_ADDRESS_LENGTH = 255;
    private static final int MAX_HOSTNAME_LENGTH = 255;
    private static final int MAX_OSNAME_LENGTH = 255;

    /*
     * Unable to fully structure code
     */
    public static ServerLease registerWithLicenceServer(boolean leaseRequired, boolean renew, boolean allowProxyAuthPrompt) throws Exception {
        block36: {
            licenceServerUrl = LicenseServerClient.getLicenceServerAddress();
            if (!licenceServerUrl.isEmpty()) break block36;
            return null;
        }
        try {
            licenceServerUrl = (String)licenceServerUrl + "/api/license/register";
            hardwareAddresslist = LicenseTools.hardwareAddressListToString(LicenseManager.getLocalMachineHardwareAddresses(), false, null);
            hostname = InetAddress.getLocalHost().getHostName();
            if (hostname != null && hostname.length() > 255) {
                hostname = hostname.substring(0, 255);
            }
            if ((os = System.getProperty("os.name")) != null && os.length() > 255) {
                os = os.substring(0, 255);
            }
            logLicenceRequest = System.getProperty("logLicenseRequest", "false").equalsIgnoreCase("false") == false;
            proxyAuthOverride = null;
            while (true) {
                request = new HttpPost((String)licenceServerUrl);
                request.addHeader((Header)new BasicHeader("hardwareAddresses", hardwareAddresslist));
                request.addHeader((Header)new BasicHeader("hostname", hostname));
                request.addHeader((Header)new BasicHeader("os", os));
                request.addHeader((Header)new BasicHeader("leaseRequired", Boolean.toString(leaseRequired)));
                request.addHeader((Header)new BasicHeader("renew", Boolean.toString(renew)));
                clientBuilder = HttpClients.custom();
                proxyData = LicenseServerClient.getProxyData((String)licenceServerUrl);
                LicenseServerClient.setProxyData(proxyData, proxyAuthOverride, clientBuilder);
                if (logLicenceRequest && !renew) {
                    LicenseServerClient.addRequestLogging(clientBuilder, LicenseServerClient.getLicenceServerAddress(), proxyData, proxyAuthOverride);
                }
                client = clientBuilder.build();
                var13_17 = null;
                var14_19 = null;
                try {
                    response = client.execute((HttpUriRequest)request);
                    try {
                        statusLine = response.getStatusLine();
                        status = statusLine.getStatusCode();
                        if (status == 407 && proxyData != null && allowProxyAuthPrompt && (proxyAuthOverride = LicenseServerClient.getProxyAuthFromUser(proxyAuthOverride != null ? proxyAuthOverride.getUserName() : proxyData.getUserId(), proxyAuthOverride != null ? proxyAuthOverride.getPassword() : proxyData.getPassword(), proxyData.getHost())) != null) continue;
                        entity = response.getEntity();
                        jsonObject = null;
                        errorReason = null;
                        try {
                            body = "";
                            if (entity != null) {
                                body = EntityUtils.toString((HttpEntity)response.getEntity());
                            }
                            var22_31 = null;
                            var23_34 = null;
                            try {
                                reader = Json.createReader((Reader)new StringReader(body));
                                try {
                                    jsonObject = reader.readObject();
                                    v0 = result = jsonObject.containsKey((Object)"result") != false ? jsonObject.getString("result") : "";
                                    if (status != 200 || !result.equalsIgnoreCase("OK")) {
                                        errorReason = jsonObject.containsKey((Object)"reason") != false ? jsonObject.getString("reason") : "";
                                        throw new RejectionException(errorReason, status);
                                    }
                                }
                                finally {
                                    if (reader != null) {
                                        reader.close();
                                    }
                                }
                            }
                            catch (Throwable var23_35) {
                                if (var22_31 == null) {
                                    var22_31 = var23_35;
                                } else if (var22_31 != var23_35) {
                                    var22_31.addSuppressed(var23_35);
                                }
                                throw var22_31;
                            }
                        }
                        catch (Exception e) {
                            if (status != 200) {
                                reasonPhrase = StringUtils.isEmptyOrNull(errorReason) == false ? errorReason : statusLine.getReasonPhrase();
                                throw new RejectionException(String.format("Response Code %d: %s", new Object[]{status, reasonPhrase}), status);
                            }
                            throw e;
                        }
                        try {
                            if (proxyAuthOverride != null) {
                                LicenseServerClient.updateProxySettings(proxyAuthOverride);
                            }
                        }
                        catch (CoreException e) {
                            LicenseServerClient.LOG.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        if (!leaseRequired) break;
                        leaseLengthMinutes = Integer.valueOf(jsonObject.getString("leaseLength"));
                        licensee = jsonObject.containsKey((Object)"licensee") != false ? jsonObject.getString("licensee") : "";
                        licenseCopy = jsonObject.containsKey((Object)"licenseCopy") != false ? jsonObject.getString("licenseCopy") : "";
                        return new ServerLease(leaseLengthMinutes, licensee, licenseCopy);
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                catch (Throwable var14_20) {
                    if (var13_17 == null) {
                        var13_17 = var14_20;
                    } else if (var13_17 != var14_20) {
                        var13_17.addSuppressed(var14_20);
                    }
                    throw var13_17;
                }
            }
            return null;
        }
        catch (Throwable e) {
            if (e instanceof RejectionException) {
                throw e;
            }
            message = "Error registering with licence server";
            rootCause = e;
            ** while (rootCause.getCause() != null && e.getCause() != rootCause)
        }
lbl-1000:
        // 1 sources

        {
            rootCause = rootCause.getCause();
            continue;
        }
lbl104:
        // 1 sources

        detail = rootCause.getMessage();
        if (detail != null && !detail.trim().isEmpty()) {
            message = (String)message + ": " + detail;
        }
        throw new Exception((String)message);
    }

    private static void addRequestLogging(HttpClientBuilder clientBuilder, final String licenseServerUrl, IProxyData proxyData, UsernamePasswordCredentials proxyAuthOverride) {
        try {
            final File logDir = new File(LicenseManager.getInstallationLicenseDir(), "logs");
            StringBuilder proxyStringBuilder = new StringBuilder();
            if (proxyData != null) {
                String username = proxyAuthOverride != null ? proxyAuthOverride.getUserName() : proxyData.getUserId();
                proxyStringBuilder.append("(via_");
                if (username != null) {
                    proxyStringBuilder.append(username + "@");
                }
                proxyStringBuilder.append(proxyData.getHost() + "_" + proxyData.getPort() + ")_");
            }
            final String proxyString = proxyStringBuilder.toString();
            logDir.mkdirs();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)new LoggingSocketFactory(){

                private final File getLogFile(String prefix, InetSocketAddress remoteAddress) {
                    String fileName = FileUtils.windowsSafeFileName((String)(prefix + "-(" + licenseServerUrl + ")-(" + remoteAddress.getHostString() + ":" + remoteAddress.getPort() + ")-" + proxyString + LOG_FILENAME_TIMESTAMP_FORMAT.format(new Date()))) + ".log";
                    return new File(logDir, fileName);
                }

                @Override
                public File getOutputStreamLogFile(InetSocketAddress remoteAddress) {
                    return this.getLogFile("request", remoteAddress);
                }

                @Override
                public File getInputStreamLogFile(InetSocketAddress remoteAddress) {
                    return this.getLogFile("response", remoteAddress);
                }
            }).build();
            clientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry));
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void updateProxySettings(UsernamePasswordCredentials proxyAuthOverride) throws CoreException {
        IProxyData[] proxyData;
        IProxyService proxyManager = ProxyManager.getProxyManager();
        IProxyData[] iProxyDataArray = proxyData = proxyManager.getProxyData();
        int n = proxyData.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxy = iProxyDataArray[n2];
            proxy.setUserid(proxyAuthOverride.getUserName());
            proxy.setPassword(proxyAuthOverride.getPassword());
            ++n2;
        }
        proxyManager.setProxyData(proxyData);
    }

    private static void setProxyData(IProxyData proxyData, UsernamePasswordCredentials proxyAuthOverride, HttpClientBuilder clientBuilder) {
        String password;
        if (proxyData == null) {
            return;
        }
        HttpHost httpHost = new HttpHost(proxyData.getHost(), proxyData.getPort());
        clientBuilder.setProxy(httpHost);
        clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        String username = proxyAuthOverride != null ? proxyAuthOverride.getUserName() : proxyData.getUserId();
        String string = password = proxyAuthOverride != null ? proxyAuthOverride.getPassword() : proxyData.getPassword();
        if (username != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(username, password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    private static IProxyData getProxyData(String uri) throws URISyntaxException {
        IProxyService proxyManager = ProxyManager.getProxyManager();
        IProxyData[] proxyData = proxyManager.select(new URI(uri));
        if (proxyData.length > 0) {
            return proxyData[0];
        }
        return null;
    }

    private static UsernamePasswordCredentials getProxyAuthFromUser(final String oldUser, final String oldPassword, final String servername) throws InterruptedException {
        final AtomicReference result = new AtomicReference();
        Thread dialogThread = new Thread(){

            @Override
            public void run() {
                final Display display = Display.getDefault();
                final boolean standaloneDisplay = display.getThread() == Thread.currentThread();
                try {
                    Runnable dialogRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = display.getActiveShell();
                            try {
                                UsernameAndPasswordDialog dialog = new UsernameAndPasswordDialog(shell, oldUser, oldPassword, "ORQA - Proxy Authentication Required", String.format("To connect to the ORQA licence server you need to enter a username and password for the proxy server: %s", servername));
                                if (dialog.open() == 0) {
                                    result.set(new UsernamePasswordCredentials(dialog.getUsername(), dialog.getPassword()));
                                }
                            }
                            finally {
                                if (standaloneDisplay) {
                                    display.dispose();
                                }
                            }
                        }
                    };
                    if (standaloneDisplay) {
                        display.asyncExec(dialogRunnable);
                        Shell shell = new Shell(display);
                        while (!shell.isDisposed()) {
                            if (display.readAndDispatch()) continue;
                            display.sleep();
                        }
                    } else {
                        display.syncExec(dialogRunnable);
                    }
                }
                finally {
                    if (standaloneDisplay) {
                        display.dispose();
                    }
                }
            }
        };
        dialogThread.start();
        dialogThread.join();
        return (UsernamePasswordCredentials)result.get();
    }

    public static void deregisterFromLicenceServer() {
        try {
            Object licenceServerUrl = LicenseServerClient.getLicenceServerAddress();
            if (((String)licenceServerUrl).isEmpty()) {
                return;
            }
            licenceServerUrl = (String)licenceServerUrl + DEREGISTRATION_ENDPOINT;
            String hardwareAddresslist = LicenseTools.hardwareAddressListToString(LicenseManager.getLocalMachineHardwareAddresses(), false, 255);
            String hostname = InetAddress.getLocalHost().getHostName();
            if (hostname != null && hostname.length() > 255) {
                hostname = hostname.substring(0, 255);
            }
            HttpPost request = new HttpPost((String)licenceServerUrl);
            request.addHeader((Header)new BasicHeader(HARDWARE_ADDRESSES_HEADER, hardwareAddresslist));
            request.addHeader((Header)new BasicHeader(HOSTNAME_HEADER, hostname));
            HttpClientBuilder clientBuilder = HttpClients.custom();
            LicenseServerClient.setProxyData(LicenseServerClient.getProxyData((String)licenceServerUrl), null, clientBuilder);
            CloseableHttpClient client = clientBuilder.build();
            Throwable throwable = null;
            Object var7_9 = null;
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getLicenceServerAddress() {
        Object address = System.getProperty(ORQA_SERVER_PROPERTY, "").trim();
        if (((String)address).isEmpty()) {
            return "";
        }
        if (!((String)address).toLowerCase().startsWith("http://") && !((String)address).toLowerCase().startsWith("https://")) {
            address = "http://" + (String)address;
        }
        while (((String)address).endsWith("/")) {
            address = ((String)address).substring(0, ((String)address).length() - 1);
        }
        return address;
    }

    public static class RejectionException
    extends Exception {
        public static final String NO_MORE_LICENSES_AVAILABLE = "NO_MORE_LICENSES_AVAILABLE";
        private static final long serialVersionUID = 1L;
        private final int status;
        private final String rejectionReason;

        public RejectionException(String rejectionReason, int status) {
            super(rejectionReason.isEmpty() ? Integer.toString(status) : rejectionReason);
            this.rejectionReason = rejectionReason;
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getRejectionReason() {
            return this.rejectionReason;
        }
    }

    public static class ServerLease {
        private final String licenseCopy;
        private final String licensee;
        private final int leaseLengthMinutes;

        public ServerLease(int leaseLengthMinutes, String licensee, String licenseCopy) {
            this.licenseCopy = licenseCopy;
            this.licensee = licensee;
            this.leaseLengthMinutes = leaseLengthMinutes;
        }

        public String getLicenseCopy() {
            return this.licenseCopy;
        }

        public String getLicensee() {
            return this.licensee;
        }

        public int getLeaseLengthMinutes() {
            return this.leaseLengthMinutes;
        }
    }
}

