/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.license.ILicense;
import org.ibboost.orqa.license.LicenseActivator;
import org.ibboost.orqa.license.LicenseServerClient;
import org.ibboost.orqa.license.LicenseTools;
import org.ibboost.orqa.license.LicenseV3;

public class LicenseManager {
    private static final Logger LOG = Logger.getLogger(LicenseManager.class);
    private static final String DISTRIBUTION_PROPERTY = "orqa.distro";
    private static final String DISTRIBUTION_HASH_PROPERTY = "orqa.odh";
    private static final String DISTRIBUTION_HASH_SALT = "7EbRe7aKuNA3AthuNEnutepA";
    private static final String SERVER_AUTHORISED_LICENSE_HASH_SALT = "0QdgRQBBN1jzYmYVf3UkNOih";
    private static final String SERVER_AUTHORISED_LICENSE = "orqa.templic";
    private static final String SINGLE_MACHINE_LICENCE = "orqa.lic";
    private static final String ORQA_LICENSE_PROPERTY = "orqa.license";
    private static LicenseValidationResult singleMachineLicenseValidationResult;
    private static LicenseValidationResult serverAuthorisedLicenseValidationResult;
    private static Thread licenseServerUpdateThread;

    public static ILicense getLicense() {
        LicenseValidationResult validationResult = LicenseManager.getActiveLicenceValidationResult();
        return validationResult != null ? validationResult.getLicense() : null;
    }

    public static File getLicenseFile() {
        LicenseValidationResult validationResult = LicenseManager.getActiveLicenceValidationResult();
        return validationResult != null ? validationResult.getLicenseFile() : null;
    }

    public static LicenseException getLicenseError() {
        LicenseValidationResult validationResult = LicenseManager.getActiveLicenceValidationResult();
        return validationResult != null ? validationResult.getLicenseError() : null;
    }

    public static List<LicenseException> getAllLicenseErrors() {
        ArrayList<LicenseException> result = new ArrayList<LicenseException>();
        LinkedList<LicenseValidationResult> validationResults = new LinkedList<LicenseValidationResult>(LicenseManager.getAllLicenseValidationResultsInOrderOfPreference());
        LicenseValidationResult activeValidationResult = LicenseManager.getActiveLicenceValidationResult();
        if (activeValidationResult != null) {
            validationResults.remove(activeValidationResult);
            validationResults.add(0, activeValidationResult);
        }
        for (LicenseValidationResult validationResult : validationResults) {
            if (validationResult.getLicenseError() == null) continue;
            result.add(validationResult.getLicenseError());
        }
        return result;
    }

    public static boolean isLicenseValid() {
        LicenseValidationResult validationResult = LicenseManager.getActiveLicenceValidationResult();
        return validationResult != null && validationResult.isValid();
    }

    public static boolean isLicenseUseableWithWarning() {
        LicenseValidationResult validationResult = LicenseManager.getActiveLicenceValidationResult();
        return validationResult != null && validationResult.isUseableWithWarning();
    }

    private static ArrayList<LicenseValidationResult> getAllLicenseValidationResultsInOrderOfPreference() {
        ArrayList<LicenseValidationResult> validationResults = new ArrayList<LicenseValidationResult>();
        if (serverAuthorisedLicenseValidationResult != null) {
            validationResults.add(serverAuthorisedLicenseValidationResult);
        }
        if (singleMachineLicenseValidationResult != null) {
            validationResults.add(singleMachineLicenseValidationResult);
        }
        return validationResults;
    }

    private static LicenseValidationResult getActiveLicenceValidationResult() {
        ArrayList<LicenseValidationResult> validationResults = LicenseManager.getAllLicenseValidationResultsInOrderOfPreference();
        if (validationResults.isEmpty()) {
            return null;
        }
        if (validationResults.size() == 1) {
            return (LicenseValidationResult)validationResults.get(0);
        }
        for (LicenseValidationResult result : validationResults) {
            if (!result.isValid()) continue;
            return result;
        }
        for (LicenseValidationResult result : validationResults) {
            if (!result.isUseableWithWarning()) continue;
            return result;
        }
        for (LicenseValidationResult result : validationResults) {
            if (result.getLicense() == null) continue;
            return result;
        }
        for (LicenseValidationResult result : validationResults) {
            if (result.getLicenseError() == null) continue;
            return result;
        }
        return (LicenseValidationResult)validationResults.get(0);
    }

    public static void terminate(LicenseException e) {
        if (e == null || e.isTerminal()) {
            System.exit(-1);
        }
    }

    private static File getServerAuthorisedLicenseFile() throws Exception {
        URL licenseURL = Platform.getInstallLocation().getDataArea("licenses/orqa.templic");
        return new File(licenseURL.getFile());
    }

    public static File getInstallationLicenseDir() throws IOException {
        URL installationLicenseFileURL = Platform.getInstallLocation().getDataArea("licenses");
        return new File(installationLicenseFileURL.getFile());
    }

    private static List<File> getLicenseFileCandidates(LicenseType licenseType) {
        ArrayList<File> fileLocations = new ArrayList<File>();
        try {
            if (licenseType == LicenseType.SINGLE_MACHINE) {
                File userHomeLicenseFile;
                File installationLicenseFile;
                File licensePropertyFile;
                String licenseProperty = System.getProperty(ORQA_LICENSE_PROPERTY, "");
                if (!licenseProperty.trim().isEmpty() && (licensePropertyFile = new File(licenseProperty)).isFile()) {
                    fileLocations.add(licensePropertyFile);
                }
                if ((installationLicenseFile = new File(LicenseManager.getInstallationLicenseDir(), SINGLE_MACHINE_LICENCE)).isFile()) {
                    fileLocations.add(installationLicenseFile);
                }
                if ((userHomeLicenseFile = new File(System.getProperty("user.home") + "/.orqa/orqa.lic")).isFile()) {
                    fileLocations.add(userHomeLicenseFile);
                }
            }
            try {
                if (licenseType == LicenseType.SERVER_AUTHORISED && LicenseManager.getServerAuthorisedLicenseFile().isFile()) {
                    fileLocations.add(LicenseManager.getServerAuthorisedLicenseFile());
                }
            }
            catch (Exception e) {
                LOG.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileLocations;
    }

    private static LicenseValidationResult validateLicense(LicenseType licenseType, boolean cliMode) {
        List<File> licenseCandidates = LicenseManager.getLicenseFileCandidates(licenseType);
        if (licenseCandidates.isEmpty()) {
            return new LicenseValidationResult(null, null, LicenseException.DEFAULT_LICENSE_EXCEPTION, licenseType);
        }
        ILicense license = null;
        File licenseFile = null;
        LicenseException licenseError = null;
        for (File licenseCandidate : licenseCandidates) {
            LicenseException candidateError;
            Map.Entry<ILicense, LicenseException> candidateResult = LicenseManager.validateLicense(licenseCandidate, licenseType, cliMode);
            ILicense candidateLicence = candidateResult.getKey();
            if (LicenseManager.candidateLicenseIsBetter(candidateLicence, candidateError = candidateResult.getValue(), license, licenseError)) {
                license = candidateLicence;
                licenseFile = licenseCandidate;
                licenseError = candidateError;
            }
            if (license != null && licenseError == null) break;
        }
        return new LicenseValidationResult(license, licenseFile, licenseError, licenseType);
    }

    private static boolean candidateLicenseIsBetter(ILicense candidateLicence, LicenseException candidateError, ILicense currentLicence, LicenseException currentError) {
        if (currentLicence == null && currentError == null) {
            return true;
        }
        if (currentLicence != null) {
            if (candidateLicence == null) {
                return false;
            }
            if (currentError == null) {
                return false;
            }
            if (candidateError == null) {
                return true;
            }
            if (currentError.isTerminal() && !candidateError.isTerminal()) {
                return true;
            }
        } else if (candidateLicence != null) {
            return true;
        }
        return false;
    }

    private static Map.Entry<ILicense, LicenseException> validateLicense(File licenseFile, LicenseType licenseType, boolean cliMode) {
        ILicense license = null;
        LicenseException licenseError = null;
        try {
            boolean hasExpired;
            try {
                license = LicenseManager.load(licenseFile);
            }
            catch (FileNotFoundException e) {
                throw LicenseException.DEFAULT_LICENSE_EXCEPTION;
            }
            catch (Exception e) {
                throw new LicenseException("Corrupted License", "The license for this application is corrupted.", true);
            }
            try {
                if (licenseType == LicenseType.SINGLE_MACHINE && !LicenseManager.verifyWithPublicKey(license) || licenseType == LicenseType.SERVER_AUTHORISED && !LicenseManager.verifyServerAuthorisedLicense(license)) {
                    throw new GeneralSecurityException();
                }
            }
            catch (Exception e) {
                throw new LicenseException("Invalid License", "The license for this application could not be verified.", true);
            }
            if (!LicenseManager.verifyHardwareAddresses(license)) {
                throw new LicenseException("Wrong Machine", "The license for this application does not apply to this machine.", true);
            }
            if (!LicenseManager.verifyDistribution(license)) {
                throw new LicenseException("Wrong Distribution", "The license file does not apply to this distribution.", true);
            }
            boolean useCliExpiry = cliMode && LicenseTools.hasCliSpecificExpiryDate(license);
            boolean bl = hasExpired = useCliExpiry ? license.cliHasExpired() : license.hasExpired();
            if (hasExpired) {
                boolean terminate = useCliExpiry ? license.cliGracePeriodHasExpired() : license.gracePeriodHasExpired();
                String expiryDate = useCliExpiry ? license.getCliExpiryDate() : license.getExpiryDate();
                String message = useCliExpiry ? "The license for the CLI mode of this application expired on %s." : "The license for this application expired on: %s.";
                throw new LicenseException("License Expired", String.format(message, expiryDate), terminate);
            }
        }
        catch (LicenseException e) {
            licenseError = e;
            try {
                if (licenseFile != null && licenseType == LicenseType.SERVER_AUTHORISED) {
                    licenseFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AbstractMap.SimpleEntry<ILicense, LicenseException>(license, licenseError);
    }

    private static void generateShortTermLicense(LicenseServerClient.ServerLease lease) {
        try {
            Date licenseExpiry = new Date(new Date().getTime() + (long)(lease.getLeaseLengthMinutes() * 60000));
            LicenseV3 shortTermLicense = new LicenseV3(licenseExpiry, licenseExpiry, licenseExpiry, licenseExpiry, lease.getLicensee(), LicenseManager.getStatedDistribution(), lease.getLicenseCopy(), LicenseManager.getLocalMachineHardwareAddresses());
            byte[] signature = LicenseManager.hashData(shortTermLicense.generateSignatureData(), SERVER_AUTHORISED_LICENSE_HASH_SALT, "server issued license");
            shortTermLicense.setSignature(signature);
            File licenseFile = LicenseManager.getServerAuthorisedLicenseFile();
            if (licenseFile.exists()) {
                licenseFile.delete();
            }
            LicenseManager.save(shortTermLicense, licenseFile);
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void shutdown() {
        if (licenseServerUpdateThread != null) {
            licenseServerUpdateThread.interrupt();
        }
        LicenseServerClient.deregisterFromLicenceServer();
    }

    public static void initLicense(boolean cliMode) {
        boolean licenseServerDefined;
        if (singleMachineLicenseValidationResult != null || serverAuthorisedLicenseValidationResult != null) {
            return;
        }
        singleMachineLicenseValidationResult = LicenseManager.validateLicense(LicenseType.SINGLE_MACHINE, cliMode);
        boolean useableLicenceFound = singleMachineLicenseValidationResult.isValid() || singleMachineLicenseValidationResult.isUseableWithWarning();
        LicenseException licenceServerRegistrationError = null;
        boolean bl = licenseServerDefined = !LicenseServerClient.getLicenceServerAddress().isEmpty();
        if (!useableLicenceFound && licenseServerDefined) {
            try {
                LicenseServerClient.ServerLease lease = LicenseServerClient.registerWithLicenceServer(true, false, !cliMode);
                LicenseManager.generateShortTermLicense(lease);
            }
            catch (Exception e) {
                String licenseErrorMessage = e.getMessage();
                if (e instanceof LicenseServerClient.RejectionException && "NO_MORE_LICENSES_AVAILABLE".equals(((LicenseServerClient.RejectionException)e).getRejectionReason())) {
                    licenseErrorMessage = "Cannot start at this time, the maximum number of simultaneous users for this license has been reached";
                    try {
                        File serverAuthorisedLicenseFile = LicenseManager.getServerAuthorisedLicenseFile();
                        if (serverAuthorisedLicenseFile != null) {
                            serverAuthorisedLicenseFile.delete();
                        }
                    }
                    catch (Exception e1) {
                        LOG.debug(e.getLocalizedMessage(), (Throwable)e1);
                    }
                }
                licenceServerRegistrationError = new LicenseException("License Server Error", licenseErrorMessage, true);
            }
        }
        boolean usingServerLicense = false;
        if (!useableLicenceFound) {
            try {
                if (LicenseManager.getServerAuthorisedLicenseFile().exists() && ((serverAuthorisedLicenseValidationResult = LicenseManager.validateLicense(LicenseType.SERVER_AUTHORISED, cliMode)).isValid() || serverAuthorisedLicenseValidationResult.isUseableWithWarning())) {
                    usingServerLicense = true;
                    useableLicenceFound = true;
                }
            }
            catch (Exception e) {
                LOG.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if ((serverAuthorisedLicenseValidationResult == null || !serverAuthorisedLicenseValidationResult.isValid() && !serverAuthorisedLicenseValidationResult.isUseableWithWarning()) && licenceServerRegistrationError != null) {
            serverAuthorisedLicenseValidationResult = new LicenseValidationResult(null, null, licenceServerRegistrationError, LicenseType.SERVER_AUTHORISED);
        }
        if (licenseServerDefined && usingServerLicense) {
            licenseServerUpdateThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (!1.interrupted()) {
                            try {
                                LicenseServerClient.registerWithLicenceServer(true, true, false);
                            }
                            catch (Exception e) {
                                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                            }
                            Thread.sleep(300000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            licenseServerUpdateThread.start();
        }
    }

    /*
     * Loose catch block
     */
    public static ILicense load(File file) throws IOException, ClassNotFoundException {
        if (file == null) {
            throw new FileNotFoundException();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fileStream = new FileInputStream(file);){
            ILicense iLicense;
            ObjectInputStream objectStream;
            Throwable throwable2;
            block20: {
                throwable2 = null;
                Object var5_8 = null;
                objectStream = new ObjectInputStream(fileStream);
                iLicense = (ILicense)objectStream.readObject();
                if (objectStream == null) break block20;
                objectStream.close();
            }
            return iLicense;
            {
                catch (Throwable throwable3) {
                    try {
                        if (objectStream != null) {
                            objectStream.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static void save(ILicense license, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fileStream = new FileOutputStream(file);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);){
                objectStream.writeObject(license);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static byte[][] getLocalMachineHardwareAddresses() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<byte[]> localAddresses = new ArrayList<byte[]>();
        while (interfaces.hasMoreElements()) {
            byte[] address;
            NetworkInterface nic = interfaces.nextElement();
            if (LicenseManager.isVirtualAdapter(nic) || LicenseManager.containsAddress(localAddresses, address = nic.getHardwareAddress())) continue;
            localAddresses.add(address);
        }
        return (byte[][])localAddresses.toArray((T[])new byte[localAddresses.size()][0]);
    }

    private static boolean containsAddress(List<byte[]> addresses, byte[] address) {
        for (byte[] candidate : addresses) {
            if (!Arrays.equals(address, candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVirtualAdapter(NetworkInterface nic) throws SocketException {
        if (nic.isVirtual() || nic.isLoopback()) {
            return true;
        }
        String description = String.format("%s%s", nic.getName(), nic.getDisplayName()).toLowerCase();
        for (String keyword : Arrays.asList("virtual", "tun", "tap", "filter", "scheduler")) {
            if (!description.contains(keyword)) continue;
            return true;
        }
        byte[] address = nic.getHardwareAddress();
        if (address == null || address.length != 6) {
            return true;
        }
        return address[0] == 0 && address[1] == 0 && address[2] == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyHardwareAddresses(ILicense license) {
        if (license.getHardwareAddresses() == null) return true;
        if (license.getHardwareAddresses().length == 0) {
            return true;
        }
        try {
            byte[][] localAddresses = LicenseManager.getLocalMachineHardwareAddresses();
            byte[][] byArray = license.getHardwareAddresses();
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                byte[] licenseAddress = byArray[n2];
                if (LicenseTools.addressListContainsAddress(localAddresses, licenseAddress)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (SocketException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static PublicKey getPublicKey() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        URL keyURL = LicenseActivator.getBundleContext().getBundle().getEntry("public-key.der");
        File keyFile = new File(FileLocator.toFileURL((URL)keyURL).getPath());
        byte[] keyBytes = Files.readAllBytes(keyFile.toPath());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
        return keyFactory.generatePublic(keySpec);
    }

    public static boolean verifyServerAuthorisedLicense(ILicense license) throws IOException, GeneralSecurityException, URISyntaxException {
        try {
            byte[] calculatedHash = LicenseManager.hashData(license.generateSignatureData(), SERVER_AUTHORISED_LICENSE_HASH_SALT, "");
            byte[] expectedHash = license.getSignature();
            return Arrays.equals(calculatedHash, expectedHash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verifyWithPublicKey(ILicense license) throws IOException, GeneralSecurityException, URISyntaxException {
        PublicKey key = LicenseManager.getPublicKey();
        Signature spi = Signature.getInstance("SHA1withDSA", "SUN");
        spi.initVerify(key);
        license.generateSignatureData(spi);
        return spi.verify(license.getSignature());
    }

    public static void signWithPrivateKey(ILicense license, File keyFile) throws IOException, GeneralSecurityException {
        byte[] keyBytes = Files.readAllBytes(keyFile.toPath());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature spi = Signature.getInstance("SHA1withDSA", "SUN");
        spi.initSign(key);
        license.generateSignatureData(spi);
        license.setSignature(spi.sign());
    }

    public static String hashText(String text, String salt, String hashname) {
        try {
            byte[] hashedBytes = LicenseManager.hashData(text.getBytes("UTF-8"), salt, hashname);
            return String.format("%064x", new BigInteger(1, hashedBytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Error checking %s hash", hashname));
        }
    }

    public static byte[] hashData(byte[] data, String salt, String hashname) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] saltBytes = salt.getBytes("UTF-8");
            byte[] saltedData = new byte[data.length + saltBytes.length];
            System.arraycopy(data, 0, saltedData, 0, data.length);
            System.arraycopy(saltBytes, 0, saltedData, data.length, saltBytes.length);
            md.update(saltedData);
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error checking %s hash", hashname));
        }
    }

    private static String getStatedDistribution() {
        String distribution = System.getProperty(DISTRIBUTION_PROPERTY, "");
        if (!LicenseManager.verifyDistribution(distribution)) {
            return null;
        }
        return distribution;
    }

    private static String hashDistribution(String distributionName) {
        return LicenseManager.hashText(distributionName, DISTRIBUTION_HASH_SALT, "license");
    }

    public static boolean verifyDistribution(String distribution) {
        String distributionHash = LicenseManager.hashDistribution(distribution);
        return System.getProperty(DISTRIBUTION_HASH_PROPERTY, "").trim().equalsIgnoreCase(distributionHash);
    }

    public static boolean verifyDistribution(ILicense license) {
        if (license.getDistributions() == null || license.getDistributions().length() == 0) {
            return true;
        }
        String[] stringArray = license.getDistributions().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String licensedDist = stringArray[n2];
            if (LicenseManager.verifyDistribution(licensedDist)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class LicenseException
    extends Exception {
        private static final long serialVersionUID = -4121979715255428726L;
        public static final LicenseException DEFAULT_LICENSE_EXCEPTION = new LicenseException("Unlicensed", "The license for this application could not be found.", true);
        private final String title;
        private final String message;
        private final boolean terminal;

        public LicenseException(String title, String message, boolean terminal) {
            this.title = title;
            this.message = message;
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static enum LicenseType {
        SINGLE_MACHINE,
        SERVER_AUTHORISED;

    }

    public static class LicenseValidationResult {
        private final ILicense license;
        private final File licenseFile;
        private final LicenseException licenseError;
        private final LicenseType licenseType;

        public LicenseValidationResult(ILicense license, File licenseFile, LicenseException licenseError, LicenseType licenseType) {
            this.license = license;
            this.licenseFile = licenseFile;
            this.licenseError = licenseError;
            this.licenseType = licenseType;
        }

        public ILicense getLicense() {
            return this.license;
        }

        public File getLicenseFile() {
            return this.licenseFile;
        }

        public LicenseException getLicenseError() {
            return this.licenseError;
        }

        public LicenseType getLicenseType() {
            return this.licenseType;
        }

        public boolean isValid() {
            return this.license != null && this.licenseError == null;
        }

        public boolean isUseableWithWarning() {
            return this.license != null && this.licenseError != null && !this.licenseError.isTerminal();
        }
    }
}

