/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.ibboost.orqa.license.ILicense;
import org.ibboost.orqa.license.LicenseTools;

public class License
implements Serializable,
ILicense {
    private static final long serialVersionUID = 2L;
    private final Date expiryDate;
    private final Date graceExpiryDate;
    private final String licensee;
    private final String licenseCopy;
    private final byte[][] hardwareAddresses;
    private byte[] signature;

    public License(Date expiryDate, Date graceExpiryDate, String licensee, String licenseCopy, byte[][] hardwareAddresses) {
        this.expiryDate = expiryDate;
        this.graceExpiryDate = graceExpiryDate;
        this.licensee = licensee;
        this.licenseCopy = licenseCopy;
        this.hardwareAddresses = hardwareAddresses;
    }

    @Override
    public String getExpiryDate() {
        return LicenseTools.expiryDateToString(this.expiryDate);
    }

    @Override
    public boolean hasExpired() {
        return this.expiryDate.before(new Date());
    }

    @Override
    public boolean gracePeriodHasExpired() {
        if (this.graceExpiryDate == null) {
            return this.hasExpired();
        }
        return this.graceExpiryDate.before(new Date());
    }

    @Override
    public String getLicensee() {
        return this.licensee;
    }

    @Override
    public String getLicenseCopy() {
        return this.licenseCopy;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    @Override
    public Date getGraceExpiryDate() {
        return this.graceExpiryDate;
    }

    @Override
    public byte[][] getHardwareAddresses() {
        return this.hardwareAddresses;
    }

    @Override
    public byte[] generateSignatureData() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(ByteBuffer.allocate(8).putLong(this.expiryDate.getTime()).array());
        if (this.graceExpiryDate != null) {
            bytes.write(ByteBuffer.allocate(8).putLong(this.graceExpiryDate.getTime()).array());
        }
        bytes.write(this.licensee.getBytes(StandardCharsets.UTF_8));
        bytes.write(this.licenseCopy.getBytes(StandardCharsets.UTF_8));
        if (this.hardwareAddresses != null) {
            byte[][] byArray = this.hardwareAddresses;
            int n = this.hardwareAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] hardwareAddress = byArray[n2];
                bytes.write(hardwareAddress);
                ++n2;
            }
        }
        return bytes.toByteArray();
    }

    @Override
    public void generateSignatureData(Signature spi) throws SignatureException {
        spi.update(ByteBuffer.allocate(8).putLong(this.expiryDate.getTime()));
        if (this.graceExpiryDate != null) {
            spi.update(ByteBuffer.allocate(8).putLong(this.graceExpiryDate.getTime()));
        }
        spi.update(this.licensee.getBytes(StandardCharsets.UTF_8));
        spi.update(this.licenseCopy.getBytes(StandardCharsets.UTF_8));
        if (this.hardwareAddresses != null) {
            byte[][] byArray = this.hardwareAddresses;
            int n = this.hardwareAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] hardwareAddress = byArray[n2];
                spi.update(hardwareAddress);
                ++n2;
            }
        }
    }

    @Override
    public String getDistributions() {
        return null;
    }

    @Override
    public String getCliExpiryDate() {
        return this.getExpiryDate();
    }

    @Override
    public Date getGraceCliExpiryDate() {
        return this.getGraceExpiryDate();
    }

    @Override
    public boolean cliHasExpired() {
        return this.hasExpired();
    }

    @Override
    public boolean cliGracePeriodHasExpired() {
        return this.gracePeriodHasExpired();
    }
}

