/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.ibboost.orqa.license.ILicense;
import org.ibboost.orqa.license.LicenseTools;

public class LicenseV3
implements Serializable,
ILicense {
    private static final long serialVersionUID = 1L;
    private Date expiryDate;
    private Date graceExpiryDate;
    private Date cliExpiryDate;
    private Date graceCliExpiryDate;
    private String distributions;
    private String licensee;
    private String licenseCopy;
    private byte[][] hardwareAddresses;
    private byte[] signature;

    public LicenseV3(Date expiryDate, Date graceExpiryDate, Date cliExpiryDate, Date graceCliExpiryDate, String licensee, String distributions, String licenseCopy, byte[][] hardwareAddresses) {
        this.expiryDate = expiryDate;
        this.graceExpiryDate = graceExpiryDate;
        this.cliExpiryDate = cliExpiryDate;
        this.graceCliExpiryDate = graceCliExpiryDate;
        this.licensee = licensee;
        this.licenseCopy = licenseCopy;
        this.hardwareAddresses = hardwareAddresses;
        this.distributions = distributions;
    }

    @Override
    public byte[] generateSignatureData() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(ByteBuffer.allocate(8).putLong(this.expiryDate.getTime()).array());
        if (this.graceExpiryDate != null) {
            bytes.write(ByteBuffer.allocate(8).putLong(this.graceExpiryDate.getTime()).array());
        }
        if (this.cliExpiryDate != null) {
            bytes.write(ByteBuffer.allocate(8).putLong(this.cliExpiryDate.getTime()).array());
        }
        if (this.graceCliExpiryDate != null) {
            bytes.write(ByteBuffer.allocate(8).putLong(this.graceCliExpiryDate.getTime()).array());
        }
        bytes.write(this.licensee.getBytes(StandardCharsets.UTF_8));
        bytes.write(this.licenseCopy.getBytes(StandardCharsets.UTF_8));
        if (this.hardwareAddresses != null) {
            byte[][] byArray = this.hardwareAddresses;
            int n = this.hardwareAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] hardwareAddress = byArray[n2];
                bytes.write(hardwareAddress);
                ++n2;
            }
        }
        if (this.distributions != null) {
            bytes.write(this.distributions.getBytes(StandardCharsets.UTF_8));
        }
        return bytes.toByteArray();
    }

    @Override
    public void generateSignatureData(Signature spi) throws SignatureException, IOException {
        spi.update(this.generateSignatureData());
    }

    @Override
    public String getExpiryDate() {
        return LicenseTools.expiryDateToString(this.expiryDate);
    }

    @Override
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[][] getHardwareAddresses() {
        return this.hardwareAddresses;
    }

    @Override
    public String getLicensee() {
        return this.licensee;
    }

    @Override
    public String getLicenseCopy() {
        return this.licenseCopy;
    }

    @Override
    public boolean hasExpired() {
        return this.expiryDate.before(new Date());
    }

    @Override
    public boolean gracePeriodHasExpired() {
        if (this.graceExpiryDate == null) {
            return this.hasExpired();
        }
        return this.graceExpiryDate.before(new Date());
    }

    @Override
    public String getDistributions() {
        return this.distributions;
    }

    @Override
    public Date getGraceExpiryDate() {
        return this.graceExpiryDate;
    }

    @Override
    public String getCliExpiryDate() {
        if (this.cliExpiryDate != null) {
            return LicenseTools.expiryDateToString(this.cliExpiryDate);
        }
        return "";
    }

    @Override
    public Date getGraceCliExpiryDate() {
        return this.graceCliExpiryDate;
    }

    @Override
    public boolean cliHasExpired() {
        Date cliExpiryDate = this.cliExpiryDate != null ? this.cliExpiryDate : this.expiryDate;
        return cliExpiryDate.before(new Date());
    }

    @Override
    public boolean cliGracePeriodHasExpired() {
        Date graceCliExpiryDate;
        Date date = graceCliExpiryDate = this.cliExpiryDate != null ? this.graceCliExpiryDate : this.graceExpiryDate;
        if (graceCliExpiryDate == null) {
            return this.cliHasExpired();
        }
        return graceCliExpiryDate.before(new Date());
    }
}

