/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.license;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.about.InstallationPage;
import org.ibboost.orqa.core.ui.editors.StringPropertyEditor;
import org.ibboost.orqa.license.ILicense;
import org.ibboost.orqa.license.LicenseManager;
import org.ibboost.orqa.license.LicenseTools;

public class LicensePage
extends InstallationPage {
    public void createControl(Composite parent) {
        LicenseManager.LicenseException licenseError;
        Composite licenseContainer = new Composite(parent, 0);
        licenseContainer.setLayout((Layout)new GridLayout());
        licenseContainer.setLayoutData((Object)new GridData(1808));
        licenseContainer.setFont(parent.getFont());
        ILicense license = LicenseManager.getLicense();
        StringPropertyEditor licensee = new StringPropertyEditor("licensee", "Licensed to", licenseContainer, false, 8);
        StringPropertyEditor expiryDate = new StringPropertyEditor("expiryDate", "Licence expires", licenseContainer, false, 8);
        StringPropertyEditor cliExpiryDate = null;
        if (license != null && LicenseTools.hasCliSpecificExpiryDate(license)) {
            cliExpiryDate = new StringPropertyEditor("cliExpiryDate", "CLI Licence expires", licenseContainer, false, 8);
        }
        StringPropertyEditor licenseCopy = new StringPropertyEditor("licenseCopy", "", licenseContainer, false, 586);
        if (license != null) {
            licensee.setValue(license.getLicensee());
            expiryDate.setValue(license.getExpiryDate());
            if (cliExpiryDate != null) {
                cliExpiryDate.setValue(license.getCliExpiryDate());
            }
            licenseCopy.setValue(license.getLicenseCopy());
        }
        if ((licenseError = LicenseManager.getLicenseError()) != null) {
            licensee.setValue(licenseError.getTitle());
            expiryDate.setValue(licenseError.getTitle());
            if (cliExpiryDate != null) {
                if (license == null || license.cliHasExpired()) {
                    cliExpiryDate.setValue(licenseError.getTitle());
                } else {
                    cliExpiryDate.setValue(license.getCliExpiryDate());
                }
            }
            licenseCopy.setValue(licenseError.getMessage());
        }
        this.setControl((Control)licenseContainer);
    }
}

