/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.filesystem.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.ibboost.orqa.filesystem.FileStoreWithMapProperties;
import org.ibboost.orqa.filesystem.jms.JMSActivator;
import org.ibboost.orqa.filesystem.jms.JMSEndpoint;
import org.ibboost.orqa.filesystem.jms.JMSMessageFormat;

public class JMSFileStore
extends FileStoreWithMapProperties {
    private static final String CORRELATION_ID_KEY = "correlationID";
    private final JMSEndpoint endpoint;
    private final String queueName;
    private final JMSMessageFormat format;
    private long lastModified;
    private String correlationID;
    private ThreadLocal<Connection> connection = new ThreadLocal();
    private ThreadLocal<Session> session = new ThreadLocal();
    private ThreadLocal<MessageProducer> producer = new ThreadLocal();
    private ThreadLocal<MessageConsumer> consumer = new ThreadLocal();
    private ConnectionCloser connectionCloser;

    public JMSFileStore(JMSEndpoint endpoint, String queueName, JMSMessageFormat format) {
        super(new String[]{CORRELATION_ID_KEY});
        this.endpoint = endpoint;
        this.queueName = queueName;
        this.format = format;
    }

    public IFileSystem getFileSystem() {
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public URI toURI() {
        return null;
    }

    public String toString() {
        return this.queueName;
    }

    public String getName() {
        return this.queueName;
    }

    public IFileStore getChild(String name) {
        throw new UnsupportedOperationException();
    }

    public IFileStore getParent() {
        return null;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo info = new FileInfo(this.getName());
        info.setExists(true);
        info.setDirectory(false);
        info.setLastModified(this.lastModified);
        return info;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        Thread consumerThread = null;
        try {
            final MessageConsumer consumer = this.getMessageConsumer();
            this.connection.get().start();
            final AtomicReference message = new AtomicReference();
            final AtomicReference exception = new AtomicReference();
            final AtomicBoolean timedOut = new AtomicBoolean(false);
            consumerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Message recievedMessage = null;
                        if (JMSFileStore.this.endpoint.getReadTimeout() != null) {
                            recievedMessage = consumer.receive(JMSFileStore.this.endpoint.getReadTimeout().longValue());
                            if (recievedMessage == null) {
                                timedOut.set(true);
                            }
                        } else {
                            recievedMessage = consumer.receive();
                        }
                        message.set(recievedMessage);
                    }
                    catch (JMSException e) {
                        exception.set(e);
                    }
                }
            };
            consumerThread.start();
            consumerThread.join();
            consumerThread = null;
            if (exception.get() != null || timedOut.get()) {
                this.lastModified = 0L;
                this.correlationID = null;
                if (timedOut.get()) {
                    throw new CoreException((IStatus)new Status(4, JMSActivator.PLUGIN_ID, 0, null, (Throwable)new TimeoutException()));
                }
                throw (JMSException)((Object)exception.get());
            }
            this.lastModified = ((Message)message.get()).getJMSTimestamp();
            this.correlationID = ((Message)message.get()).getJMSCorrelationID();
            return JMSFileStore.inputStreamFromMessage((Message)message.get());
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InterruptedException | NoSuchMethodException | InvocationTargetException | JMSException | NamingException e) {
            if (consumerThread != null) {
                consumerThread.interrupt();
            }
            this.disconnectSession();
            throw new CoreException((IStatus)new Status(4, JMSActivator.PLUGIN_ID, 0, null, e));
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            final ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.connectSession();
            final MessageProducer producer = this.getMessageProducer();
            final Session session = this.session.get();
            return new FilterOutputStream(stream){
                boolean closed;
                {
                    super($anonymous0);
                    this.closed = false;
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.out.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.out.write(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    this.out.close();
                    if (!this.closed) {
                        this.closed = true;
                        try {
                            try {
                                Message message = JMSFileStore.messageFromOutputStream(stream, session, JMSFileStore.this.format);
                                if (JMSFileStore.this.correlationID != null) {
                                    message.setJMSCorrelationID(JMSFileStore.this.correlationID);
                                }
                                producer.send(message);
                            }
                            catch (JMSException e) {
                                JMSFileStore.this.disconnectSession();
                                throw new IOException(e);
                            }
                        }
                        finally {
                            JMSFileStore.this.correlationID = null;
                        }
                    }
                }
            };
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | JMSException | NamingException e) {
            throw new CoreException((IStatus)new Status(4, JMSActivator.PLUGIN_ID, 0, null, e));
        }
    }

    private MessageProducer getMessageProducer() throws ClassNotFoundException, NamingException, IOException, JMSException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.connectSession();
        MessageProducer producer = this.producer.get();
        if (producer == null) {
            producer = this.session.get().createProducer((Destination)this.session.get().createQueue(this.queueName));
            Map<String, Object> destinationProperties = this.endpoint.getDestinationProperties();
            if (destinationProperties != null && !destinationProperties.isEmpty()) {
                Destination destination = producer.getDestination();
                JMSEndpoint.setObjectProperties(destination, destinationProperties);
            }
            this.producer.set(producer);
            this.connectionCloser.setProducer(producer);
        }
        return producer;
    }

    private MessageConsumer getMessageConsumer() throws ClassNotFoundException, NamingException, IOException, JMSException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.connectSession();
        MessageConsumer consumer = this.consumer.get();
        if (consumer == null) {
            consumer = this.session.get().createConsumer((Destination)this.session.get().createQueue(this.queueName));
            this.consumer.set(consumer);
            this.connectionCloser.setConsumer(consumer);
        }
        return consumer;
    }

    private void connectSession() throws ClassNotFoundException, NamingException, IOException, JMSException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.connection.get() == null) {
            this.connection.set(this.endpoint.createConnection());
            this.session.set(this.connection.get().createSession(false, 1));
            this.connectionCloser = new ConnectionCloser(this.connection.get(), this.session.get());
        }
    }

    private void disconnectSession() {
        if (this.connectionCloser != null) {
            this.connectionCloser.interrupt();
        }
        this.consumer.set(null);
        this.producer.set(null);
        this.session.set(null);
        this.connection.set(null);
    }

    private static InputStream inputStreamFromMessage(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            String messageText = ((TextMessage)message).getText();
            return new ByteArrayInputStream(messageText.getBytes(StandardCharsets.UTF_8));
        }
        if (message instanceof BytesMessage) {
            byte[] messageBytes = new byte[(int)((BytesMessage)message).getBodyLength()];
            ((BytesMessage)message).readBytes(messageBytes);
            return new ByteArrayInputStream(messageBytes);
        }
        throw new IllegalArgumentException("Unsupported message type");
    }

    private static Message messageFromOutputStream(ByteArrayOutputStream stream, Session session, JMSMessageFormat format) throws JMSException, UnsupportedEncodingException {
        if (format == JMSMessageFormat.TEXT) {
            TextMessage message = session.createTextMessage();
            message.setText(stream.toString("UTF-8"));
            return message;
        }
        if (format == JMSMessageFormat.BINARY) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(stream.toByteArray());
            return message;
        }
        throw new IllegalArgumentException("Unsupported message type");
    }

    public Object get(Object key) {
        if (CORRELATION_ID_KEY.equals(key)) {
            return this.correlationID;
        }
        return null;
    }

    private static class ConnectionCloser
    extends Thread {
        private final Thread parentThread;
        private final Connection connection;
        private final Session session;
        private MessageProducer producer;
        private MessageConsumer consumer;

        public ConnectionCloser(Connection connection, Session session) {
            this.connection = connection;
            this.session = session;
            this.parentThread = Thread.currentThread();
            this.start();
        }

        public void setProducer(MessageProducer producer) {
            this.producer = producer;
        }

        public void setConsumer(MessageConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try {
                this.parentThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                if (this.producer != null) {
                    this.producer.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

