/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.filesystem.jms;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.core.runtime.Platform;
import org.ibboost.orqa.core.execution.TypeCoercion;

public class JMSEndpoint {
    private static final Map<FactoryCacheKey, ConnectionFactory> connectionFactoryCache = Collections.synchronizedMap(new HashMap());
    private final String jndiFactory;
    private final String jndiProvider;
    private final String connectionFactory;
    private final String username;
    private final String password;
    private final Long readTimeout;
    private final Map<String, Object> connectionFactoryProperties;
    private final Map<String, Object> destinationProperties;

    public JMSEndpoint(String jndiFactory, String jndiProvider, String connectionFactory, String username, String password, Long readTimeout, Map<String, Object> connectionFactoryProperties, Map<String, Object> destinationProperties) {
        this.jndiFactory = jndiFactory;
        this.jndiProvider = jndiProvider;
        this.connectionFactory = connectionFactory;
        this.username = username;
        this.password = password;
        this.readTimeout = readTimeout;
        this.connectionFactoryProperties = connectionFactoryProperties;
        this.destinationProperties = destinationProperties;
    }

    public Connection createConnection() throws ClassNotFoundException, NamingException, IOException, JMSException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassLoader saveClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FactoryCacheKey cacheKey = new FactoryCacheKey(this.jndiFactory, this.jndiProvider, this.connectionFactory, this.connectionFactoryProperties);
            ConnectionFactory factory = connectionFactoryCache.get(cacheKey);
            if (factory != null) {
                Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
            } else {
                ClassLoader jmsDriverLoader = JMSEndpoint.createClassLoader();
                Thread.currentThread().setContextClassLoader(jmsDriverLoader);
                factory = this.getConnectionFactory();
                connectionFactoryCache.put(cacheKey, factory);
            }
            if (this.username == null) {
                Connection connection = factory.createConnection();
                return connection;
            }
            Connection connection = factory.createConnection(this.username, this.password);
            return connection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(saveClassLoader);
        }
    }

    public Long getReadTimeout() {
        return this.readTimeout;
    }

    public Map<String, Object> getDestinationProperties() {
        return this.destinationProperties;
    }

    private static Method findGenericSetterMethod(Class<?> targetClass, Class<?> type, String ... expectedNames) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(targetClass.getDeclaredMethods()));
        methods.addAll(Arrays.asList(targetClass.getMethods()));
        ArrayList<String> candidateNames = new ArrayList<String>(Arrays.asList(expectedNames));
        candidateNames.addAll(Arrays.asList("setProperty", "setObjectProperty", "setValue"));
        for (String candidateName : candidateNames) {
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                System.out.println(method.getName());
                if (!method.getName().equalsIgnoreCase(candidateName) || (parameterTypes = method.getParameterTypes()).length != 2 || parameterTypes[0] != String.class) continue;
                if (type != null) {
                    HashSet<Class> types = new HashSet<Class>(Arrays.asList(type));
                    MethodType methodType = MethodType.methodType(type);
                    types.add((Class)(type.isPrimitive() ? methodType.wrap() : methodType.unwrap()).returnType());
                    if (!types.contains(parameterTypes[1])) continue;
                }
                method.setAccessible(true);
                return method;
            }
        }
        return null;
    }

    private static Method findDedicatedSetterMethod(String propertyName, Class<?> targetClass, boolean allowMultipleParameters) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(targetClass.getDeclaredMethods()));
        methods.addAll(Arrays.asList(targetClass.getMethods()));
        String setterName = "set" + propertyName;
        for (Method method : methods) {
            if (!setterName.equalsIgnoreCase(method.getName()) || !allowMultipleParameters && method.getParameterTypes().length != 1) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private static boolean setPropertyWithDedicatedSetterMethod(Object object, String propertyName, Object propertyValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean allowMultipleParameters = propertyValue instanceof Collection;
        Method setter = JMSEndpoint.findDedicatedSetterMethod(propertyName, object.getClass(), allowMultipleParameters);
        if (setter == null) {
            return false;
        }
        Class<?>[] parameterTypes = setter.getParameterTypes();
        List<Object> uncoercedParameters = parameterTypes.length > 1 && propertyValue instanceof Collection ? (List<Object>)propertyValue : Arrays.asList(propertyValue);
        Object[] coercedParameters = new Object[parameterTypes.length];
        int i = 0;
        for (Object e : uncoercedParameters) {
            if (i >= coercedParameters.length) break;
            coercedParameters[i] = TypeCoercion.coerce(e, parameterTypes[i]);
            ++i;
        }
        setter.invoke(object, coercedParameters);
        return true;
    }

    private static Method getBestGenericSetterMethod(Class<?> objectClass, Object propertyValue) {
        Method result;
        if (propertyValue instanceof Short && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Short.class, "setShortProperty", "setShort")) != null) {
            return result;
        }
        if ((propertyValue instanceof Short || propertyValue instanceof Integer) && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Integer.class, "setIntProperty", "setIntegerProperty", "setInteger", "setInt")) != null) {
            return result;
        }
        if ((propertyValue instanceof Short || propertyValue instanceof Integer || propertyValue instanceof Long) && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Long.class, "setLongProperty", "setLong")) != null) {
            return result;
        }
        if (propertyValue instanceof Float && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Float.class, "setFloatProperty", "setFloat")) != null) {
            return result;
        }
        if ((propertyValue instanceof Float || propertyValue instanceof Double) && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Double.class, "setDoubleProperty", "setDouble")) != null) {
            return result;
        }
        if (propertyValue instanceof Byte && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Byte.class, "setByteProperty", "setByte")) != null) {
            return result;
        }
        if (propertyValue instanceof Character && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Character.class, "setCharacterProperty", "setCharProperty", "setCharacter", "setChar")) != null) {
            return result;
        }
        if (propertyValue instanceof String && (result = JMSEndpoint.findGenericSetterMethod(objectClass, String.class, "setStringProperty", "setString")) != null) {
            return result;
        }
        if (propertyValue instanceof Boolean && (result = JMSEndpoint.findGenericSetterMethod(objectClass, Boolean.class, "setBooleanProperty", "setBoolean")) != null) {
            return result;
        }
        return JMSEndpoint.findGenericSetterMethod(objectClass, null, new String[0]);
    }

    private static boolean setPropertyWithGenericSetterMethod(Object object, String propertyName, Object propertyValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method setter = JMSEndpoint.getBestGenericSetterMethod(object.getClass(), propertyValue);
        if (setter == null) {
            return false;
        }
        Class<?> type = setter.getParameterTypes()[1];
        Object coercedValue = TypeCoercion.coerce((Object)propertyValue, type);
        setter.invoke(object, propertyName, coercedValue);
        return true;
    }

    public static void setObjectProperties(Object object, Map<String, Object> properties) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (JMSEndpoint.setPropertyWithDedicatedSetterMethod(object, property.getKey(), property.getValue()) || JMSEndpoint.setPropertyWithGenericSetterMethod(object, property.getKey(), property.getValue())) continue;
            throw new NoSuchMethodException(String.format("Unable to set property: %s for class: %s", property.getKey(), object.getClass()));
        }
    }

    public ConnectionFactory getConnectionFactory() throws ClassNotFoundException, NamingException, IOException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ConnectionFactory result = null;
        Class<?> jndiFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.jndiFactory);
        if (ConnectionFactory.class.isAssignableFrom(jndiFactoryClass)) {
            try {
                result = (ConnectionFactory)jndiFactoryClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (result == null) {
            Properties environment = new Properties();
            environment.put("java.naming.factory.initial", this.jndiFactory);
            if (this.jndiProvider != null) {
                environment.put("java.naming.provider.url", this.jndiProvider);
            }
            try (InitialContext context = new InitialContext(environment);){
                result = (ConnectionFactory)context.lookup(this.connectionFactory);
            }
        }
        if (this.connectionFactoryProperties != null) {
            JMSEndpoint.setObjectProperties(result, this.connectionFactoryProperties);
        }
        return result;
    }

    private static ClassLoader createClassLoader() throws ClassNotFoundException, IOException {
        ArrayList<URL> driverUrls = new ArrayList<URL>();
        URL driversDir = Platform.getInstallLocation().getDataArea("jmsdrivers");
        File[] driverFiles = new File(driversDir.getFile()).listFiles();
        if (driverFiles != null) {
            File[] fileArray = driverFiles;
            int n = driverFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File driverFile = fileArray[n2];
                driverUrls.add(driverFile.toURI().toURL());
                ++n2;
            }
        }
        return new URLClassLoader(driverUrls.toArray(new URL[driverUrls.size()]), JMSEndpoint.class.getClassLoader());
    }

    private static class FactoryCacheKey {
        private final String jndiFactory;
        private final String jndiProvider;
        private final String connectionFactory;
        private final Map<String, Object> connectionFactoryProperties;

        public FactoryCacheKey(String jndiFactory, String jndiProvider, String connectionFactory, Map<String, Object> connectionFactoryProperties) {
            this.jndiFactory = jndiFactory;
            this.jndiProvider = jndiProvider;
            this.connectionFactory = connectionFactory;
            this.connectionFactoryProperties = connectionFactoryProperties;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FactoryCacheKey)) {
                return false;
            }
            FactoryCacheKey otherKey = (FactoryCacheKey)other;
            return Objects.equals(this.jndiFactory, otherKey.jndiFactory) && Objects.equals(this.jndiProvider, otherKey.jndiProvider) && Objects.equals(this.connectionFactory, otherKey.connectionFactory) && Objects.equals(this.connectionFactoryProperties, otherKey.connectionFactoryProperties);
        }

        public int hashCode() {
            return Objects.hash(this.jndiFactory, this.jndiProvider, this.connectionFactory, this.connectionFactoryProperties);
        }
    }
}

