/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathNodeList
extends ArrayList<Node>
implements NodeList {
    private static final long serialVersionUID = 1L;

    public static XPathNodeList fromNodes(Object nodes) {
        return XPathNodeList.fromNodes(nodes, false);
    }

    private static XPathNodeList fromNodes(Object nodes, boolean force) {
        if (force || XPathNodeList.isNodeSet(nodes)) {
            if (nodes instanceof Node) {
                return new XPathNodeList((Node)nodes);
            }
            if (nodes instanceof Iterable) {
                return new XPathNodeList((Iterable)nodes);
            }
            if (nodes instanceof NodeList) {
                return new XPathNodeList((NodeList)nodes);
            }
            if (nodes instanceof NodeIterator) {
                return new XPathNodeList((NodeIterator)nodes);
            }
            if (nodes == null) {
                throw new NullPointerException();
            }
            NodeList.class.cast(nodes);
        }
        return null;
    }

    public XPathNodeList() {
    }

    public XPathNodeList(Iterable<Node> nodes) {
        super(XPathNodeList.fromIterable(nodes));
    }

    public XPathNodeList(NodeList nodes) {
        this((Iterable<Node>)XPathNodeList.fromNodeList(nodes));
    }

    public XPathNodeList(NodeIterator nodes) {
        this((Iterable<Node>)XPathNodeList.fromNodeIterator(nodes));
    }

    public XPathNodeList(Node node) {
        this((Iterable<Node>)Arrays.asList(node));
    }

    @Override
    public Node item(int index) {
        return (Node)this.get(index);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    public static void assertNodeSet(Object nodes) {
        for (Node node : XPathNodeList.fromNodes(nodes, true)) {
            Node.class.cast(node);
        }
    }

    public static boolean isNodeSet(Object o) {
        if (o instanceof Node || o instanceof NodeIterator || o instanceof NodeList) {
            return true;
        }
        if (o instanceof Iterable) {
            Iterator nodes = ((Iterable)o).iterator();
            while (nodes.hasNext()) {
                if (nodes.next() instanceof Node) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Node> fromNodeList(NodeList nodes) {
        ArrayList<Node> result = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            result.add(nodes.item(i));
            ++i;
        }
        return result;
    }

    private static List<Node> fromNodeIterator(NodeIterator nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        Node next = null;
        while ((next = nodes.nextNode()) != null) {
            result.add(next);
        }
        return result;
    }

    private static List<Node> fromIterable(Iterable<Node> nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

