/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ibboost.orqa.xpath.XPathAttribute;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class XPathNode
implements Node {
    private Integer position;

    void setPosition(int position) {
        this.position = position;
    }

    private int getPosition() {
        if (this.position == null && this.getParentNode() != null) {
            NodeList siblings = this.getParentNode().getChildNodes();
            int i = 0;
            while (i < siblings.getLength()) {
                if (this.isSameNode(siblings.item(i))) {
                    this.position = i;
                    break;
                }
                ++i;
            }
        }
        return this.position != null ? this.position : 0;
    }

    @Override
    public Node getPreviousSibling() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof XPathParentNode) {
            return ((XPathParentNode)parentNode).item(this.getPosition() - 1);
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof XPathParentNode) {
            return ((XPathParentNode)parentNode).item(this.getPosition() + 1);
        }
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new NotSupportedException();
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version2) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    public List<XPathNode> getPath() {
        ArrayList<XPathNode> result = new ArrayList<XPathNode>();
        XPathNode current = this;
        while (current != null) {
            result.add(current);
            current = (XPathNode)(current instanceof XPathAttribute ? ((XPathAttribute)current).getOwnerElement() : current.getParentNode());
        }
        Collections.reverse(result);
        return result;
    }

    private static int getNearestCommonAncestorIndex(List<XPathNode> pathA, List<XPathNode> pathB) {
        int result = -1;
        int i = 0;
        while (i < pathA.size() && i < pathB.size()) {
            if (!pathA.get(i).isSameNode(pathB.get(i))) break;
            result = i++;
        }
        return result;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        XPathNode otherSibling;
        List<XPathNode> otherPath;
        if (!(other instanceof XPathNode)) {
            throw new NotSupportedException();
        }
        XPathNode otherNode = (XPathNode)other;
        if (this.isSameNode(otherNode)) {
            return 0;
        }
        List<XPathNode> thisPath = this.getPath();
        int commonAncestorIndex = XPathNode.getNearestCommonAncestorIndex(thisPath, otherPath = otherNode.getPath());
        if (commonAncestorIndex == -1) {
            return 1;
        }
        XPathNode commonAncestor = thisPath.get(commonAncestorIndex);
        XPathNode thisSibling = thisPath.size() > commonAncestorIndex + 1 ? thisPath.get(commonAncestorIndex + 1) : null;
        XPathNode xPathNode = otherSibling = otherPath.size() > commonAncestorIndex + 1 ? otherPath.get(commonAncestorIndex + 1) : null;
        if (thisSibling == null && otherSibling == null) {
            return 0;
        }
        if (thisSibling == null) {
            return 10;
        }
        if (otherSibling == null) {
            return 20;
        }
        if (thisSibling instanceof XPathAttribute || otherSibling instanceof XPathAttribute) {
            if (!(otherSibling instanceof XPathAttribute)) {
                return 34;
            }
            if (!(thisSibling instanceof XPathAttribute)) {
                return 36;
            }
            NamedNodeMap attributes = commonAncestor.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node item = attributes.item(i);
                if (item.isSameNode(thisSibling)) {
                    return 34;
                }
                if (item.isSameNode(otherSibling)) {
                    return 36;
                }
                ++i;
            }
            return 1;
        }
        return otherSibling.getPosition() < thisSibling.getPosition() ? (short)4 : 2;
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new NotSupportedException();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new ReadOnlyException();
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new NotSupportedException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new NotSupportedException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new NotSupportedException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return arg == this;
    }

    @Override
    public Object getFeature(String feature, String version2) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new NotSupportedException();
    }

    @Override
    public Object getUserData(String key) {
        throw new NotSupportedException();
    }

    protected static class NotSupportedException
    extends DOMException {
        private static final long serialVersionUID = -903934139100836709L;

        public NotSupportedException() {
            super((short)9, "Operation not supported");
        }
    }

    protected static class ReadOnlyException
    extends DOMException {
        private static final long serialVersionUID = 2342785925628192583L;

        public ReadOnlyException() {
            super((short)7, "No modification allowed");
        }
    }
}

