/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class XPathNamespaceContext
implements NamespaceContext {
    private final Map<String, String> mappings;

    public XPathNamespaceContext(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.mappings.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
            if (!mapping.getValue().equalsIgnoreCase(namespaceURI)) continue;
            return mapping.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
            if (!mapping.getValue().equalsIgnoreCase(namespaceURI)) continue;
            result.add(mapping.getKey());
        }
        return result.iterator();
    }
}

