/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.Arrays;
import org.ibboost.orqa.xpath.XPathAttribute;
import org.ibboost.orqa.xpath.XPathNode;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public abstract class XPathElement
extends XPathParentNode
implements Element {
    private final Document ownerDocument;
    private final XPathParentNode parent;
    private String tagName;

    public XPathElement(XPathParentNode parent) {
        this.ownerDocument = parent instanceof Document || parent == null ? (Document)((Object)parent) : parent.getOwnerDocument();
        this.parent = parent;
    }

    @Override
    public synchronized String getTagName() {
        if (this.tagName == null) {
            this.tagName = this.initTagName();
        }
        return this.tagName;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public Attr getAttributeNode(String name) {
        if (!this.hasAttribute(name)) {
            return null;
        }
        return new XPathAttribute(name, this);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttribute(localName);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public boolean hasAttribute(String name) {
        return Arrays.asList(this.initAttributeNames()).contains(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new XPathNode.NotSupportedException();
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        throw null;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public boolean hasAttributes() {
        return this.initAttributeNames().length > 0;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new NamedNodeMap(){

            @Override
            public Node getNamedItem(String name) {
                return XPathElement.this.getAttributeNode(name);
            }

            @Override
            public Node setNamedItem(Node arg) throws DOMException {
                throw new XPathNode.ReadOnlyException();
            }

            @Override
            public Node removeNamedItem(String name) throws DOMException {
                throw new XPathNode.ReadOnlyException();
            }

            @Override
            public Node item(int index) {
                return new XPathAttribute(XPathElement.this.initAttributeNames()[index], XPathElement.this);
            }

            @Override
            public int getLength() {
                return XPathElement.this.initAttributeNames().length;
            }

            @Override
            public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
                throw new XPathNode.NotSupportedException();
            }

            @Override
            public Node setNamedItemNS(Node arg) throws DOMException {
                throw new XPathNode.NotSupportedException();
            }

            @Override
            public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
                throw new XPathNode.NotSupportedException();
            }
        };
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public String toString() {
        return String.valueOf(this.getParentNode().toString()) + "/" + this.getNodeName();
    }

    public String getIndexedPath() {
        if (!(this.getParentNode() instanceof Element)) {
            return "/" + this.getNodeName();
        }
        StringBuilder result = new StringBuilder();
        Element parent = (Element)this.getParentNode();
        result.append(parent instanceof XPathElement ? ((XPathElement)parent).getIndexedPath() : parent.toString());
        result.append("/").append(this.getNodeName());
        NodeList siblings = parent.getChildNodes();
        int sameNameSiblingCount = 0;
        int i = 0;
        while (i < siblings.getLength()) {
            Node sibling = siblings.item(i);
            if (sibling instanceof Element && this.getNodeName().equals(((Element)sibling).getNodeName())) {
                ++sameNameSiblingCount;
            }
            if (sibling.equals(this)) {
                result.append("[").append(sameNameSiblingCount).append("]");
                break;
            }
            ++i;
        }
        return result.toString();
    }

    protected abstract String initTagName();

    protected abstract String[] initAttributeNames();
}

