/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import org.ibboost.orqa.xpath.XPathElement;
import org.ibboost.orqa.xpath.XPathLeafNode;
import org.ibboost.orqa.xpath.XPathNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class XPathAttribute
extends XPathLeafNode
implements Attr {
    private final String name;
    private final XPathElement ownerElement;

    public XPathAttribute(String name, XPathElement ownerElement) {
        this.name = name;
        this.ownerElement = ownerElement;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.ownerElement.getAttribute(this.name);
    }

    @Override
    public void setValue(String value) throws DOMException {
        throw new XPathNode.ReadOnlyException();
    }

    @Override
    public Element getOwnerElement() {
        return this.ownerElement;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.ownerElement.getAttribute(this.name);
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerElement.getOwnerDocument();
    }

    @Override
    public boolean isSameNode(Node other) {
        if (!(other instanceof XPathAttribute)) {
            return false;
        }
        XPathAttribute otherAttr = (XPathAttribute)other;
        if (this.ownerElement == null || !this.ownerElement.isSameNode(otherAttr.getOwnerElement())) {
            return false;
        }
        return this.name.equals(otherAttr.getName());
    }

    public String toString() {
        return String.valueOf(this.ownerElement.toString()) + "/@" + this.name;
    }
}

