/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTree;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.IAutomatableItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTreeNode
extends AutomatableTree
implements IAutomatableItem {
    public static final String XNODE_NAME = "Node";
    private final Object treeItem;

    public AutomatableTreeNode(Object tree, Object treeItem, AutomatableSwtComponent parent) {
        super(tree, parent);
        this.treeItem = treeItem;
    }

    public AutomatableTreeNode(Object treeItem, AutomatableSwtComponent parent) {
        super(AutomatableTreeNode.getTree(treeItem), parent);
        this.treeItem = treeItem;
    }

    @Override
    protected Object getParentComponent() throws JavaAppException {
        return AutomatableTreeNode.getTreeItemParent(this.treeItem);
    }

    @Override
    public Object getItem() {
        return this.treeItem;
    }

    @Override
    public int getItemIndex() {
        try {
            return AutomatableTreeNode.uiSafeExecute(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return (Integer)Reflection.safeCall(AutomatableTreeNode.this.getParentComponent(), "indexOf", Swt.TREE_ITEM_CLASS, AutomatableTreeNode.this.treeItem);
                }
            });
        }
        catch (JavaAppException e) {
            RemoteLogger.error(e);
            return -1;
        }
    }

    private static Object getTree(final Object treeItem) {
        try {
            return AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return Reflection.safeCall(treeItem, "getParent", new Object[0]);
                }
            });
        }
        catch (Exception e) {
            RemoteLogger.error(e);
            return null;
        }
    }

    @Override
    protected Object[] getItems() {
        Object items;
        if (((Boolean)Reflection.safeCall(this.treeItem, "getExpanded", new Object[0])).booleanValue() && (items = Reflection.safeCall(this.treeItem, "getItems", new Object[0])) != null && items.getClass().isArray()) {
            return (Object[])items;
        }
        return new Object[0];
    }

    @Override
    protected AutomatableSwtComponent getChildFromItem(Object item, int itemIndex) {
        if (Swt.TREE_ITEM_CLASS.isInstance(item)) {
            return new AutomatableTreeNode(this.component, item, this);
        }
        return AutomatableSwtComponent.automatableFromComponent(item, this);
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return Swt.convertBounds(Reflection.safeCall(AutomatableTreeNode.this.treeItem, "getBounds", new Object[0]));
            }
        });
    }

    @Override
    protected String getBackground() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object background = Reflection.safeCall(AutomatableTreeNode.this.treeItem, "getBackground", new Object[0]);
                if (Swt.COLOR_CLASS.isInstance(background)) {
                    return AutomatableSwtComponent.colorToHex(background);
                }
                return null;
            }
        });
    }

    @Override
    protected String getForeground() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object foreground = Reflection.safeCall(AutomatableTreeNode.this.treeItem, "getForeground", new Object[0]);
                if (Swt.COLOR_CLASS.isInstance(foreground)) {
                    return AutomatableSwtComponent.colorToHex(foreground);
                }
                return null;
            }
        });
    }

    @Override
    public boolean isMultiSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Arrays.asList((Object[])Reflection.safeCall(AutomatableTreeNode.this.component, "getSelection", new Object[0])).contains(AutomatableTreeNode.this.treeItem);
            }
        });
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    if (replace) {
                        Reflection.safeCall(AutomatableTreeNode.this.component, "setSelection", Swt.TREE_ITEM_CLASS, AutomatableTreeNode.this.treeItem);
                    } else {
                        Reflection.safeCall(AutomatableTreeNode.this.component, "select", Swt.TREE_ITEM_CLASS, AutomatableTreeNode.this.treeItem);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public void deselect() throws JavaAppException {
        AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Reflection.safeCall(AutomatableTreeNode.this.component, "deselect", Swt.TREE_ITEM_CLASS, AutomatableTreeNode.this.treeItem);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    int index = AutomatableTreeNode.this.getItemIndex();
                    if (index != -1) {
                        ++index;
                    }
                    return Integer.toString(index);
                }
                return AutomatableTreeNode.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String text = (String)Reflection.safeCall(AutomatableTreeNode.this.treeItem, "getText", new Object[0]);
                return text == null ? "" : text;
            }
        });
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AutomatableTreeNode)) {
            return false;
        }
        return ((AutomatableTreeNode)other).component == this.component && ((AutomatableTreeNode)other).treeItem == this.treeItem;
    }
}

