/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTableCell;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.IAutomatableItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTableRow
extends AutomatableTable
implements IAutomatableItem {
    public static final String XNODE_NAME = "Row";
    private final int rowIndex;
    private final Object row;

    public AutomatableTableRow(Object table, AutomatableSwtComponent parent, Object row, int rowIndex) {
        super(table, parent);
        this.row = row;
        this.rowIndex = rowIndex;
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<List<AutomatableSwtComponent>>(){

            @Override
            public List<AutomatableSwtComponent> call() throws Exception {
                ArrayList<AutomatableSwtComponent> children = new ArrayList<AutomatableSwtComponent>();
                Integer columnCount = (Integer)Reflection.safeCall(AutomatableTableRow.this.component, "getColumnCount", new Object[0]);
                if (columnCount != null) {
                    for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                        children.add(new AutomatableTableCell(AutomatableTableRow.this.component, AutomatableTableRow.this, AutomatableTableRow.this.row, AutomatableTableRow.this.rowIndex, columnIndex));
                    }
                }
                return children;
            }
        });
    }

    AutomatableTableCell getChild(int columnIndex) {
        return new AutomatableTableCell(this.component, this, this.row, this.rowIndex, columnIndex);
    }

    @Override
    public Object getItem() {
        return this.row;
    }

    @Override
    public int getItemIndex() {
        return this.rowIndex;
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle widthAndXOffset = AutomatableTableRow.this.getRowWidthAndXOffset();
                Rectangle rowBounds = Swt.convertBounds(Reflection.safeCall(AutomatableTableRow.this.row, "getBounds", new Object[0]));
                return new Rectangle(widthAndXOffset.x, rowBounds.y, widthAndXOffset.width, rowBounds.height);
            }
        });
    }

    @Override
    public boolean isMultiSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Boolean.TRUE.equals(Reflection.safeCall(AutomatableTableRow.this.component, "isSelected", Integer.TYPE, AutomatableTableRow.this.rowIndex));
            }
        });
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableTableRow.assertNotUIThread();
        AutomatableTableRow.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (replace) {
                    Reflection.safeCall(AutomatableTableRow.this.component, "deselectAll", new Object[0]);
                }
                Reflection.safeCall(AutomatableTableRow.this.component, "select", Integer.TYPE, AutomatableTableRow.this.rowIndex);
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public void deselect() throws JavaAppException {
        AutomatableTableRow.assertNotUIThread();
        AutomatableTableRow.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Reflection.safeCall(AutomatableTableRow.this.component, "deselect", Integer.TYPE, AutomatableTableRow.this.rowIndex);
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTableRow.this.rowIndex + 1);
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().height);
                }
                return "";
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableRow)) {
            return false;
        }
        return ((AutomatableTableRow)other).row == this.row;
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<AutomatableSwtComponent> children = AutomatableTableRow.this.getChildren();
                ArrayList<Object> results = new ArrayList<Object>();
                for (AutomatableSwtComponent child : children) {
                    results.add(child.getValue());
                }
                return results;
            }
        });
    }
}

