/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTableHeaderCell
extends AutomatableTable {
    public static final String XNODE_NAME = "Header";
    private final Object column;
    private final int columnIndex;

    public AutomatableTableHeaderCell(Object table, AutomatableSwtComponent parent, Object column, int columnIndex) {
        super(table, parent);
        this.column = column;
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() {
        return new ArrayList<AutomatableSwtComponent>();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                int height = (Integer)Reflection.safeCall(AutomatableTableHeaderCell.this.component, "getHeaderHeight", new Object[0]);
                int itemCount = (Integer)Reflection.safeCall(AutomatableTableHeaderCell.this.component, "getItemCount", new Object[0]);
                if (itemCount > 0) {
                    Object firstRow = Reflection.safeCall(AutomatableTableHeaderCell.this.component, "getItem", Integer.TYPE, 0);
                    Rectangle firstCellBounds = Swt.convertBounds(Reflection.safeCall(firstRow, "getBounds", Integer.TYPE, AutomatableTableHeaderCell.this.columnIndex));
                    return new Rectangle(firstCellBounds.x, 0, firstCellBounds.width, height);
                }
                int gridLineWidth = (Integer)Reflection.safeCall(AutomatableTableHeaderCell.this.component, "getGridLineWidth", new Object[0]);
                int x = 0;
                for (int i = 0; i < AutomatableTableHeaderCell.this.columnIndex; ++i) {
                    Object currentColumn = Reflection.safeCall(AutomatableTableHeaderCell.this.component, "getColumn", Integer.TYPE, i);
                    x += (Integer)Reflection.safeCall(currentColumn, "getWidth", new Object[0]) + gridLineWidth;
                }
                int width = (Integer)Reflection.safeCall(AutomatableTableHeaderCell.this.column, "getWidth", new Object[0]) + gridLineWidth;
                return new Rectangle(x, 0, width, height);
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.columnIndex + 1);
                }
                return AutomatableTableHeaderCell.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return (String)Reflection.safeCall(AutomatableTableHeaderCell.this.column, "getText", new Object[0]);
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableHeaderCell)) {
            return false;
        }
        return ((AutomatableTableHeaderCell)other).column == this.column;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

