/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.IAutomatableItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTableCell
extends AutomatableTable
implements IAutomatableItem {
    public static final String XNODE_NAME = "Cell";
    private final Object row;
    private final int rowIndex;
    private final int columnIndex;

    public AutomatableTableCell(Object table, AutomatableSwtComponent parent, Object row, int rowIndex, int columnIndex) {
        super(table, parent);
        this.row = row;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() {
        return new ArrayList<AutomatableSwtComponent>();
    }

    @Override
    public Object getItem() {
        return this.row;
    }

    @Override
    public int getItemIndex() {
        return this.rowIndex;
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return Swt.convertBounds(Reflection.safeCall(AutomatableTableCell.this.row, "getBounds", Integer.TYPE, AutomatableTableCell.this.columnIndex));
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    Object foreground;
                    if (name.equals("index")) {
                        return Integer.toString(AutomatableTableCell.this.columnIndex + 1);
                    }
                    if (name.equals("x")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().x);
                    }
                    if (name.equals("y")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().y);
                    }
                    if (name.equals("width")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().width);
                    }
                    if (name.equals("height")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().height);
                    }
                    if (name.equals("background")) {
                        Object background = Reflection.safeCall(AutomatableTableCell.this.row, "getBackground", Integer.TYPE, AutomatableTableCell.this.columnIndex);
                        if (Swt.COLOR_CLASS.isInstance(background)) {
                            return AutomatableSwtComponent.colorToHex(background);
                        }
                    } else if (name.equals("foreground") && Swt.COLOR_CLASS.isInstance(foreground = Reflection.safeCall(AutomatableTableCell.this.row, "getForeground", Integer.TYPE, AutomatableTableCell.this.columnIndex))) {
                        return AutomatableSwtComponent.colorToHex(foreground);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return "";
            }
        });
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableTableCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    String existingText;
                    String textToSet = text;
                    if (append && (existingText = (String)Reflection.safeCall(AutomatableTableCell.this.row, "getText", Integer.TYPE, AutomatableTableCell.this.columnIndex)) != null) {
                        textToSet = existingText + textToSet;
                    }
                    Reflection.safeCall(AutomatableTableCell.this.row, "setText", Integer.TYPE, AutomatableTableCell.this.columnIndex, String.class, textToSet);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() {
                return (String)Reflection.safeCall(AutomatableTableCell.this.row, "getText", Integer.TYPE, AutomatableTableCell.this.columnIndex);
            }
        });
    }

    @Override
    public boolean isMultiSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Boolean.TRUE.equals(Reflection.safeCall(AutomatableTableCell.this.component, "isSelected", Integer.TYPE, AutomatableTableCell.this.rowIndex));
            }
        });
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableTableCell.assertNotUIThread();
        AutomatableTableCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (replace) {
                    Reflection.safeCall(AutomatableTableCell.this.component, "deselectAll", new Object[0]);
                }
                Reflection.safeCall(AutomatableTableCell.this.component, "select", Integer.TYPE, AutomatableTableCell.this.rowIndex);
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public void deselect() throws JavaAppException {
        AutomatableTableCell.assertNotUIThread();
        AutomatableTableCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Reflection.safeCall(AutomatableTableCell.this.component, "deselect", Integer.TYPE, AutomatableTableCell.this.rowIndex);
                return null;
            }
        });
        this.sendEvent(13);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableCell)) {
            return false;
        }
        return ((AutomatableTableCell)other).row == this.row && ((AutomatableTableCell)other).columnIndex == this.columnIndex;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return true;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

