/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableComboBox;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableItemGroup;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableItemGroupItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableProgressBar;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTree;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.IAutomatableItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.SwtAutomatableKey;

public class AutomatableSwtComponent
extends Automatable {
    protected final Object component;
    protected AutomatableSwtComponent parent;

    public AutomatableSwtComponent(Object component, AutomatableSwtComponent parent) {
        this.component = component;
        this.parent = parent;
    }

    public static List<AutomationElement> getTopLevelElements(AutomationDocument parent) throws JavaAppException {
        List<AutomatableSwtComponent> automatables = AutomatableSwtComponent.uiSafeExecute(new Callable<List<AutomatableSwtComponent>>(){

            @Override
            public List<AutomatableSwtComponent> call() throws Exception {
                ArrayList<AutomatableSwtComponent> result = new ArrayList<AutomatableSwtComponent>();
                for (Object shell : Swt.getShells()) {
                    if (!AutomatableSwtComponent.isVisible(shell)) continue;
                    result.add(new AutomatableSwtComponent(shell, null));
                }
                return result;
            }
        });
        ArrayList<AutomationElement> topLevelElements = new ArrayList<AutomationElement>();
        for (Automatable automatable : automatables) {
            topLevelElements.add(new AutomationElement(automatable, parent));
        }
        return topLevelElements;
    }

    public static boolean isVisible(final Object control) {
        try {
            return AutomatableSwtComponent.uiSafeExecute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Boolean.TRUE.equals(Reflection.safeCall(control, "isVisible", new Object[0]));
                }
            });
        }
        catch (JavaAppException e) {
            return false;
        }
    }

    protected AutomatableSwtComponent initParent() throws JavaAppException {
        Object componentParent = this.getParentComponent();
        if (componentParent == null) {
            return null;
        }
        return AutomatableSwtComponent.automatableFromComponent(componentParent, null);
    }

    @Override
    public synchronized AutomatableSwtComponent getParent() throws JavaAppException {
        if (this.parent != null) {
            return this.parent;
        }
        this.parent = this.initParent();
        return this.parent;
    }

    protected Object getParentComponent() throws JavaAppException {
        return AutomatableSwtComponent.getComponentParent(this.component);
    }

    static Object getComponentParent(final Object component) throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object result = Reflection.safeCall(component, "getParent", new Object[0]);
                if (Swt.WIDGET_CLASS.isInstance(result)) {
                    return result;
                }
                return null;
            }
        });
    }

    protected Object getShell() throws JavaAppException {
        return AutomatableSwtComponent.getComponentShell(this.component);
    }

    private static Object getComponentShell(final Object component) throws JavaAppException {
        if (Swt.SHELL_CLASS.isInstance(component)) {
            return component;
        }
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object shellComponent = component;
                try {
                    if (Reflection.instanceOf(component, Swt.CARET_CLASS, Swt.SCROLL_BAR_CLASS, Swt.TOOL_TIP_CLASS, Swt.COOL_ITEM_CLASS, Swt.CTAB_ITEM_CLASS, Swt.EXPAND_ITEM_CLASS, Swt.MENU_ITEM_CLASS, Swt.TAB_ITEM_CLASS, Swt.TABLE_COLUMN_CLASS, Swt.TABLE_ITEM_CLASS, Swt.TOOL_ITEM_CLASS, Swt.TREE_COLUMN_CLASS, Swt.TREE_ITEM_CLASS)) {
                        shellComponent = AutomatableSwtComponent.getComponentParent(component);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                Object result = Reflection.getPropertyWithReflection(shellComponent, "shell", false, null);
                if (Swt.SHELL_CLASS.isInstance(result)) {
                    return result;
                }
                return null;
            }
        });
    }

    protected Object getControl() throws JavaAppException {
        Object controlComponent = this.component;
        if (Swt.ITEM_CLASS.isInstance(controlComponent)) {
            controlComponent = this.getParentComponent();
        }
        if (Swt.CONTROL_CLASS.isInstance(controlComponent)) {
            return controlComponent;
        }
        return null;
    }

    private boolean isEnabled() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object result = Reflection.safeCall(AutomatableSwtComponent.this.component, "getEnabled", new Object[0]);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return true;
            }
        });
    }

    protected String getBackground() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object background = Reflection.safeCall(AutomatableSwtComponent.this.component, "getBackground", new Object[0]);
                if (Swt.COLOR_CLASS.isInstance(background)) {
                    return AutomatableSwtComponent.colorToHex(background);
                }
                return "";
            }
        });
    }

    protected String getForeground() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object foreground = Reflection.safeCall(AutomatableSwtComponent.this.component, "getForeground", new Object[0]);
                if (Swt.COLOR_CLASS.isInstance(foreground)) {
                    return AutomatableSwtComponent.colorToHex(foreground);
                }
                return "";
            }
        });
    }

    protected static String colorToHex(Object color) {
        if (color == null) {
            return "";
        }
        int red = (Integer)Reflection.safeCall(color, "getRed", new Object[0]);
        int green = (Integer)Reflection.safeCall(color, "getGreen", new Object[0]);
        int blue = (Integer)Reflection.safeCall(color, "getBlue", new Object[0]);
        return String.format("#%02X%02X%02X", red & 0xFF, green & 0xFF, blue & 0xFF);
    }

    @Override
    public String getName() {
        if (Swt.SHELL_CLASS.isInstance(this.component)) {
            return "Window";
        }
        return super.getName();
    }

    protected AutomatableSwtComponent getChildFromItem(Object item, int itemIndex) {
        if (Swt.WIDGET_CLASS.isInstance(item)) {
            return AutomatableSwtComponent.automatableFromComponent(item);
        }
        return null;
    }

    protected Object[] getItems() {
        Object items = Reflection.safeCall(this.component, "getItems", new Object[0]);
        if (items != null && items.getClass().isArray()) {
            return (Object[])items;
        }
        return new Object[0];
    }

    public List<AutomatableSwtComponent> getChildren() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<List<AutomatableSwtComponent>>(){

            @Override
            public List<AutomatableSwtComponent> call() throws Exception {
                Object children;
                ArrayList<AutomatableSwtComponent> result = new ArrayList<AutomatableSwtComponent>();
                if (Swt.COMPOSITE_CLASS.isInstance(AutomatableSwtComponent.this.component) && (children = Reflection.safeCall(AutomatableSwtComponent.this.component, "getChildren", new Object[0])) instanceof Object[]) {
                    for (Object child : (Object[])children) {
                        if (Swt.CONTROL_CLASS.isInstance(child) && !AutomatableSwtComponent.isVisible(child)) continue;
                        result.add(AutomatableSwtComponent.automatableFromComponent(child));
                    }
                }
                if (Swt.DECORATIONS_CLASS.isInstance(AutomatableSwtComponent.this.component)) {
                    Object[] menus;
                    for (Object menu : menus = (Object[])Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "menus", false, new Object[0])) {
                        if (!AutomatableSwtComponent.isVisible(menu) || Integer.valueOf(0).equals(Reflection.safeCall(menu, "getItemCount", new Object[0]))) continue;
                        result.add(AutomatableSwtComponent.automatableFromComponent(menu));
                    }
                }
                Object[] items = AutomatableSwtComponent.this.getItems();
                for (int i = 0; i < items.length; ++i) {
                    AutomatableSwtComponent itemChild = AutomatableSwtComponent.this.getChildFromItem(items[i], i);
                    if (itemChild == null) continue;
                    result.add(itemChild);
                }
                return result;
            }
        });
    }

    @Override
    public Object getComponent() {
        return this.component;
    }

    @Override
    public boolean isVirtualComponent() {
        AutomatableSwtComponent rootAutomtable = AutomatableSwtComponent.automatableFromComponent(this.component);
        return !this.getClass().equals(rootAutomtable.getClass());
    }

    private Rectangle getComponentBounds() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Object bounds = Reflection.safeCall(AutomatableSwtComponent.this.component, "getBounds", new Object[0]);
                if (bounds == null) {
                    try {
                        int x = (Integer)Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "x", false, 0);
                        int y = (Integer)Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "x", false, 0);
                        int width = (Integer)Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "width", false, 0);
                        int height = (Integer)Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "height", false, 0);
                        return new Rectangle(x, y, width, height);
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                }
                return Swt.convertBounds(bounds);
            }
        });
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        Rectangle componentBounds = this.getComponentBounds();
        return new Rectangle(0, 0, componentBounds.width, componentBounds.height);
    }

    @Override
    public Rectangle getParentRelativeBounds() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                AutomatableSwtComponent parent = AutomatableSwtComponent.this.getParent();
                Rectangle bounds = AutomatableSwtComponent.this.getComponentRelativeBounds();
                if (parent != null) {
                    if (parent.getComponent() == AutomatableSwtComponent.this.component) {
                        Rectangle parentComponentRelativeBounds = parent.getComponentRelativeBounds();
                        bounds.x -= parentComponentRelativeBounds.x;
                        bounds.y -= parentComponentRelativeBounds.y;
                    } else {
                        Rectangle componentBounds = AutomatableSwtComponent.this.getComponentBounds();
                        bounds.x = (int)((double)bounds.x + componentBounds.getX());
                        bounds.y = (int)((double)bounds.y + componentBounds.getY());
                    }
                }
                return bounds;
            }
        });
    }

    @Override
    public Rectangle getWindowRelativeBounds() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle bounds = AutomatableSwtComponent.this.getParentRelativeBounds();
                for (AutomatableSwtComponent current = AutomatableSwtComponent.this.getParent(); current != null; current = current.getParent()) {
                    Rectangle currentBounds = current.getParentRelativeBounds();
                    bounds.x = (int)((double)bounds.x + currentBounds.getX());
                    bounds.y = (int)((double)bounds.y + currentBounds.getY());
                }
                return bounds;
            }
        });
    }

    @Override
    public String[] getAttributeNames() {
        if (Swt.BUTTON_CLASS.isInstance(this.component)) {
            return XATTR_BUTTONS;
        }
        if (this.hasTextAttribute()) {
            return XATTR_TEXT_CONTROLS;
        }
        if (Swt.SHELL_CLASS.isInstance(this.component)) {
            return XATTR_FRAMES;
        }
        return XATTR_NAME_POSITION_SIZE;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        if (!this.hasAttribute(name)) {
            return "";
        }
        return AutomatableSwtComponent.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object selection;
                if (name.equals("name")) {
                    return AutomatableSwtComponent.this.getName();
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableSwtComponent.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableSwtComponent.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableSwtComponent.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableSwtComponent.this.getWindowRelativeBounds().height);
                }
                if (name.equals("enabled")) {
                    return Boolean.toString(AutomatableSwtComponent.this.isEnabled());
                }
                if (name.equals("background")) {
                    return AutomatableSwtComponent.this.getBackground();
                }
                if (name.equals("foreground")) {
                    return AutomatableSwtComponent.this.getForeground();
                }
                String value = "";
                if (name.equals("text")) {
                    if (Swt.BUTTON_CLASS.isInstance(AutomatableSwtComponent.this.component) || Swt.LABEL_CLASS.isInstance(AutomatableSwtComponent.this.component)) {
                        Object getTextResult = Reflection.safeCall(AutomatableSwtComponent.this.component, "getText", new Object[0]);
                        if (getTextResult == null || getTextResult.toString().isEmpty()) {
                            getTextResult = Reflection.safeCall(AutomatableSwtComponent.this.component, "getToolTipText", new Object[0]);
                        }
                        if (getTextResult != null) {
                            value = getTextResult.toString();
                        }
                    }
                } else if (name.equals("title")) {
                    Object getTextResult;
                    if (Swt.SHELL_CLASS.isInstance(AutomatableSwtComponent.this.component) && (getTextResult = Reflection.safeCall(AutomatableSwtComponent.this.component, "getText", new Object[0])) != null) {
                        value = getTextResult.toString();
                    }
                } else if (name.equals("selected") && Swt.BUTTON_CLASS.isInstance(AutomatableSwtComponent.this.component) && (selection = Reflection.safeCall(AutomatableSwtComponent.this.component, "getSelection", new Object[0])) != null) {
                    value = selection.toString();
                }
                return value != null ? value : "";
            }
        });
    }

    private int getStyle() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Object style = Reflection.getPropertyWithReflection(AutomatableSwtComponent.this.component, "style", true, 0);
                if (style instanceof Number) {
                    return ((Number)style).intValue();
                }
                return 0;
            }
        });
    }

    public boolean isMultiSelectable() {
        return false;
    }

    @Override
    public boolean isPasswordField() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return (AutomatableSwtComponent.this.getStyle() & 0x400000) != 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    protected boolean hasTextAttribute() {
        return Swt.BUTTON_CLASS.isInstance(this.component) || Swt.LABEL_CLASS.isInstance(this.component);
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object callResult = Reflection.safeCall(AutomatableSwtComponent.this.component, "getEditable", new Object[0]);
                if (callResult instanceof Boolean) {
                    return (Boolean)callResult;
                }
                try {
                    Reflection.getMethod(AutomatableSwtComponent.this.component.getClass(), "setText", String.class);
                    return true;
                }
                catch (Exception e) {
                    RemoteLogger.debug(e);
                    return false;
                }
            }
        });
    }

    @Override
    public boolean isVisible() throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object result = Reflection.safeCall(AutomatableSwtComponent.this.component, "isVisible", new Object[0]);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return true;
            }
        });
    }

    @Override
    public AutomationTarget getDragEventTarget(final Point offset) throws JavaAppException {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Rectangle referenceAutomatableBounds = AutomatableSwtComponent.this.getComponentRelativeBounds();
                if (offset.x >= 0 && offset.x < referenceAutomatableBounds.width && offset.y >= 0 && offset.y < referenceAutomatableBounds.height) {
                    return new AutomationTarget(AutomatableSwtComponent.this, offset.x, offset.y);
                }
                Point absoluteOffset = new Point(referenceAutomatableBounds.x + offset.x, referenceAutomatableBounds.y + offset.y);
                Object currentComponent = AutomatableSwtComponent.this.getComponent();
                while (Swt.CONTROL_CLASS.isInstance(AutomatableSwtComponent.this.component) && AutomatableSwtComponent.getComponentParent(currentComponent) != null) {
                    Object componentBounds = Reflection.safeCall(AutomatableSwtComponent.this.component, "getLocation", new Object[0]);
                    Integer x = (Integer)Reflection.getPropertyWithReflection(componentBounds, "x", false, null);
                    Integer y = (Integer)Reflection.getPropertyWithReflection(componentBounds, "y", false, null);
                    absoluteOffset.translate(x, y);
                    currentComponent = AutomatableSwtComponent.getComponentParent(currentComponent);
                }
                return AutomatableSwtComponent.automatableFromComponent(currentComponent).getClickEventTarget(absoluteOffset);
            }
        });
    }

    protected static void assertNotUIThread() {
        if (Swt.isDisplayThread()) {
            throw new RuntimeException("This action cannot be run from the UI thread.");
        }
    }

    protected Object getDisplay() {
        return AutomatableSwtComponent.getDisplay(this.component);
    }

    protected static Object getDisplay(Object component) {
        return Reflection.safeCall(component, "getDisplay", new Object[0]);
    }

    protected void sendEvent(int eventType) throws JavaAppException {
        AutomatableSwtComponent.sendEvent(this.component, null, eventType, null);
    }

    private static void sendEvent(final Object widget, Object event, final int eventType, final AtomicBoolean eventPushConfirmation) throws JavaAppException {
        AutomatableSwtComponent.assertNotUIThread();
        final AtomicReference error = new AtomicReference();
        try {
            Object finalEvent;
            Object object = finalEvent = event != null ? event : Swt.createEvent(widget, widget, AutomatableSwtComponent.getDisplay(widget), eventType, 0, 0, '\u0000', 0, 0, 0);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Swt.asyncExecuteOnDisplayThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Reflection.call(widget, "notifyListeners", Integer.TYPE, eventType, Swt.EVENT_CLASS, finalEvent);
                        if (eventPushConfirmation != null) {
                            eventPushConfirmation.set(true);
                        }
                    }
                    catch (Throwable e) {
                        error.set(e);
                    }
                }
            });
            if (error.get() != null) {
                throw (Throwable)error.get();
            }
        }
        catch (Throwable e) {
            throw JavaAppException.wrap(e);
        }
    }

    private static Object newKeyEvent(Object widget, int type, int keyCode, char keyChar, int stateMask) throws Exception {
        return Swt.createEvent(widget, widget, AutomatableSwtComponent.getDisplay(widget), type, stateMask, keyCode, keyChar, 0, 0, 0);
    }

    @Override
    public void sendKey(AutomatableKey automatableKey, boolean shift, boolean alt, boolean ctrl, boolean forceFocus) throws JavaAppException {
        try {
            AutomatableSwtComponent.assertNotUIThread();
            if (forceFocus) {
                this.getFocus();
            }
            SwtAutomatableKey swtKey = SwtAutomatableKey.fromAutomatableKey(automatableKey);
            SwtAutomatableKey.KeyCombo keyCombo = swtKey.getKeyCombo();
            int stateMask = 0;
            Object display = this.getDisplay();
            Method eventPost = Reflection.getMethod(Swt.DISPLAY_CLASS, "post", Swt.EVENT_CLASS);
            if (ctrl || keyCombo.isCtrl()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 1, 262144, '\u0000', stateMask));
                stateMask |= 0x40000;
            }
            if (alt || keyCombo.isAlt()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 1, 65536, '\u0000', stateMask));
                stateMask |= 0x10000;
            }
            if (shift || keyCombo.isShift()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 1, 131072, '\u0000', stateMask));
                stateMask |= 0x20000;
            }
            char c = shift ? Character.toUpperCase(keyCombo.getKeyChar()) : keyCombo.getKeyChar();
            eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 1, keyCombo.getKeyCode(), c, stateMask));
            eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 2, keyCombo.getKeyCode(), c, stateMask));
            if (ctrl || keyCombo.isCtrl()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 2, 262144, '\u0000', stateMask));
            }
            if (alt || keyCombo.isAlt()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 2, 65536, '\u0000', stateMask));
            }
            if (shift || keyCombo.isShift()) {
                eventPost.invoke(display, AutomatableSwtComponent.newKeyEvent(this.component, 2, 131072, '\u0000', stateMask));
            }
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    private static void sendMouseEvent(Object widget, Object item, int button, int stateMask, int eventType, int x, int y, AtomicBoolean clickSentConfirmation) throws JavaAppException {
        try {
            Object event = Swt.createEvent(widget, item, AutomatableSwtComponent.getDisplay(widget), eventType, stateMask, 0, '\u0000', button, x, y);
            AutomatableSwtComponent.sendEvent(widget, event, eventType, clickSentConfirmation);
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    @Override
    public void click(AutomatableClick clickType, int x, int y, boolean shift, boolean alt, boolean ctrl, AtomicBoolean clickSentConfirmation) throws JavaAppException {
        Object control;
        AutomatableSwtComponent.assertNotUIThread();
        Rectangle bounds = this.getComponentRelativeBounds();
        final int componentRelativeX = Math.max(Math.min(x, bounds.width - 1), 0) + bounds.x;
        final int componentRelativeY = Math.max(Math.min(y, bounds.height - 1), 0) + bounds.y;
        int mouseButton = 0;
        if (clickType == AutomatableClick.LEFT) {
            mouseButton = 1;
        } else if (clickType == AutomatableClick.DOUBLE_CLICK) {
            mouseButton = 1;
        } else if (clickType == AutomatableClick.MIDDLE) {
            mouseButton = 2;
        } else if (clickType == AutomatableClick.RIGHT) {
            mouseButton = 3;
        }
        int stateMask = 0;
        if (shift) {
            stateMask |= 0x20000;
        }
        if (alt) {
            stateMask |= 0x10000;
        }
        if (ctrl) {
            stateMask |= 0x40000;
        }
        final Object widget = (control = this.getControl()) != null ? control : this.component;
        Object item = this instanceof IAutomatableItem ? ((IAutomatableItem)((Object)this)).getItem() : null;
        AutomatableSwtComponent.sendMouseEvent(widget, item, 0, 0, 6, componentRelativeX, componentRelativeY, null);
        AutomatableSwtComponent.sendMouseEvent(widget, item, 0, 0, 5, componentRelativeX, componentRelativeY, null);
        this.sendEvent(32);
        Swt.syncExecuteOnDisplayThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Boolean.TRUE.equals(Reflection.safeCall(widget, "isFocusControl", new Object[0]))) {
                        Reflection.safeCall(widget, "setFocus", new Object[0]);
                    }
                }
                catch (Throwable e) {
                    RemoteLogger.error(e);
                }
            }
        });
        AutomatableSwtComponent.sendMouseEvent(widget, item, mouseButton, stateMask, 3, componentRelativeX, componentRelativeY, clickSentConfirmation);
        if (clickType == AutomatableClick.DOUBLE_CLICK) {
            AutomatableSwtComponent.sendMouseEvent(widget, item, mouseButton, stateMask, 8, componentRelativeX, componentRelativeY, clickSentConfirmation);
        }
        AutomatableSwtComponent.sendMouseEvent(widget, item, mouseButton, stateMask, 4, componentRelativeX, componentRelativeY, null);
        if (clickType == AutomatableClick.LEFT) {
            if (this.isMultiSelectable()) {
                if (ctrl) {
                    this.toggleSelected();
                } else {
                    this.select(!shift);
                }
            } else {
                this.select(true);
            }
        } else if (clickType == AutomatableClick.DOUBLE_CLICK) {
            if (this.isMultiSelectable() && !ctrl) {
                this.select(true);
            }
            AutomatableSwtComponent.sendMouseEvent(widget, item, 0, 0, 14, 0, 0, null);
        } else if (clickType == AutomatableClick.RIGHT) {
            if (this.isMultiSelectable() && !ctrl) {
                this.select(true);
            }
            Swt.syncExecuteOnDisplayThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Point screenCoordinates = Swt.convertPoint(Reflection.safeCall(widget, "toDisplay", Integer.TYPE, componentRelativeX, Integer.TYPE, componentRelativeY));
                        Reflection.safeCall(widget, "showMenu", Integer.TYPE, screenCoordinates.x, Integer.TYPE, screenCoordinates.y);
                    }
                    catch (Throwable e) {
                        RemoteLogger.error(e);
                    }
                }
            });
        }
        AutomatableSwtComponent.sendMouseEvent(widget, item, 0, 0, 5, componentRelativeX, componentRelativeY, null);
        AutomatableSwtComponent.sendMouseEvent(widget, item, 0, 0, 7, componentRelativeX, componentRelativeY, null);
    }

    @Override
    public void drag(AutomationTarget dropAutomationTarget) throws Exception {
    }

    @Override
    public void getFocus() throws JavaAppException {
        AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object focusComponent = AutomatableSwtComponent.this.getControl();
                if (focusComponent != null) {
                    boolean isFocusControl = (Boolean)Reflection.safeCall(focusComponent, "isFocusControl", new Object[0]);
                    if (isFocusControl) {
                        return null;
                    }
                    Object shell = AutomatableSwtComponent.this.getShell();
                    Reflection.safeCall(shell, "forceActive", new Object[0]);
                    Reflection.safeCall(shell, "forceFocus", new Object[0]);
                    Reflection.safeCall(focusComponent, "forceFocus", new Object[0]);
                }
                return null;
            }
        });
    }

    @Override
    public void transferFocus() throws JavaAppException {
        AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                boolean isFocusControl;
                Object shell = AutomatableSwtComponent.this.getShell();
                if (shell == null) {
                    throw new UnsupportedOperationException();
                }
                Object focusComponent = AutomatableSwtComponent.this.getControl();
                if (focusComponent != null && !(isFocusControl = ((Boolean)Reflection.safeCall(focusComponent, "isFocusControl", new Object[0])).booleanValue())) {
                    return null;
                }
                Reflection.safeCall(shell, "forceActive", new Object[0]);
                Reflection.safeCall(shell, "forceFocus", new Object[0]);
                return null;
            }
        });
    }

    public boolean isSelected() throws JavaAppException {
        return false;
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableSwtComponent.assertNotUIThread();
        this.sendEvent(13);
    }

    public void deselect() throws JavaAppException {
    }

    public void toggleSelected() throws JavaAppException {
        boolean selected = this.isSelected();
        if (selected) {
            this.deselect();
        } else {
            this.select(false);
        }
    }

    @Override
    public void setSize(final int width, final int height) throws JavaAppException {
        AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Swt.SHELL_CLASS.isInstance(AutomatableSwtComponent.this.component)) {
                    Reflection.safeCall(AutomatableSwtComponent.this.component, "setSize", Integer.TYPE, width, Integer.TYPE, height);
                }
                return null;
            }
        });
    }

    @Override
    public void setLocation(final int x, final int y) throws JavaAppException {
        AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Swt.SHELL_CLASS.isInstance(AutomatableSwtComponent.this.component)) {
                    Reflection.safeCall(AutomatableSwtComponent.this.component, "setLocation", Integer.TYPE, x, Integer.TYPE, y);
                }
                return null;
            }
        });
    }

    @Override
    public void maximise() throws JavaAppException {
        AutomatableSwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Swt.SHELL_CLASS.isInstance(AutomatableSwtComponent.this.component)) {
                    Reflection.safeCall(AutomatableSwtComponent.this.component, "setMaximized", Boolean.TYPE, true);
                }
                return null;
            }
        });
    }

    public static List<byte[]> captureImages(final List<AutomatableSwtComponent> components) throws Exception {
        return AutomatableSwtComponent.uiSafeExecute(new Callable<List<byte[]>>(){

            @Override
            public List<byte[]> call() throws Exception {
                HashMap cache = new HashMap();
                ArrayList<byte[]> images = new ArrayList<byte[]>();
                for (AutomatableSwtComponent automatable : components) {
                    Object image;
                    Object widget;
                    if (!(automatable instanceof AutomatableSwtComponent) || !Swt.CONTROL_CLASS.isInstance(widget = automatable.getComponent())) continue;
                    Rectangle componentBounds = automatable.getComponentBounds();
                    if (cache.containsKey(widget)) {
                        image = cache.get(widget);
                    } else {
                        Object gc = Reflection.newObject(Swt.GC_CLASS, Swt.DRAWABLE_CLASS, widget);
                        Object widgetDisplay = AutomatableSwtComponent.getDisplay(widget);
                        image = Reflection.newObject(Swt.IMAGE_CLASS, Swt.DEVICE_CLASS, widgetDisplay, Integer.TYPE, componentBounds.width, Integer.TYPE, componentBounds.height);
                        Reflection.safeCall(gc, "copyArea", Swt.IMAGE_CLASS, image, Integer.TYPE, 0, Integer.TYPE, 0);
                        Reflection.safeCall(gc, "dispose", new Object[0]);
                        cache.put(widget, image);
                    }
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    Rectangle bounds = automatable.getComponentRelativeBounds();
                    Object subimage = null;
                    if (bounds.x != 0 || bounds.y != 0 || bounds.width != componentBounds.width || bounds.height != componentBounds.height) {
                        Object gc = Reflection.newObject(Swt.GC_CLASS, Swt.DRAWABLE_CLASS, image);
                        Object widgetDisplay = AutomatableSwtComponent.getDisplay(widget);
                        subimage = Reflection.newObject(Swt.IMAGE_CLASS, Swt.DEVICE_CLASS, widgetDisplay, Integer.TYPE, bounds.width, Integer.TYPE, bounds.height);
                        Reflection.safeCall(gc, "copyArea", Swt.IMAGE_CLASS, subimage, Integer.TYPE, bounds.x, Integer.TYPE, bounds.y);
                        Reflection.safeCall(gc, "dispose", new Object[0]);
                    }
                    Object croppedImage = subimage != null ? subimage : (Object)image;
                    Object loader = Swt.IMAGE_LOADER_CLASS.newInstance();
                    Object imageData = Reflection.safeCall(croppedImage, "getImageData", new Object[0]);
                    Object imageDataArray = Reflection.newArray(Swt.IMAGE_DATA_CLASS, Arrays.asList(imageData));
                    Reflection.setPropertyWithReflection(loader, "data", false, imageDataArray);
                    Reflection.safeCall(loader, "save", OutputStream.class, outputStream, Integer.TYPE, 5);
                    outputStream.flush();
                    images.add(outputStream.toByteArray());
                    if (subimage == null) continue;
                    Reflection.safeCall(subimage, "dispose", new Object[0]);
                }
                for (Object image : cache.values()) {
                    Reflection.safeCall(image, "dispose", new Object[0]);
                }
                return images;
            }
        });
    }

    public static AutomatableSwtComponent automatableFromComponent(Object component) {
        return AutomatableSwtComponent.automatableFromComponent(component, null);
    }

    public static AutomatableSwtComponent automatableFromComponent(Object component, AutomatableSwtComponent parent) {
        if (Swt.TREE_CLASS.isInstance(component)) {
            return new AutomatableTree(component, parent);
        }
        if (Swt.TOOLBAR_CLASS.isInstance(component) || Swt.TAB_FOLDER_CLASS.isInstance(component) || Swt.CTAB_FOLDER_CLASS.isInstance(component) || Swt.MENU_CLASS.isInstance(component)) {
            return new AutomatableItemGroup(component, parent);
        }
        if (Swt.COMBO_CLASS.isInstance(component)) {
            return new AutomatableComboBox(component, parent);
        }
        if (Swt.TABLE_CLASS.isInstance(component)) {
            return new AutomatableTable(component, parent);
        }
        if (Swt.PROGRESS_BAR_CLASS.isInstance(component)) {
            return new AutomatableProgressBar(component, parent);
        }
        if (AutomatableItemGroupItem.getItemType(component) != null) {
            return new AutomatableItemGroupItem(component, parent);
        }
        return new AutomatableSwtComponent(component, parent);
    }
}

