/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.IAutomatableItem;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableItemGroupItem
extends AutomatableSwtComponent
implements IAutomatableItem {
    private static final Class<?>[] ITEM_GROUP_ITEM_TYPES = new Class[]{Swt.CTAB_ITEM_CLASS, Swt.TAB_ITEM_CLASS, Swt.MENU_ITEM_CLASS, Swt.TOOL_ITEM_CLASS};
    private final Class<?> itemType;
    private Object group;

    public AutomatableItemGroupItem(Object item, AutomatableSwtComponent parent) {
        super(item, parent);
        this.itemType = AutomatableItemGroupItem.getItemType(item);
    }

    @Override
    public Object getItem() {
        return this.component;
    }

    @Override
    public int getItemIndex() {
        try {
            Object index = Reflection.safeCall(this.getGroup(), "indexOf", this.itemType, this.component);
            if (index instanceof Integer) {
                return (Integer)index;
            }
        }
        catch (JavaAppException e) {
            RemoteLogger.error(e);
        }
        return -1;
    }

    public static Class<?> getItemType(Object widget) {
        for (Class<?> c : ITEM_GROUP_ITEM_TYPES) {
            if (!c.isInstance(widget)) continue;
            return c;
        }
        return null;
    }

    public synchronized Object getGroup() throws JavaAppException {
        if (this.group == null) {
            this.group = AutomatableItemGroupItem.uiSafeExecute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return Reflection.safeCall(AutomatableItemGroupItem.this.component, "getParent", new Object[0]);
                }
            });
        }
        return this.group;
    }

    @Override
    public String getName() {
        return AutomatableItemGroupItem.getXPathNodeNameFromClass(this.component.getClass());
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableItemGroupItem.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle bounds = Swt.convertBounds(Reflection.safeCall(AutomatableItemGroupItem.this.component, "getBounds", new Object[0]));
                return new Rectangle(0, 0, bounds.width, bounds.height);
            }
        });
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() {
        return new ArrayList<AutomatableSwtComponent>();
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableItemGroupItem.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "";
            }
        });
    }

    @Override
    public boolean isSelected() throws JavaAppException {
        return AutomatableItemGroupItem.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (AutomatableItemGroupItem.this.itemType == Swt.CTAB_ITEM_CLASS || AutomatableItemGroupItem.this.itemType == Swt.TAB_ITEM_CLASS) {
                    return Reflection.safeCall(AutomatableItemGroupItem.this.getGroup(), "getSelection", new Object[0]) == AutomatableItemGroupItem.this.component;
                }
                return false;
            }
        });
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableItemGroupItem.assertNotUIThread();
        super.getFocus();
        if (this.itemType == Swt.CTAB_ITEM_CLASS || this.itemType == Swt.TAB_ITEM_CLASS) {
            AutomatableItemGroupItem.uiSafeExecute(new Callable<Object>(){

                @Override
                public Object call() throws JavaAppException {
                    Reflection.safeCall(AutomatableItemGroupItem.this.getGroup(), "setSelection", AutomatableItemGroupItem.this.itemType, AutomatableItemGroupItem.this.component);
                    return null;
                }
            });
        } else if (this.itemType == Swt.MENU_ITEM_CLASS) {
            this.sendEvent(30);
        }
        this.sendEvent(13);
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableItemGroupItem.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("enabled")) {
                    Boolean enabled = (Boolean)Reflection.safeCall(AutomatableItemGroupItem.this.component, "getEnabled", new Object[0]);
                    return Boolean.toString(enabled != null ? enabled : true);
                }
                if (name.equals("selected")) {
                    Boolean enabled = (Boolean)Reflection.safeCall(AutomatableItemGroupItem.this.component, "getSelection", new Object[0]);
                    if (enabled == null) {
                        enabled = Reflection.safeCall(AutomatableItemGroupItem.this.getGroup(), "getSelection", new Object[0]) == AutomatableItemGroupItem.this.component;
                    }
                    return Boolean.toString(enabled != null ? enabled : false);
                }
                if (name.equals("text")) {
                    String text = (String)Reflection.safeCall(AutomatableItemGroupItem.this.component, "getText", new Object[0]);
                    if (text == null || text.trim().isEmpty()) {
                        text = (String)Reflection.safeCall(AutomatableItemGroupItem.this.component, "getToolTipText", new Object[0]);
                    }
                    return text != null ? text : "";
                }
                return AutomatableItemGroupItem.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public String[] getAttributeNames() {
        if (this.itemType == Swt.TAB_ITEM_CLASS || this.itemType == Swt.CTAB_ITEM_CLASS) {
            return XATTR_TABS;
        }
        return XATTR_BUTTONS;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

