/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Point;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableComboBoxEntry;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;

public class AutomatableComboBox
extends AutomatableSwtComponent {
    public AutomatableComboBox(Object comboBox, AutomatableSwtComponent parent) {
        super(comboBox, parent);
    }

    @Override
    protected AutomatableSwtComponent getChildFromItem(Object item, int itemIndex) {
        return new AutomatableComboBoxEntry(this.component, this, itemIndex);
    }

    @Override
    public AutomationTarget getClickEventTarget(Point offset) throws JavaAppException {
        return new AutomationTarget(this, offset.x, offset.y);
    }

    public AutomatableComboBoxEntry getComboxBoxEntry(int index) throws JavaAppException {
        if (index == -1) {
            return null;
        }
        return new AutomatableComboBoxEntry(this.component, this, index);
    }

    protected String getComboEntryText(final int index) throws JavaAppException {
        return AutomatableComboBox.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (index < 0) {
                    return null;
                }
                Object itemCount = Reflection.safeCall(AutomatableComboBox.this.component, "getItemCount", new Object[0]);
                if (itemCount instanceof Number && ((Number)itemCount).intValue() <= index) {
                    return null;
                }
                Object value = Reflection.safeCall(AutomatableComboBox.this.component, "getItem", Integer.TYPE, index);
                return value != null ? value.toString() : null;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableComboBox.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object callResult = Reflection.safeCall(AutomatableComboBox.this.component, "getSelectionIndex", new Object[0]);
                if (!(callResult instanceof Number)) {
                    return null;
                }
                int itemIndex = ((Number)callResult).intValue();
                String text = AutomatableComboBox.this.getComboEntryText(itemIndex);
                return text == null ? "" : text;
            }
        });
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

