/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableToolBarButton;

public class AutomatableToolBar
extends AutomatableAwtComponent<Component> {
    public AutomatableToolBar(Component toolBar, AutomatableAwtComponent<?> parent) {
        super(toolBar, parent);
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableToolBar.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableToolBar.super.getChildren();
                Object[] items = (Object[])Reflection.getPropertyWithReflection(AutomatableToolBar.this.component, "items", true, new Object[0]);
                for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
                    Object item = items[itemIndex];
                    if (!Reflection.instanceOfClass(item, "oracle.ewt.toolBar.ToolBarButton")) continue;
                    children.add(new AutomatableToolBarButton(AutomatableToolBar.this.component, AutomatableToolBar.this, item, itemIndex));
                }
                return children;
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableToolBar.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                try {
                    Object tabItem = Reflection.call(AutomatableToolBar.this.component, "getItemAt", Integer.TYPE, clickOffset.x, Integer.TYPE, clickOffset.y);
                    int index = AutomatableToolBar.this.getTabItemIndex(tabItem);
                    if (index != -1) {
                        AutomatableToolBarButton tab = new AutomatableToolBarButton(AutomatableToolBar.this.component, AutomatableToolBar.this, tabItem, index);
                        Rectangle tabBounds = tab.getComponentRelativeBounds();
                        return new AutomationTarget(tab, clickOffset.x - tabBounds.x, clickOffset.y - tabBounds.y);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return AutomatableToolBar.super.getClickEventTarget(clickOffset);
            }
        });
    }

    protected Class<?> getToolBarItemClass(Object toolbarItem) {
        for (Class<?> c = toolbarItem.getClass(); c != null; c = c.getSuperclass()) {
            if (c.getName() != "oracle.ewt.toolBar.ToolBarItem") continue;
            return c;
        }
        return null;
    }

    private int getTabItemIndex(Object toolbarItem) {
        int index = -1;
        try {
            if (toolbarItem != null) {
                index = (Integer)Reflection.call(this.component, "getItemIndex", this.getToolBarItemClass(toolbarItem), toolbarItem);
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
        return index;
    }

    protected Object getToolBarItemAtIndex(int index) {
        return Reflection.safeCall(this.component, "getItem", Integer.TYPE, index);
    }
}

