/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableTabBar;

public class AutomatableTabBarTab
extends AutomatableTabBar {
    public static final String XNODE_NAME = "Tab";
    private final int index;

    public AutomatableTabBarTab(Component tabBar, AutomatableAwtComponent<?> parent, int tabIndex) {
        super(tabBar, parent);
        this.index = tabIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTabBarTab.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle bounds = (Rectangle)Reflection.getPropertyWithReflection(AutomatableTabBarTab.this.getTabItemAtIndex(AutomatableTabBarTab.this.index), "bounds", true, null);
                if (bounds == null) {
                    bounds = AutomatableTabBarTab.this.component.getBounds();
                }
                return bounds;
            }
        });
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableTabBarTab.assertNotUIThread();
        this.getFocus();
        AutomatableTabBarTab.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Object tabItem = AutomatableTabBarTab.this.getTabItemAtIndex(AutomatableTabBarTab.this.index);
                    if (tabItem == null) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    Reflection.call(tabItem, "setSelected", Boolean.TYPE, true);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTabBarTab.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTabBarTab.this.index + 1);
                }
                try {
                    if (name.equals("background")) {
                        return AutomatableAwtComponent.colorToHex((Color)Reflection.getPropertyWithReflection(AutomatableTabBarTab.this.getTabItemAtIndex(AutomatableTabBarTab.this.index), "paintBackground", true, null));
                    }
                    if (name.equals("foreground")) {
                        return AutomatableAwtComponent.colorToHex((Color)Reflection.getPropertyWithReflection(AutomatableTabBarTab.this.getTabItemAtIndex(AutomatableTabBarTab.this.index), "paintForeground", true, null));
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return AutomatableTabBarTab.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTabBarTab.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return Reflection.getPropertyWithReflection(AutomatableTabBarTab.this.getTabItemAtIndex(AutomatableTabBarTab.this.index), "label", true, "");
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTabBarTab)) {
            return false;
        }
        return ((AutomatableTabBarTab)other).index == this.index;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

