/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableTabBarTab;

public class AutomatableTabBar
extends AutomatableAwtComponent<Component> {
    public AutomatableTabBar(Component tabBar, AutomatableAwtComponent<?> parent) {
        super(tabBar, parent);
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTabBar.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableTabBar.super.getChildren();
                int tabCount = (Integer)Reflection.getPropertyWithReflection(AutomatableTabBar.this.component, "itemCount", true, 0);
                for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
                    children.add(new AutomatableTabBarTab(AutomatableTabBar.this.component, AutomatableTabBar.this, tabIndex));
                }
                return children;
            }
        });
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTabBar.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Object tabItem = Reflection.getPropertyWithReflection(AutomatableTabBar.this.component, "selectedItem", true, null);
                int index = AutomatableTabBar.this.getTabItemIndex(tabItem);
                if (index != -1) {
                    return new AutomationTarget(new AutomatableTabBarTab(AutomatableTabBar.this.component, AutomatableTabBar.this, index));
                }
                return new AutomationTarget(AutomatableTabBar.this);
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTabBar.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                try {
                    Object tabItem = Reflection.call(AutomatableTabBar.this.component, "getItemAt", Integer.TYPE, clickOffset.x, Integer.TYPE, clickOffset.y);
                    int index = AutomatableTabBar.this.getTabItemIndex(tabItem);
                    if (index != -1) {
                        AutomatableTabBarTab tab = new AutomatableTabBarTab(AutomatableTabBar.this.component, AutomatableTabBar.this, index);
                        Rectangle tabBounds = tab.getComponentRelativeBounds();
                        return new AutomationTarget(tab, clickOffset.x - tabBounds.x, clickOffset.y - tabBounds.y);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return AutomatableTabBar.super.getClickEventTarget(clickOffset);
            }
        });
    }

    protected Class<?> getTabItemClass(Object tabItem) {
        for (Class<?> c = tabItem.getClass(); c != null; c = c.getSuperclass()) {
            if (c.getName() != "oracle.ewt.tabBar.TabBarItem") continue;
            return c;
        }
        return null;
    }

    private int getTabItemIndex(Object tabItem) {
        int index = -1;
        try {
            if (tabItem != null) {
                index = (Integer)Reflection.call(this.component, "getIndexOf", this.getTabItemClass(tabItem), tabItem);
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
        return index;
    }

    protected Object getTabItemAtIndex(int index) {
        return Reflection.safeCall(this.component, "getItem", Integer.TYPE, index);
    }
}

