/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListViewHeader;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListViewRow;

public class AutomatableListView
extends AutomatableAwtComponent<Component> {
    private static final String ROW_REFERENCE = "/Row";
    private static final String CELL_REFERENCE = "/Cell";
    private static final Pattern ROW_PATTERN = Pattern.compile("/Row\\[([0-9]+)\\]");
    private static ThreadLocal<Integer> maxRowCount = new ThreadLocal();

    public AutomatableListView(Component component, AutomatableAwtComponent<?> parent) {
        super(component, parent);
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableListView.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableListView.super.getChildren();
                if (AutomatableListView.this.hasVisibleHeader()) {
                    children.add(new AutomatableListViewHeader(AutomatableListView.this.component, (AutomatableAwtComponent<?>)AutomatableListView.this));
                }
                try {
                    int rowCount = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getRowCount", new Object[0]);
                    if (maxRowCount.get() != null) {
                        rowCount = Math.min(rowCount, (Integer)maxRowCount.get());
                    }
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        children.add(new AutomatableListViewRow(AutomatableListView.this.component, AutomatableListView.this, rowIndex));
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return children;
            }
        });
    }

    private boolean hasVisibleHeader() {
        if (Reflection.getPropertyWithReflection(this.component, "mHeaderDataSource", false, null) == null) {
            return false;
        }
        return (Boolean)Reflection.getPropertyWithReflection(this.component, "mHeaderVisible", false, null);
    }

    public static void optimiseForTarget(String target) {
        if (!target.contains(ROW_REFERENCE) && !target.contains(CELL_REFERENCE)) {
            maxRowCount.set(0);
        } else {
            Matcher rowMatcher = ROW_PATTERN.matcher(target);
            if (rowMatcher.find()) {
                int rowIndex = Integer.valueOf(rowMatcher.group(1));
                while (rowMatcher.find()) {
                    rowIndex = Math.max(rowIndex, Integer.valueOf(rowMatcher.group(1)));
                }
                maxRowCount.set(rowIndex);
            }
        }
    }

    public static void resetOptimisation() {
        maxRowCount.remove();
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ArrayList<List> results = new ArrayList<List>();
                if (AutomatableListView.this.hasVisibleHeader()) {
                    results.add((List)new AutomatableListViewHeader(AutomatableListView.this.component, (AutomatableAwtComponent<?>)AutomatableListView.this).getValue());
                } else {
                    results.add(new ArrayList());
                }
                int rowCount = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getRowCount", new Object[0]);
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    results.add((List)new AutomatableListViewRow(AutomatableListView.this.component, AutomatableListView.this, rowIndex).getValue());
                }
                return results;
            }
        });
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int selectedRow = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getSelectedRow", new Object[0]);
                if (selectedRow != -1) {
                    return new AutomationTarget(new AutomatableListViewRow(AutomatableListView.this.component, AutomatableListView.this, selectedRow));
                }
                return new AutomationTarget(AutomatableListView.this);
            }
        });
    }

    public Rectangle getRowBounds(final int rowIndex) throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Point canvasOrigin = (Point)Reflection.safeCall(AutomatableListView.this.component, "getCanvasOrigin", new Object[0]);
                Object scrollInsets = Reflection.safeCall(AutomatableListView.this.component, "getScrollInsets", new Object[0]);
                Rectangle innerBounds = (Rectangle)Reflection.safeCall(AutomatableListView.this.component, "getInnerBounds", new Object[0]);
                int scrollInsetsLeft = (Integer)Reflection.getPropertyWithReflection(scrollInsets, "left", false, null);
                int width = (Integer)Reflection.getPropertyWithReflection(AutomatableListView.this.component, "mRowWidth", false, null);
                int headerHeight = (Integer)Reflection.getPropertyWithReflection(scrollInsets, "top", false, null);
                int rowHeight = (Integer)Reflection.getPropertyWithReflection(AutomatableListView.this.component, "mRowHeight", false, null);
                int x = scrollInsetsLeft + innerBounds.x + canvasOrigin.x;
                if (rowIndex == -1) {
                    int y = innerBounds.y;
                    return new Rectangle(x, y, width, headerHeight);
                }
                int y = innerBounds.y + canvasOrigin.y + headerHeight + rowHeight * rowIndex;
                return new Rectangle(x, y, width, rowHeight);
            }
        });
    }

    public Rectangle getCellBounds(final int rowIndex, final int columnIndex) throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle rowBounds = AutomatableListView.this.getRowBounds(rowIndex);
                int columnCount = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getColumnCount", new Object[0]);
                if (columnCount <= columnIndex) {
                    return new Rectangle(0, 0, 0, 0);
                }
                int columnStart = 0;
                int columnWidth = 0;
                for (int i = 0; i <= columnIndex; ++i) {
                    if (i > 0) {
                        columnStart += columnWidth;
                    }
                    columnWidth = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getActualColumnWidth", Integer.TYPE, i);
                }
                return new Rectangle(rowBounds.x + columnStart, rowBounds.y, columnWidth, rowBounds.height);
            }
        });
    }

    private int getColumnIndexByClickOffset(final Point clickOffset) throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Point canvasOrigin = (Point)Reflection.safeCall(AutomatableListView.this.component, "getCanvasOrigin", new Object[0]);
                Object scrollInsets = Reflection.safeCall(AutomatableListView.this.component, "getScrollInsets", new Object[0]);
                Rectangle innerBounds = (Rectangle)Reflection.safeCall(AutomatableListView.this.component, "getInnerBounds", new Object[0]);
                int scrollInsetsLeft = (Integer)Reflection.getPropertyWithReflection(scrollInsets, "left", false, null);
                int x = clickOffset.x - scrollInsetsLeft - innerBounds.x - canvasOrigin.x;
                int columnCount = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getColumnCount", new Object[0]);
                int currentColumnStart = 0;
                for (int i = 0; i < columnCount; ++i) {
                    int currentColumnEnd = currentColumnStart + (Integer)Reflection.safeCall(AutomatableListView.this.component, "getActualColumnWidth", Integer.TYPE, i);
                    if (x < currentColumnEnd) {
                        return i;
                    }
                    currentColumnStart = currentColumnEnd;
                }
                return -1;
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableListView.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Rectangle innerBounds = (Rectangle)Reflection.safeCall(AutomatableListView.this.component, "getInnerBounds", new Object[0]);
                Object scrollInsets = Reflection.safeCall(AutomatableListView.this.component, "getScrollInsets", new Object[0]);
                Point canvasOrigin = (Point)Reflection.safeCall(AutomatableListView.this.component, "getCanvasOrigin", new Object[0]);
                int headerHeight = (Integer)Reflection.getPropertyWithReflection(scrollInsets, "top", false, null);
                int rowHeight = (Integer)Reflection.getPropertyWithReflection(AutomatableListView.this.component, "mRowHeight", false, null);
                int rowCount = (Integer)Reflection.safeCall(AutomatableListView.this.component, "getRowCount", new Object[0]);
                int column = AutomatableListView.this.getColumnIndexByClickOffset(clickOffset);
                int y = clickOffset.y - innerBounds.y;
                AutomatableAwtComponent target = null;
                if (y > 0) {
                    if (y < headerHeight) {
                        target = new AutomatableListViewHeader(AutomatableListView.this.component, (AutomatableAwtComponent<?>)AutomatableListView.this);
                        if (column != -1) {
                            target = ((AutomatableListViewHeader)target).getChild(column);
                        }
                    } else {
                        int row = ((y -= canvasOrigin.y) - headerHeight) / rowHeight;
                        if (row < rowCount) {
                            target = new AutomatableListViewRow(AutomatableListView.this.component, AutomatableListView.this, row);
                            if (column != -1) {
                                target = ((AutomatableListViewRow)target).getChild(column);
                            }
                        }
                    }
                }
                if (target != null) {
                    Rectangle targetBounds = target.getComponentRelativeBounds();
                    Point newOffset = new Point(clickOffset.x - targetBounds.x, clickOffset.y - targetBounds.y);
                    return new AutomationTarget(target, newOffset.x, newOffset.y);
                }
                return new AutomationTarget(AutomatableListView.this);
            }
        });
    }
}

