/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTree;

public class AutomatableTreeNode
extends AutomatableTree {
    public static final String XNODE_NAME = "Node";
    private final int index;
    private final Object nodeObject;
    private final AutomatableTree tree;

    public AutomatableTreeNode(final JTree component, AutomatableTree tree, final TreePath treePath) {
        super(component, (AutomatableAwtComponent<?>)null);
        this.tree = tree;
        this.nodeObject = treePath.getLastPathComponent();
        int index = 0;
        try {
            index = AutomatableTreeNode.uiSafeExecute(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return treePath.getPathCount() == 1 ? 0 : component.getModel().getIndexOfChild(treePath.getPathComponent(treePath.getPathCount() - 2), AutomatableTreeNode.this.nodeObject);
                }
            });
        }
        catch (JavaAppException e) {
            RemoteLogger.error(e);
        }
        this.index = index;
    }

    public AutomatableTreeNode(JTree component, AutomatableTree tree, Object nodeObject, int nodeIndex) {
        super(component, (AutomatableAwtComponent<?>)null);
        this.tree = tree;
        this.index = nodeIndex;
        this.nodeObject = nodeObject;
    }

    @Override
    public synchronized AutomatableAwtComponent<?> getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        TreePath treePath = this.getTreePath(this.nodeObject);
        if (treePath.getPathCount() <= 1) {
            this.parent = this.tree;
            return this.parent;
        }
        this.parent = new AutomatableTreeNode((JTree)this.component, this.tree, treePath.getParentPath());
        return this.parent;
    }

    private static LinkedList<Object> findNodePath(TreeModel model, Object currentNode, Object targetNode) {
        int childCount = model.getChildCount(currentNode);
        if (currentNode == targetNode) {
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(targetNode);
            return result;
        }
        for (int i = 0; i < childCount; ++i) {
            LinkedList<Object> branchResult = AutomatableTreeNode.findNodePath(model, model.getChild(currentNode, i), targetNode);
            if (branchResult == null) continue;
            branchResult.add(0, currentNode);
            return branchResult;
        }
        return null;
    }

    private TreePath getTreePath(Object nodeObject) {
        LinkedList<Object> path = new LinkedList<TreeNode>();
        if (nodeObject instanceof TreeNode) {
            for (TreeNode currentNode = (TreeNode)nodeObject; currentNode != null; currentNode = currentNode.getParent()) {
                path.add(0, currentNode);
            }
        } else {
            TreeModel model = ((JTree)this.component).getModel();
            path = AutomatableTreeNode.findNodePath(model, model.getRoot(), nodeObject);
        }
        return path == null ? null : new TreePath(path.toArray(new Object[path.size()]));
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTreeNode.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                ArrayList children = new ArrayList();
                TreeModel model = ((JTree)AutomatableTreeNode.this.component).getModel();
                int childCount = model.getChildCount(AutomatableTreeNode.this.nodeObject);
                for (int i = 0; i < childCount; ++i) {
                    Object childObject = model.getChild(AutomatableTreeNode.this.nodeObject, i);
                    TreePath componentPath = AutomatableTreeNode.this.getTreePath(childObject);
                    if (componentPath == null || !((JTree)AutomatableTreeNode.this.component).isVisible(componentPath)) continue;
                    children.add(new AutomatableTreeNode((JTree)AutomatableTreeNode.this.component, AutomatableTreeNode.this.tree, childObject, i));
                }
                TreeCellRenderer renderer = ((JTree)AutomatableTreeNode.this.component).getCellRenderer();
                if (renderer == null || renderer.getClass() == DefaultTreeCellRenderer.class) {
                    return children;
                }
                Component childComponent = AutomatableTreeNode.this.getCellComponent();
                if (childComponent == null || childComponent.getClass().equals(DefaultTreeCellRenderer.class)) {
                    return children;
                }
                children.add(AutomatableAwtComponent.automatableFromComponent(childComponent, AutomatableTreeNode.this));
                return children;
            }
        });
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return ((JTree)AutomatableTreeNode.this.component).getPathBounds(AutomatableTreeNode.this.getTreePath(AutomatableTreeNode.this.nodeObject));
            }
        });
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                int rowIndex = ((JTree)AutomatableTreeNode.this.component).getRowForPath(AutomatableTreeNode.this.getTreePath(AutomatableTreeNode.this.nodeObject));
                if (replace) {
                    ((JTree)AutomatableTreeNode.this.component).setSelectionRow(rowIndex);
                } else {
                    int[] currentSelection = ((JTree)AutomatableTreeNode.this.component).getSelectionRows();
                    int[] newSelection = new int[currentSelection.length + 1];
                    System.arraycopy(currentSelection, 0, newSelection, 0, currentSelection.length);
                    newSelection[currentSelection.length] = rowIndex;
                    ((JTree)AutomatableTreeNode.this.component).setSelectionRows(newSelection);
                }
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    private Component getCellComponent() {
        try {
            TreeCellRenderer cellRenderer = ((JTree)this.component).getCellRenderer();
            TreePath treePath = this.getTreePath(this.nodeObject);
            boolean selected = ((JTree)this.component).isPathSelected(treePath);
            boolean hasFocus = selected && ((JTree)this.component).hasFocus();
            boolean expanded = ((JTree)this.component).isExpanded(treePath);
            int rowIndex = ((JTree)this.component).getRowForPath(treePath);
            boolean leaf = ((JTree)this.component).getModel().isLeaf(this.nodeObject);
            return cellRenderer.getTreeCellRendererComponent((JTree)this.component, this.nodeObject, selected, expanded, leaf, rowIndex, hasFocus);
        }
        catch (Exception e) {
            RemoteLogger.error(e);
            return null;
        }
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTreeNode.this.index + 1);
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableTreeNode.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableTreeNode.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableTreeNode.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableTreeNode.this.getWindowRelativeBounds().height);
                }
                if (name.equals("background")) {
                    Component cellComponent = AutomatableTreeNode.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTreeNode.this.component).getBackground());
                }
                if (name.equals("foreground")) {
                    Component cellComponent = AutomatableTreeNode.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTreeNode.this.component).getForeground());
                }
                return "";
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTreeNode.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AutomatableTreeNode.this.nodeObject.toString();
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTreeNode)) {
            return false;
        }
        return ((AutomatableTreeNode)other).nodeObject == this.nodeObject && ((AutomatableTreeNode)other).index == this.index;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

