/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;

public class AutomatableTableHeaderCell
extends AutomatableAwtComponent<JTableHeader> {
    public static final String XNODE_NAME = "Header";
    private final int columnIndex;

    public AutomatableTableHeaderCell(JTableHeader tableHeader, AutomatableAwtComponent<?> parent, int columnIndex) {
        super(tableHeader, parent);
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                int x = 0;
                TableColumnModel columnModel = ((JTableHeader)AutomatableTableHeaderCell.this.component).getColumnModel();
                for (int i = 0; i < AutomatableTableHeaderCell.this.columnIndex; ++i) {
                    x += columnModel.getColumn(i).getWidth();
                }
                int width = columnModel.getColumn(AutomatableTableHeaderCell.this.columnIndex).getWidth();
                int height = ((JTableHeader)AutomatableTableHeaderCell.this.component).getHeight();
                return new Rectangle(x, 0, width, height);
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    private Component getCellComponent() {
        try {
            TableCellRenderer cellRenderer = ((JTableHeader)this.component).getColumnModel().getColumn(this.columnIndex).getHeaderRenderer();
            boolean isSelected = Arrays.asList(new int[][]{((JTableHeader)this.component).getColumnModel().getSelectedColumns()}).contains(this.columnIndex);
            boolean cellHasFocus = isSelected && ((JTableHeader)this.component).hasFocus();
            Object value = ((JTableHeader)this.component).getColumnModel().getColumn(this.columnIndex).getHeaderValue();
            if (cellRenderer != null) {
                return cellRenderer.getTableCellRendererComponent(((JTableHeader)this.component).getTable(), value, isSelected, cellHasFocus, 0, this.columnIndex);
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
        return null;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.columnIndex + 1);
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableTableHeaderCell.this.getWindowRelativeBounds().height);
                }
                if (name.equals("background")) {
                    Component cellComponent = AutomatableTableHeaderCell.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTableHeaderCell.this.component).getBackground());
                }
                if (name.equals("foreground")) {
                    Component cellComponent = AutomatableTableHeaderCell.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTableHeaderCell.this.component).getForeground());
                }
                return "";
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableHeaderCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object value = ((JTableHeader)AutomatableTableHeaderCell.this.component).getColumnModel().getColumn(AutomatableTableHeaderCell.this.columnIndex).getHeaderValue();
                return value != null ? value.toString() : null;
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableHeaderCell)) {
            return false;
        }
        return ((AutomatableTableHeaderCell)other).columnIndex == this.columnIndex;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

