/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;

public class AutomatableTableCell
extends AutomatableAwtComponent<JTable> {
    public static final String XNODE_NAME = "Cell";
    private final int rowIndex;
    private final int columnIndex;

    public AutomatableTableCell(JTable table, AutomatableAwtComponent<?> parent, int rowIndex, int columnIndex) {
        super(table, parent);
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                try {
                    return ((JTable)AutomatableTableCell.this.component).getCellRect(AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex, false);
                }
                catch (Exception e) {
                    RemoteLogger.warning(e);
                    return new Rectangle(0, 0, 0, 0);
                }
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    private Component getCellComponent() {
        try {
            TableCellRenderer cellRenderer = ((JTable)this.component).getCellRenderer(this.rowIndex, this.columnIndex);
            boolean isSelected = ((JTable)this.component).isCellSelected(this.rowIndex, this.columnIndex);
            boolean cellHasFocus = isSelected && ((JTable)this.component).hasFocus();
            Object value = ((JTable)this.component).getModel().getValueAt(this.rowIndex, this.columnIndex);
            return cellRenderer.getTableCellRendererComponent((JTable)this.component, value, isSelected, cellHasFocus, this.rowIndex, this.columnIndex);
        }
        catch (Exception e) {
            RemoteLogger.error(e);
            return null;
        }
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (name.equals("index")) {
                        return Integer.toString(AutomatableTableCell.this.columnIndex + 1);
                    }
                    if (name.equals("x")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().x);
                    }
                    if (name.equals("y")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().y);
                    }
                    if (name.equals("width")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().width);
                    }
                    if (name.equals("height")) {
                        return Integer.toString(AutomatableTableCell.this.getWindowRelativeBounds().height);
                    }
                    if (name.equals("background")) {
                        Component cellComponent = AutomatableTableCell.this.getCellComponent();
                        return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTableCell.this.component).getBackground());
                    }
                    if (name.equals("foreground")) {
                        Component cellComponent = AutomatableTableCell.this.getCellComponent();
                        return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableTableCell.this.component).getForeground());
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return "";
            }
        });
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableTableCell.uiSafeExecute(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() {
                if (((JTable)AutomatableTableCell.this.component).editCellAt(AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex)) {
                    TableCellEditor editor = ((JTable)AutomatableTableCell.this.component).getCellEditor();
                    try {
                        String oldText;
                        JTextComponent editorTextComponent = AutomatableTableCell.this.getEditorTextComponent();
                        if (editorTextComponent == null) {
                            throw new UnsupportedOperationException();
                        }
                        String newText = text;
                        if (append && (oldText = editorTextComponent.getText()) != null && !oldText.toString().isEmpty()) {
                            newText = oldText.toString() + text;
                        }
                        editorTextComponent.setText(newText);
                    }
                    finally {
                        editor.stopCellEditing();
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                return null;
            }
        });
    }

    private JTextComponent getEditorTextComponent() {
        if (((JTable)this.component).getEditingColumn() == this.columnIndex && ((JTable)this.component).getEditingRow() == this.rowIndex) {
            Component firstChild;
            Component editorComponent = ((JTable)this.component).getEditorComponent();
            if (editorComponent instanceof JTextComponent) {
                return (JTextComponent)editorComponent;
            }
            if (editorComponent instanceof JPanel && ((JPanel)editorComponent).getComponentCount() == 1 && (firstChild = ((JPanel)editorComponent).getComponent(0)) instanceof JTextComponent) {
                return (JTextComponent)firstChild;
            }
        }
        return null;
    }

    private List<Component> getTextComponents(Component parentComponent) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (parentComponent instanceof JTextComponent || parentComponent instanceof TextComponent || parentComponent instanceof JLabel) {
            result.add(parentComponent);
        }
        if (parentComponent instanceof Container) {
            for (Component childComponent : ((Container)parentComponent).getComponents()) {
                result.addAll(this.getTextComponents(childComponent));
            }
        }
        return result;
    }

    private String getTextFromTextComponents(List<Component> textComponents) {
        StringBuilder result = new StringBuilder();
        for (Component textComponent : textComponents) {
            String componentText = "";
            if (textComponent instanceof JTextComponent) {
                componentText = ((JTextComponent)textComponent).getText();
            } else if (textComponent instanceof TextComponent) {
                componentText = ((TextComponent)textComponent).getText();
            } else if (textComponent instanceof JLabel) {
                componentText = ((JLabel)textComponent).getText();
            }
            if (componentText.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(System.getProperty("line.separator", "\n"));
            }
            result.append(componentText);
        }
        return result.toString();
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object value = null;
                try {
                    JTextComponent editorTextComponent;
                    if (((JTable)AutomatableTableCell.this.component).getEditingColumn() == AutomatableTableCell.this.columnIndex && ((JTable)AutomatableTableCell.this.component).getEditingRow() == AutomatableTableCell.this.rowIndex && (editorTextComponent = AutomatableTableCell.this.getEditorTextComponent()) != null) {
                        return editorTextComponent.getText();
                    }
                    value = ((JTable)AutomatableTableCell.this.component).getValueAt(AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex);
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                if (value == null) {
                    return null;
                }
                String valueString = value.toString();
                if (value instanceof String || value instanceof Number) {
                    return valueString;
                }
                Class<?> valueClass = value.getClass();
                if (valueClass.isPrimitive()) {
                    return valueString;
                }
                try {
                    List textComponents;
                    TableCellRenderer cellRenderer = ((JTable)AutomatableTableCell.this.component).getCellRenderer(AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex);
                    Component rendererComponent = null;
                    if (cellRenderer != null) {
                        rendererComponent = cellRenderer.getTableCellRendererComponent((JTable)AutomatableTableCell.this.component, value, false, false, AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex);
                    }
                    if ((textComponents = AutomatableTableCell.this.getTextComponents(rendererComponent)).size() == 1 || valueString.equals(valueClass.getName() + "@" + Integer.toHexString(value.hashCode()))) {
                        return AutomatableTableCell.this.getTextFromTextComponents(textComponents);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return value.toString();
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableCell)) {
            return false;
        }
        return ((AutomatableTableCell)other).rowIndex == this.rowIndex && ((AutomatableTableCell)other).columnIndex == this.columnIndex;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return AutomatableTableCell.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                JTextComponent editorComponent = AutomatableTableCell.this.getEditorTextComponent();
                if (editorComponent == null) {
                    return false;
                }
                if (editorComponent.getClass().getSimpleName().toString().equals("JfcFastInputCell") && !new Integer(0).equals(Reflection.callNestedMethod(editorComponent, "getJfcFastInputField", "getJfcFastInputList", "getOriginalSize"))) {
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public void getFocus() throws JavaAppException {
        Component componentToFocus;
        AutomatableTableCell.assertNotUIThread();
        boolean click = AutomatableTableCell.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (((JTable)AutomatableTableCell.this.component).getEditingColumn() != AutomatableTableCell.this.columnIndex || ((JTable)AutomatableTableCell.this.component).getEditingRow() != AutomatableTableCell.this.rowIndex) {
                    try {
                        if (!((JTable)AutomatableTableCell.this.component).editCellAt(AutomatableTableCell.this.rowIndex, AutomatableTableCell.this.columnIndex)) {
                            ((JTable)AutomatableTableCell.this.component).setEditingRow(AutomatableTableCell.this.rowIndex);
                            ((JTable)AutomatableTableCell.this.component).setEditingColumn(AutomatableTableCell.this.columnIndex);
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.warning(e);
                    }
                    return true;
                }
                return false;
            }
        });
        if (click) {
            this.click(AutomatableClick.LEFT, 0, 0, false, false, false, null);
        }
        if ((componentToFocus = AutomatableTableCell.uiSafeExecute(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                if (!((JTable)AutomatableTableCell.this.component).hasFocus()) {
                    Component focusComponent = ((JTable)AutomatableTableCell.this.component).getEditorComponent();
                    if (focusComponent == null) {
                        focusComponent = AutomatableTableCell.this.component;
                    }
                    return focusComponent;
                }
                return null;
            }
        })) != null) {
            AutomatableTableCell.getComponentFocus(componentToFocus);
        }
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

