/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JTabbedPane;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTabbedPane;

public class AutomatableTab
extends AutomatableTabbedPane {
    public static final String XNODE_NAME = "Tab";
    private final int index;

    public AutomatableTab(JTabbedPane tabbedPane, AutomatableAwtComponent<?> parent, int tabIndex) {
        super(tabbedPane, parent);
        this.index = tabIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTab.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return ((JTabbedPane)AutomatableTab.this.component).getBoundsAt(AutomatableTab.this.index);
            }
        });
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableTab.assertNotUIThread();
        this.getFocus();
        AutomatableTab.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                ((JTabbedPane)AutomatableTab.this.component).setSelectedIndex(AutomatableTab.this.index);
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTab.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTab.this.index + 1);
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableTab.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableTab.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableTab.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableTab.this.getWindowRelativeBounds().height);
                }
                try {
                    if (name.equals("background")) {
                        return AutomatableAwtComponent.colorToHex(((JTabbedPane)AutomatableTab.this.component).getBackgroundAt(AutomatableTab.this.index));
                    }
                    if (name.equals("foreground")) {
                        return AutomatableAwtComponent.colorToHex(((JTabbedPane)AutomatableTab.this.component).getForegroundAt(AutomatableTab.this.index));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    RemoteLogger.error(e);
                }
                return "";
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTab.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((JTabbedPane)AutomatableTab.this.component).getTitleAt(AutomatableTab.this.index);
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTab)) {
            return false;
        }
        return ((AutomatableTab)other).index == this.index;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

