/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableList;

public class AutomatableListEntry
extends AutomatableList {
    public static final String XNODE_NAME = "Entry";
    private final int index;

    public AutomatableListEntry(JList jList, AutomatableAwtComponent<?> parent, int listIndex) {
        super(jList, parent);
        this.index = listIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableListEntry.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return ((JList)AutomatableListEntry.this.component).getCellBounds(AutomatableListEntry.this.index, AutomatableListEntry.this.index);
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public void getFocus() throws JavaAppException {
        AutomatableListEntry.assertNotUIThread();
        AutomatableListEntry.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                ((JList)AutomatableListEntry.this.component).ensureIndexIsVisible(AutomatableListEntry.this.index);
                return null;
            }
        });
        super.getFocus();
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableListEntry.assertNotUIThread();
        this.getFocus();
        boolean componentSelected = AutomatableListEntry.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (replace) {
                    ((JList)AutomatableListEntry.this.component).clearSelection();
                }
                return ((JList)AutomatableListEntry.this.component).isSelectedIndex(AutomatableListEntry.this.index);
            }
        });
        if (!componentSelected) {
            this.click(AutomatableClick.LEFT, 0, 0, false, false, true, null);
        }
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    private Component getCellComponent() {
        try {
            ListCellRenderer cellRenderer = ((JList)this.component).getCellRenderer();
            boolean isSelected = ((JList)this.component).getSelectedIndex() == this.index;
            boolean cellHasFocus = isSelected && ((JList)this.component).hasFocus();
            Object value = ((JList)this.component).getModel().getElementAt(this.index);
            return cellRenderer.getListCellRendererComponent((JList)this.component, value, this.index, isSelected, cellHasFocus);
        }
        catch (Exception e) {
            RemoteLogger.error(e);
            return null;
        }
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        if (name.equals("index")) {
            return Integer.toString(this.index + 1);
        }
        return AutomatableListEntry.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("background")) {
                    Component cellComponent = AutomatableListEntry.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableListEntry.this.component).getBackground());
                }
                if (name.equals("foreground")) {
                    Component cellComponent = AutomatableListEntry.this.getCellComponent();
                    return AutomatableAwtComponent.colorToHex((cellComponent != null ? cellComponent : AutomatableListEntry.this.component).getForeground());
                }
                return AutomatableListEntry.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableListEntry.assertNotUIThread();
        this.getFocus();
        AutomatableListEntry.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    String newText;
                    DefaultListModel listModel;
                    if (((JList)AutomatableListEntry.this.component).getModel() instanceof DefaultListModel) {
                        Object oldText;
                        listModel = (DefaultListModel)((JList)AutomatableListEntry.this.component).getModel();
                        newText = text;
                        if (append && (oldText = listModel.getElementAt(AutomatableListEntry.this.index)) != null && !oldText.toString().isEmpty()) {
                            newText = oldText.toString() + text;
                        }
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    listModel.setElementAt(newText, AutomatableListEntry.this.index);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException();
                }
                return null;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableListEntry.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object value = ((JList)AutomatableListEntry.this.component).getModel().getElementAt(AutomatableListEntry.this.index);
                return value != null ? value.toString() : null;
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableListEntry)) {
            return false;
        }
        return ((AutomatableListEntry)other).index == this.index;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

