/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableComboBox;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableList;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableProgressBar;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTabbedPane;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableHeader;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTextComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTree;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtAutomatableKey;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableDrawnPanel;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableLWCheckbox;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableLWDataSourceListContent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableLWLabel;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableLWMenuItem;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableLWRadioButtonMenuItem;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListView;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatablePushButton;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableStatusBar;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableTabBar;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableToolBar;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableVTextField;

public class AutomatableAwtComponent<T extends Component>
extends Automatable {
    private static final Class<?>[] STATIC_TEXT_CONTROL_TYPES = new Class[]{JLabel.class, Label.class, AbstractButton.class};
    protected final T component;
    protected AutomatableAwtComponent<?> parent;

    public AutomatableAwtComponent(T component, AutomatableAwtComponent<?> parent) {
        this.component = component;
        this.parent = parent;
    }

    @Override
    public synchronized AutomatableAwtComponent<?> getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        Container componentParent = ((Component)this.component).getParent();
        if (componentParent == null) {
            return null;
        }
        this.parent = AutomatableAwtComponent.automatableFromComponent(componentParent, null);
        return this.parent;
    }

    @Override
    public boolean isVirtualComponent() {
        AutomatableAwtComponent<?> rootAutomtable = AutomatableAwtComponent.automatableFromComponent(this.component, null);
        return !this.getClass().equals(rootAutomtable.getClass());
    }

    protected static void assertNotUIThread() {
        UiThreadJobManager.assertNotUIThread();
    }

    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableAwtComponent.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                ArrayList children = new ArrayList();
                if (AutomatableAwtComponent.this.component instanceof Container) {
                    for (Component child : ((Container)AutomatableAwtComponent.this.component).getComponents()) {
                        if (child == null || !child.isVisible()) continue;
                        children.add(AutomatableAwtComponent.automatableFromComponent(child, AutomatableAwtComponent.this));
                    }
                }
                if (AutomatableAwtComponent.this.component instanceof JMenu) {
                    for (Component child : ((JMenu)AutomatableAwtComponent.this.component).getMenuComponents()) {
                        if (child == null || !child.isVisible() || !child.getParent().isVisible()) continue;
                        children.add(AutomatableAwtComponent.automatableFromComponent(child, AutomatableAwtComponent.this));
                    }
                }
                return children;
            }
        });
    }

    @Override
    protected boolean hasTextAttribute() {
        for (Class<?> type : STATIC_TEXT_CONTROL_TYPES) {
            if (!type.isAssignableFrom(this.component.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getAttributeNames() {
        if (this.component instanceof AbstractButton) {
            return XATTR_BUTTONS;
        }
        if (this.hasTextAttribute()) {
            return XATTR_TEXT_CONTROLS;
        }
        if (this.component instanceof JInternalFrame || this.component instanceof Frame || this.component instanceof Dialog) {
            return XATTR_FRAMES;
        }
        return XATTR_NAME_POSITION_SIZE;
    }

    public static String colorToHex(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        if (!this.hasAttribute(name)) {
            return "";
        }
        return AutomatableAwtComponent.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("name")) {
                    return NameCheck.isNameSystemGenerated(AutomatableAwtComponent.this.component) || ((Component)AutomatableAwtComponent.this.component).getName() == null ? "" : ((Component)AutomatableAwtComponent.this.component).getName();
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableAwtComponent.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableAwtComponent.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableAwtComponent.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableAwtComponent.this.getWindowRelativeBounds().height);
                }
                if (name.equals("enabled")) {
                    return Boolean.toString(((Component)AutomatableAwtComponent.this.component).isEnabled());
                }
                if (name.equals("background")) {
                    return AutomatableAwtComponent.colorToHex(((Component)AutomatableAwtComponent.this.component).getBackground());
                }
                if (name.equals("foreground")) {
                    return AutomatableAwtComponent.colorToHex(((Component)AutomatableAwtComponent.this.component).getForeground());
                }
                String value = "";
                if (name.equals("text")) {
                    if (AutomatableAwtComponent.this.component instanceof AbstractButton) {
                        value = ((AbstractButton)AutomatableAwtComponent.this.component).getText();
                        if (value == null || value.isEmpty()) {
                            value = ((AbstractButton)AutomatableAwtComponent.this.component).getToolTipText();
                        }
                    } else if (AutomatableAwtComponent.this.component instanceof JLabel) {
                        value = ((JLabel)AutomatableAwtComponent.this.component).getText();
                        if (value == null || value.isEmpty()) {
                            value = ((JLabel)AutomatableAwtComponent.this.component).getToolTipText();
                        }
                    } else if (AutomatableAwtComponent.this.component instanceof Label) {
                        value = ((Label)AutomatableAwtComponent.this.component).getText();
                    }
                } else if (name.equals("title")) {
                    if (AutomatableAwtComponent.this.component instanceof JInternalFrame) {
                        value = ((JInternalFrame)AutomatableAwtComponent.this.component).getTitle();
                    } else if (AutomatableAwtComponent.this.component instanceof Frame) {
                        value = ((Frame)AutomatableAwtComponent.this.component).getTitle();
                    } else if (AutomatableAwtComponent.this.component instanceof Dialog) {
                        value = ((Dialog)AutomatableAwtComponent.this.component).getTitle();
                    }
                } else if (name.equals("selected") && AutomatableAwtComponent.this.component instanceof AbstractButton) {
                    value = Boolean.toString(((AbstractButton)AutomatableAwtComponent.this.component).isSelected());
                }
                return value != null ? value : "";
            }
        });
    }

    @Override
    public void setSize(int width, int height) throws JavaAppException {
        ((Component)this.getComponent()).setSize(width, height);
    }

    @Override
    public void setLocation(int x, int y) throws JavaAppException {
        Object component;
        if (x == 32 && (component = this.getComponent()) instanceof Frame) {
            Reflection.setPropertyWithReflection(component, "undecorated", false, true);
            Frame window = (Frame)component;
            try {
                window.setOpacity(1.0E-4f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((Component)this.getComponent()).setLocation(x, y);
    }

    @Override
    public void maximise() throws JavaAppException {
        if (!(this.getComponent() instanceof Frame)) {
            throw new UnsupportedOperationException();
        }
        Frame frame = (Frame)this.getComponent();
        frame.setExtendedState(frame.getExtendedState() | 6);
    }

    public T getComponent() {
        return this.component;
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                return new Rectangle(0, 0, ((Component)AutomatableAwtComponent.this.component).getWidth(), ((Component)AutomatableAwtComponent.this.component).getHeight());
            }
        });
    }

    @Override
    public Rectangle getParentRelativeBounds() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Component commonRootComponent;
                Automatable parent = AutomatableAwtComponent.this.getParent();
                Rectangle bounds = AutomatableAwtComponent.this.getComponentRelativeBounds();
                if (parent != null && ((AutomatableAwtComponent)parent).getComponent() == AutomatableAwtComponent.this.component) {
                    Rectangle parentComponentRelativeBounds = ((AutomatableAwtComponent)parent).getComponentRelativeBounds();
                    bounds.x -= parentComponentRelativeBounds.x;
                    bounds.y -= parentComponentRelativeBounds.y;
                    return bounds;
                }
                Component component = commonRootComponent = parent != null ? AutomatableAwtComponent.getCommonRootComponent((Component)((AutomatableAwtComponent)parent).getComponent(), AutomatableAwtComponent.this.component) : null;
                if (commonRootComponent == null) {
                    Rectangle componentWindowRelativeBounds = AutomatableAwtComponent.getRelativeBounds(null, AutomatableAwtComponent.this.component);
                    bounds.x += componentWindowRelativeBounds.x;
                    bounds.y += componentWindowRelativeBounds.y;
                    return bounds;
                }
                Rectangle parentComponentCommonBounds = AutomatableAwtComponent.getRelativeBounds(commonRootComponent, (Component)((AutomatableAwtComponent)parent).getComponent());
                Rectangle componentCommonBounds = AutomatableAwtComponent.getRelativeBounds(commonRootComponent, AutomatableAwtComponent.this.component);
                bounds.x += componentCommonBounds.x - parentComponentCommonBounds.x;
                bounds.y += componentCommonBounds.y - parentComponentCommonBounds.y;
                return bounds;
            }
        });
    }

    private static Rectangle getRelativeBounds(Component parent, Component child) {
        Rectangle bounds = new Rectangle(0, 0, child.getWidth(), child.getHeight());
        for (Component current = child; current != parent && current != null; current = current.getParent()) {
            Rectangle currentBounds = current.getBounds();
            bounds.x += currentBounds.x;
            bounds.y += currentBounds.y;
        }
        return bounds;
    }

    public static Component getRootComponent(Component component) {
        while (component.getParent() != null) {
            component = component.getParent();
        }
        return component;
    }

    private static Component getCommonRootComponent(Component parent, Component child) {
        for (Component rootCandidate = parent; rootCandidate != null; rootCandidate = rootCandidate.getParent()) {
            for (Component childAncestor = child; childAncestor != null; childAncestor = childAncestor.getParent()) {
                if (childAncestor != rootCandidate) continue;
                return rootCandidate;
            }
        }
        return null;
    }

    @Override
    public Rectangle getWindowRelativeBounds() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle bounds = AutomatableAwtComponent.this.getParentRelativeBounds();
                for (Automatable current = AutomatableAwtComponent.this.getParent(); current != null; current = ((AutomatableAwtComponent)current).getParent()) {
                    Rectangle currentBounds = ((AutomatableAwtComponent)current).getParentRelativeBounds();
                    bounds.x = (int)((double)bounds.x + currentBounds.getX());
                    bounds.y = (int)((double)bounds.y + currentBounds.getY());
                }
                return bounds;
            }
        });
    }

    protected static void getComponentFocus(final Component component) throws JavaAppException {
        AutomatableAwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                component.requestFocus();
                return null;
            }
        });
        EventQueue queue = AwtTools.getApplicationEventQueue(component);
        queue.postEvent(new FocusEvent(component, 1004));
    }

    @Override
    public void getFocus() throws JavaAppException {
        AutomatableAwtComponent.assertNotUIThread();
        AutomatableAwtComponent.getComponentFocus(this.component);
    }

    @Override
    public void transferFocus() throws JavaAppException {
        AutomatableAwtComponent.assertNotUIThread();
        AutomatableAwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                ((Component)AutomatableAwtComponent.this.component).transferFocusUpCycle();
                return null;
            }
        });
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableAwtComponent.assertNotUIThread();
        this.getFocus();
        this.click(AutomatableClick.LEFT, 0, 0, false, false, false, null);
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return AutomatableAwtComponent.super.getValue();
                }
                catch (JavaAppException e) {
                    if (e.getExceptionClassDisplayName().equals(UnsupportedOperationException.class.getSimpleName())) {
                        try {
                            if (Reflection.instanceOf(AutomatableAwtComponent.this.component, false, "murex.ui.components.fields.RoundCounter")) {
                                return Reflection.getPropertyWithReflection(AutomatableAwtComponent.this.component, "leftText", false, "") + " " + Reflection.getPropertyWithReflection(AutomatableAwtComponent.this.component, "rightText", false, "");
                            }
                        }
                        catch (Exception e1) {
                            RemoteLogger.error(e1);
                        }
                    } else {
                        throw e;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        });
    }

    @Override
    public boolean hasStringValue() {
        String className;
        boolean hasStringValue = super.hasStringValue();
        if (!hasStringValue && "murex.ui.components.fields.RoundCounter".equals(className = this.component.getClass().getCanonicalName())) {
            hasStringValue = true;
        }
        return hasStringValue;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    for (Class type : STATIC_TEXT_CONTROL_TYPES) {
                        if (!type.isAssignableFrom(AutomatableAwtComponent.this.component.getClass())) continue;
                        return false;
                    }
                    try {
                        return (Boolean)Reflection.call(AutomatableAwtComponent.this.component, "isEditable", new Object[0]);
                    }
                    catch (Exception e) {
                        RemoteLogger.debug(e);
                        AutomatableAwtComponent.this.component.getClass().getMethod("setText", String.class);
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    public boolean isVisible() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object currentComponent = AutomatableAwtComponent.this.component;
                while (currentComponent != null) {
                    if (!((Component)currentComponent).isVisible()) {
                        return false;
                    }
                    currentComponent = ((Component)currentComponent).getParent() != currentComponent ? ((Component)currentComponent).getParent() : null;
                }
                return true;
            }
        });
    }

    @Override
    public boolean isPasswordField() throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return AutomatableAwtComponent.this.component instanceof JPasswordField || AutomatableAwtComponent.this.getName().toLowerCase().contains("password");
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                    return false;
                }
            }
        });
    }

    private static void sendMouseEvent(Component component, int button, int modifiers, int action, int clickCount, int x, int y, boolean popupTrigger, AtomicBoolean clickSentConfirmation) throws InterruptedException {
        MouseEvent event = new MouseEvent(component, action, System.currentTimeMillis(), modifiers, x, y, clickCount, popupTrigger, button);
        AutomatableAwtComponent.sendEvent(event, component, clickSentConfirmation);
    }

    @Override
    public void click(AutomatableClick clickType, int x, int y, boolean shift, boolean alt, boolean ctrl, AtomicBoolean clickSentConfirmation) throws JavaAppException {
        AutomatableAwtComponent.assertNotUIThread();
        Rectangle bounds = this.getComponentRelativeBounds();
        x = Math.max(Math.min(x, bounds.width - 1), 0);
        y = Math.max(Math.min(y, bounds.height - 1), 0);
        x += (int)bounds.getX();
        y += (int)bounds.getY();
        int clickCount = 0;
        int mouseButton = 0;
        int buttonMask = 0;
        int buttonDownMask = 0;
        boolean popupTrigger = false;
        if (clickType == AutomatableClick.LEFT) {
            mouseButton = 1;
            buttonMask = 16;
            buttonDownMask = 1024;
            clickCount = 1;
        } else if (clickType == AutomatableClick.DOUBLE_CLICK) {
            mouseButton = 1;
            buttonMask = 16;
            buttonDownMask = 1024;
            clickCount = 2;
        } else if (clickType == AutomatableClick.MIDDLE) {
            mouseButton = 2;
            buttonMask = 8;
            buttonDownMask = 2048;
            clickCount = 1;
        } else if (clickType == AutomatableClick.RIGHT) {
            mouseButton = 3;
            buttonMask = 4;
            buttonDownMask = 4096;
            popupTrigger = true;
            clickCount = 1;
        }
        int modifiers = 0;
        if (shift) {
            modifiers |= 0x41;
        }
        if (alt) {
            modifiers |= 0x208;
        }
        if (ctrl) {
            modifiers |= 0x82;
        }
        try {
            AutomatableAwtComponent.sendMouseEvent(this.component, 0, modifiers, 503, 0, x, y, false, null);
            AutomatableAwtComponent.sendMouseEvent(this.component, 0, modifiers, 504, 0, x, y, false, null);
            for (int currentClick = 1; currentClick <= clickCount; ++currentClick) {
                AutomatableAwtComponent.sendMouseEvent(this.component, mouseButton, modifiers | buttonMask | buttonDownMask, 501, currentClick, x, y, popupTrigger, currentClick == clickCount ? clickSentConfirmation : null);
                AutomatableAwtComponent.sendMouseEvent(this.component, mouseButton, modifiers | buttonMask, 502, currentClick, x, y, popupTrigger, null);
                if (this.component instanceof JMenuItem) continue;
                AutomatableAwtComponent.sendMouseEvent(this.component, mouseButton, modifiers | buttonMask, 500, currentClick, x, y, false, null);
            }
            AutomatableAwtComponent.sendMouseEvent(this.component, 0, 0, 505, 0, x, y, false, null);
            ((Component)this.component).repaint();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void sendEvent(final AWTEvent event, Component eventTarget, AtomicBoolean eventPushConfirmation) throws InterruptedException {
        AutomatableAwtComponent.assertNotUIThread();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        final EventQueue queue = AwtTools.getApplicationEventQueue(eventTarget);
        final AtomicBoolean eventPushed = new AtomicBoolean();
        final CountDownLatch dispatchedLock = new CountDownLatch(1);
        AWTEventListener eventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                if (e == event || eventPushed.get() && queue.peekEvent(event.getID()) == null) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    dispatchedLock.countDown();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(eventListener, Long.MAX_VALUE);
        queue.postEvent(event);
        eventPushed.set(true);
        if (eventPushConfirmation != null) {
            eventPushConfirmation.set(true);
        }
        try {
            dispatchedLock.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedException();
        }
        finally {
            Toolkit.getDefaultToolkit().removeAWTEventListener(eventListener);
        }
    }

    private static void sendKeyEvent(Component component, int action, int modifiers, int keyCode, char keyChar) throws InterruptedException {
        KeyEvent event = new KeyEvent(component, action, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        AutomatableAwtComponent.sendEvent(event, component, null);
    }

    @Override
    public void sendKey(AutomatableKey key, boolean shift, boolean alt, boolean ctrl, boolean forceFocus) throws JavaAppException {
        AutomatableAwtComponent.assertNotUIThread();
        AwtAutomatableKey awtKey = AwtAutomatableKey.fromAutomatableKey(key);
        int modifiers = 0;
        modifiers += shift ? 64 : 0;
        modifiers += alt ? 512 : 0;
        modifiers += ctrl ? 128 : 0;
        if (forceFocus) {
            this.getFocus();
        }
        Object parent = this.component;
        while (((Component)parent).getParent() != null) {
            parent = ((Component)parent).getParent();
        }
        char keyChar = awtKey.getKeyChar();
        if (keyChar != '\uffff' && (modifiers & 0x40) != 0) {
            keyChar = Character.toUpperCase(keyChar);
        }
        int keyCode = awtKey.getKeyCode();
        try {
            AutomatableAwtComponent.sendKeyEvent(parent, 401, modifiers, keyCode, keyChar);
            if (keyChar != '\uffff' && !ctrl && !alt) {
                AutomatableAwtComponent.sendKeyEvent(parent, 400, modifiers, 0, keyChar);
            }
            AutomatableAwtComponent.sendKeyEvent(parent, 402, modifiers, keyCode, keyChar);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void drag(AutomationTarget target) throws Exception {
        AutomatableAwtComponent.assertNotUIThread();
        final Exception sourceError = new Exception("Source is not dragable");
        final Exception targetError = new Exception("Target won't accept drop");
        if (!(this.getComponent() instanceof JComponent)) {
            throw sourceError;
        }
        final JComponent dragComponent = (JComponent)this.getComponent();
        if (!(target.getAutomatable() instanceof AutomatableAwtComponent)) {
            throw targetError;
        }
        AutomatableAwtComponent targetAutomatable = (AutomatableAwtComponent)target.getAutomatable();
        if (!(targetAutomatable.getComponent() instanceof JComponent)) {
            throw targetError;
        }
        final JComponent dropComponent = (JComponent)targetAutomatable.getComponent();
        Rectangle dropAutomatableBounds = targetAutomatable.getComponentRelativeBounds();
        final Point dropOffset = new Point(dropAutomatableBounds.x + target.getX(), dropAutomatableBounds.y + target.getY());
        Rectangle dragOffset = this.getComponentRelativeBounds();
        AutomatableAwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (dragComponent.getTransferHandler() == null || dragComponent.getTransferHandler().getSourceActions(dragComponent) == 0) {
                    throw sourceError;
                }
                if (dropComponent.getDropTarget() == null) {
                    throw targetError;
                }
                return null;
            }
        });
        AutomatableAwtComponent.sendMouseEvent(dragComponent, 1, 1040, 501, 1, dragOffset.x, dragOffset.y, false, null);
        AutomatableAwtComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TransferHandler transferHandler = dragComponent.getTransferHandler();
                int actions2 = transferHandler.getSourceActions(dragComponent);
                final DropTarget dropTarget = dropComponent.getDropTarget();
                int action = 0;
                action = (actions2 & 2) != 0 ? 2 : ((actions2 & 1) != 0 ? 1 : 0x40000000);
                DropTargetContext dropTargetContext = dropTarget.getDropTargetContext();
                final Transferable transferable = (Transferable)Reflection.call(transferHandler, "createTransferable", JComponent.class, dragComponent);
                DropTargetContextPeer dropContextPeer = new DropTargetContextPeer(){

                    @Override
                    public void setTargetActions(int actions2) {
                    }

                    @Override
                    public int getTargetActions() {
                        return dropTarget.getDefaultActions();
                    }

                    @Override
                    public DropTarget getDropTarget() {
                        return dropTarget;
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return this.getTransferable().getTransferDataFlavors();
                    }

                    @Override
                    public Transferable getTransferable() throws InvalidDnDOperationException {
                        if (transferable == null) {
                            throw new InvalidDnDOperationException();
                        }
                        return transferable;
                    }

                    @Override
                    public boolean isTransferableJVMLocal() {
                        return true;
                    }

                    @Override
                    public void acceptDrag(int dragAction) {
                    }

                    @Override
                    public void rejectDrag() {
                    }

                    @Override
                    public void acceptDrop(int dropAction) {
                    }

                    @Override
                    public void rejectDrop() {
                    }

                    @Override
                    public void dropComplete(boolean success) {
                    }
                };
                try {
                    Reflection.call(dropTargetContext, "addNotify", DropTargetContextPeer.class, dropContextPeer);
                }
                catch (NoSuchMethodException e) {
                    Reflection.call(dropTargetContext, "setDropTargetContextPeer", DropTargetContextPeer.class, dropContextPeer);
                }
                dropTarget.dragEnter(new DropTargetDragEvent(dropTargetContext, dropOffset, action, actions2));
                dropTarget.drop(new DropTargetDropEvent(dropTargetContext, dropOffset, action, actions2, true));
                Reflection.call(transferHandler, "exportDone", JComponent.class, dragComponent, Transferable.class, transferable, Integer.TYPE, action);
                return null;
            }
        });
    }

    @Override
    public boolean isClickable() {
        return !AutomatableAwtComponent.isGlassPane((Component)this.getComponent());
    }

    public static JRootPane getJRootPane(Component component) {
        if (component instanceof JFrame) {
            return ((JFrame)component).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                return (JRootPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static boolean isGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        JRootPane rootPane = AutomatableAwtComponent.getJRootPane(component);
        if (rootPane != null && rootPane.getGlassPane() == component) {
            return true;
        }
        return AutomatableAwtComponent.isCustomGlassPane(component);
    }

    public static boolean isCustomGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        String extendedSimpleClassName = AutomatableAwtComponent.getExtendedSimpleClassName(component);
        return extendedSimpleClassName.startsWith("GlassMouseGrabProvider$Proxy");
    }

    @Override
    public AutomationTarget getDragEventTarget(final Point offset) throws JavaAppException {
        return AutomatableAwtComponent.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Rectangle referenceAutomatableBounds = AutomatableAwtComponent.this.getComponentRelativeBounds();
                if (offset.x >= 0 && offset.x < referenceAutomatableBounds.width && offset.y >= 0 && offset.y < referenceAutomatableBounds.height) {
                    return new AutomationTarget(AutomatableAwtComponent.this, offset.x, offset.y);
                }
                Point absoluteOffset = new Point(referenceAutomatableBounds.x + offset.x, referenceAutomatableBounds.y + offset.y);
                Object currentComponent = AutomatableAwtComponent.this.getComponent();
                while (((Component)currentComponent).getParent() != null) {
                    Point componentBounds = ((Component)currentComponent).getLocation();
                    absoluteOffset.translate(componentBounds.x, componentBounds.y);
                    currentComponent = ((Component)currentComponent).getParent();
                }
                return AutomatableAwtComponent.automatableFromComponent((Component)currentComponent).getClickEventTarget(absoluteOffset);
            }
        });
    }

    public static List<byte[]> captureImages(List<AutomatableAwtComponent<?>> awtNodes) throws Exception {
        HashMap<Object, BufferedImage> cache = new HashMap<Object, BufferedImage>();
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        for (AutomatableAwtComponent<?> automatable : awtNodes) {
            BufferedImage image;
            Object component;
            List<AutomatableAwtComponent<?>> frameChildren;
            if (!(automatable instanceof AutomatableAwtComponent)) continue;
            if (automatable.getName().equals("PluginEmbeddedFrame") && (frameChildren = automatable.getChildren()).size() == 1) {
                automatable = frameChildren.get(0);
            }
            if (cache.containsKey(component = automatable.getComponent())) {
                image = (BufferedImage)cache.get(component);
            } else {
                image = new BufferedImage(((Component)component).getWidth(), ((Component)component).getHeight(), 2);
                ((Component)component).printAll(image.createGraphics());
                cache.put(component, image);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Rectangle bounds = automatable.getComponentRelativeBounds();
            ImageIO.write((RenderedImage)image.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height), "png", outputStream);
            outputStream.flush();
            images.add(outputStream.toByteArray());
        }
        return images;
    }

    public static Automatable getKeyboardFocusAutomatable() throws Exception {
        return Automatable.uiSafeExecute(new Callable<Automatable>(){

            @Override
            public Automatable call() throws Exception {
                Component focusComponent = (Component)Reflection.safeCall(KeyboardFocusManager.getCurrentKeyboardFocusManager(), "getGlobalFocusOwner", new Object[0]);
                if (focusComponent != null) {
                    return AutomatableAwtComponent.automatableFromComponent(focusComponent);
                }
                List<Window> windows = AwtTools.getWindows();
                for (Window window : windows) {
                    if (!window.hasFocus()) continue;
                    return AutomatableAwtComponent.automatableFromComponent(window.getFocusOwner());
                }
                if (windows.size() == 1) {
                    return AutomatableAwtComponent.automatableFromComponent(windows.get(0));
                }
                return null;
            }
        });
    }

    public static AutomatableAwtComponent<?> automatableFromComponent(Component component) {
        return AutomatableAwtComponent.automatableFromComponent(component, null);
    }

    public static AutomatableAwtComponent<?> automatableFromComponent(Component component, AutomatableAwtComponent<?> parent) {
        if (component instanceof JProgressBar) {
            return new AutomatableProgressBar((JProgressBar)component, parent);
        }
        if (component instanceof JList) {
            return new AutomatableList((JList)component, parent);
        }
        if (component instanceof JTabbedPane) {
            return new AutomatableTabbedPane((JTabbedPane)component, parent);
        }
        if (component instanceof JTree) {
            return new AutomatableTree((JTree)component, parent);
        }
        if (component instanceof JTable) {
            return new AutomatableTable((JTable)component, parent);
        }
        if (component instanceof JTableHeader) {
            return new AutomatableTableHeader((JTableHeader)component, parent);
        }
        if (component instanceof JComboBox) {
            return new AutomatableComboBox((JComboBox)component, parent);
        }
        if (component instanceof JTextComponent) {
            return new AutomatableTextComponent((JTextComponent)component, parent);
        }
        List<String> classHeirarchy = Reflection.getClassHeirarchy(component);
        if (classHeirarchy.contains("oracle.forms.ui.VTextField")) {
            return new AutomatableVTextField(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.tabBar.TabBar")) {
            return new AutomatableTabBar(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.lwAWT.lwMenu.LWRadioButtonMenuItem")) {
            return new AutomatableLWRadioButtonMenuItem(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.lwAWT.lwMenu.LWMenuItem")) {
            return new AutomatableLWMenuItem(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.statusBar.StatusBar")) {
            return new AutomatableStatusBar(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.statusBar.oracle.ewt.lwAWT.LWLabel")) {
            return new AutomatableLWLabel(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.lwAWT.LWCheckbox")) {
            return new AutomatableLWCheckbox(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.button.PushButton")) {
            return new AutomatablePushButton(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.toolBar.ToolBar")) {
            return new AutomatableToolBar(component, parent);
        }
        if (classHeirarchy.contains("oracle.ewt.lwAWT.LWDataSourceList.Content")) {
            return new AutomatableLWDataSourceListContent(component, parent);
        }
        if (classHeirarchy.contains("oracle.forms.ui.DrawnPanel")) {
            return new AutomatableDrawnPanel(component, parent);
        }
        if (classHeirarchy.contains("oracle.forms.ui.ListView")) {
            return new AutomatableListView(component, parent);
        }
        return new AutomatableAwtComponent<Component>(component, parent);
    }

    private static class NameCheck {
        private NameCheck() {
        }

        public static boolean isNameSystemGenerated(Object component) {
            try {
                if (component instanceof JPanel) {
                    return true;
                }
                if (component instanceof Component) {
                    return (Boolean)Reflection.getPropertyWithReflection(component, "nameExplicitlySet", false, false) == false;
                }
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
            return false;
        }
    }
}

