/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.NodeManager;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.xpath.XPath;
import org.ibboost.orqa.xpath.XPathBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutomationEventListener {
    private static final long EVENT_CALLBACK_TIMEOUT = 10000L;
    private final IRemoteEventReceiver receiver;
    private final boolean optimizeXPaths;
    private final boolean captureXmlSnapshots;
    private AutomationElement lastElement;
    private String lastXPathFromElement;
    private Automatable lastAutomatable;
    private AutomationElement lastElementFromAutomatable;
    private final List<Node> progressBars = Collections.synchronizedList(new ArrayList());
    private final List<Thread> progressBarWaitThreads = Collections.synchronizedList(new ArrayList());
    private static final int PROGRESS_BAR_STARTUP_DELAY = 200;

    public AutomationEventListener(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots) {
        this.receiver = receiver;
        this.optimizeXPaths = optimizeXPaths;
        this.captureXmlSnapshots = captureXmlSnapshots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<Thread> list = this.progressBarWaitThreads;
        synchronized (list) {
            for (Thread progressBarWaitThread : this.progressBarWaitThreads) {
                progressBarWaitThread.interrupt();
            }
        }
    }

    protected String xPathFromAutomationElement(AutomationElement element) {
        return this.xPathFromAutomationElement(element, IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES);
    }

    protected String xPathFromAutomationElement(AutomationElement element, String[] preferredTextElements, String[] preferredAttributes) {
        if (element.equals(this.lastElement)) {
            return this.lastXPathFromElement;
        }
        AutomationDocument document = new AutomationDocument();
        XPathBuilder xpathBuilder = new XPathBuilder();
        xpathBuilder.setRootNode(document);
        xpathBuilder.setAllowedElementDescendents("Row", new String[]{"Cell"});
        xpathBuilder.setPreferredTextElements(preferredTextElements);
        xpathBuilder.setPreferredAttributes(preferredAttributes);
        this.lastXPathFromElement = xpathBuilder.getPathToNode(element, this.optimizeXPaths);
        this.lastElement = element;
        return this.lastXPathFromElement;
    }

    protected AutomationElement getElementFromAutomatable(Automatable automatable) {
        if (automatable.equals(this.lastAutomatable)) {
            return this.lastElementFromAutomatable;
        }
        this.lastAutomatable = automatable;
        this.lastElementFromAutomatable = new AutomationDocument().findAutomatableElement(automatable);
        return this.lastElementFromAutomatable;
    }

    public void newEvent(final AutomationTarget automationTarget, final AutomationElement element, final String xPath, final AutomatableClick clickType, final AutomatableKey key, final boolean ctrlDown, final boolean altDown, final boolean shiftDown) throws JavaAppException {
        final Automatable automatable = automationTarget.getAutomatable();
        final String preEventXmlSnapshot = this.captureXmlSnapshots ? AutomationDocument.nodeToXml(new AutomationDocument()) : null;
        Object preEventValueObject = automatable.hasStringValue() ? automatable.getValue() : null;
        final String preEventValue = preEventValueObject != null ? preEventValueObject.toString() : null;
        final boolean isPasswordField = automatable.isPasswordField();
        UiThreadJobManager.asyncRunOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    final AtomicReference<String> postEventValue = new AtomicReference<String>();
                    final AtomicReference postEventXmlSnapshot = new AtomicReference();
                    try {
                        if (automatable.hasStringValue()) {
                            Object postEventValueObject = automatable.getValue();
                            postEventValue.set(postEventValueObject != null ? postEventValueObject.toString() : null);
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                    try {
                        if (AutomationEventListener.this.captureXmlSnapshots) {
                            postEventValue.set(AutomationDocument.nodeToXml(new AutomationDocument()));
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                    if (key != null) {
                        UiThreadJobManager.pauseUiThreadForExternalJob(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AutomationEventListener.this.receiver.newKeyEvent(new Date().getTime(), NodeManager.getNodeReference(element), (String)postEventValue.get(), preEventValue, xPath, automatable.isTextCurrentlyEditable(), key, ctrlDown, altDown, shiftDown, isPasswordField, preEventXmlSnapshot, (String)postEventXmlSnapshot.get());
                                }
                                catch (Exception e) {
                                    RemoteLogger.error(e);
                                }
                            }
                        }, 10000L);
                    } else if (clickType != null) {
                        UiThreadJobManager.pauseUiThreadForExternalJob(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AutomationEventListener.this.receiver.newMouseEvent(new Date().getTime(), NodeManager.getNodeReference(element), (String)postEventValue.get(), preEventValue, xPath, automatable.isTextCurrentlyEditable(), clickType, automationTarget.getX(), automationTarget.getY(), ctrlDown, altDown, shiftDown, isPasswordField, preEventXmlSnapshot, (String)postEventXmlSnapshot.get());
                                }
                                catch (Exception e) {
                                    RemoteLogger.error(e);
                                }
                            }
                        }, 10000L);
                    } else {
                        return;
                    }
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(200L);
                                AutomationEventListener.this.findAndMonitorProgressBars("[@complete=\"false\"]", "[@complete=\"true\"]", IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES);
                                AutomationEventListener.this.findAndMonitorProgressBars("[normalize-space(@text)=\"Processing\"]", "[normalize-space(@text)=\"Idle\"]", IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES_NO_TEXT);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findAndMonitorProgressBars(final String incompletePredicate, final String completePredicate, final String[] preferredXPathTextElements, final String[] preferredXPathAttributes) {
        try {
            NodeList newProgressBars = NodeManager.getNodes("//*" + incompletePredicate, null, true);
            for (int i = 0; i < newProgressBars.getLength(); ++i) {
                final Node newProgressBar = newProgressBars.item(i);
                boolean alreadyInProgress = false;
                List<Node> list = this.progressBars;
                synchronized (list) {
                    for (Node progressBar : this.progressBars) {
                        if (!progressBar.isSameNode(newProgressBar)) continue;
                        alreadyInProgress = true;
                        break;
                    }
                }
                final Automatable automatable = ((AutomationElement)newProgressBar).getAutomatable();
                if (alreadyInProgress || !automatable.isVisible()) continue;
                this.progressBars.add(newProgressBar);
                new Thread(){

                    @Override
                    public void run() {
                        block8: {
                            try {
                                boolean complete;
                                long waitStartTime;
                                String activeXPath;
                                block7: {
                                    AutomationElement element = AutomationEventListener.this.getElementFromAutomatable(automatable);
                                    String xPath = AutomationEventListener.this.xPathFromAutomationElement(element, preferredXPathTextElements, preferredXPathAttributes);
                                    activeXPath = xPath + incompletePredicate;
                                    waitStartTime = new Date().getTime();
                                    complete = false;
                                    AutomationEventListener.this.progressBarWaitThreads.add(this);
                                    try {
                                        long stopTime = System.currentTimeMillis() + 86400000L;
                                        while (System.currentTimeMillis() < stopTime) {
                                            newProgressBar.normalize();
                                            if (!automatable.isVisible() || XPath.queryNode(newProgressBar, "self::node()" + completePredicate) != null) {
                                                complete = true;
                                                break;
                                            }
                                            Thread.sleep(Math.min(100L, Math.max(stopTime - System.currentTimeMillis(), 0L)));
                                        }
                                    }
                                    catch (Exception e) {
                                        if (e instanceof InterruptedException) break block7;
                                        RemoteLogger.error(e);
                                    }
                                }
                                if (complete) {
                                    int waitTime = (int)((new Date().getTime() - waitStartTime + 500L) / 1000L);
                                    String xmlSnapshot = AutomationEventListener.this.captureXmlSnapshots ? AutomationDocument.nodeToXml(new AutomationDocument()) : null;
                                    AutomationEventListener.this.receiver.newProgressEvent(new Date().getTime(), activeXPath, waitTime, null, xmlSnapshot);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof InterruptedException) break block8;
                                RemoteLogger.error(e);
                            }
                        }
                        AutomationEventListener.this.progressBars.remove(newProgressBar);
                        AutomationEventListener.this.progressBarWaitThreads.remove(this);
                    }
                }.start();
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
    }
}

