/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.events.enums.SetTextPostAction;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTable;

public abstract class Automatable {
    protected static final long THREAD_LOCK_TIMEOUT = 1000L;
    protected static final String[] XATTR_NAME = new String[]{"name"};
    protected static final String[] XATTR_INDEX = new String[]{"index"};
    protected static final String[] XATTR_POSITION_SIZE = new String[]{"x", "y", "width", "height"};
    protected static final String[] XATTR_COLORS = new String[]{"background", "foreground"};
    protected static final String[] XATTR_INDEX_POSITION_SIZE = Automatable.appendAttributes(XATTR_INDEX, XATTR_POSITION_SIZE);
    protected static final String[] XATTR_INDEX_POSITION_SIZE_COLORS = Automatable.appendAttributes(XATTR_INDEX_POSITION_SIZE, XATTR_COLORS);
    protected static final String[] XATTR_NAME_POSITION_SIZE = Automatable.appendAttributes(XATTR_NAME, XATTR_POSITION_SIZE);
    protected static final String[] XATTR_NAME_POSITION_SIZE_COLORS = Automatable.appendAttributes(XATTR_NAME_POSITION_SIZE, XATTR_COLORS);
    protected static final String[] XATTR_TEXT = new String[]{"text"};
    protected static final String[] XATTR_TITLE = new String[]{"title"};
    protected static final String[] XATTR_ENABLED = new String[]{"enabled"};
    protected static final String[] XATTR_SELECTED = new String[]{"selected"};
    protected static final String[] XATTR_TEXT_CONTROLS = Automatable.appendAttributes(XATTR_NAME_POSITION_SIZE_COLORS, XATTR_TEXT);
    protected static final String[] XATTR_TABS = Automatable.appendAttributes(XATTR_TEXT_CONTROLS, XATTR_SELECTED);
    protected static final String[] XATTR_BUTTONS = Automatable.appendAttributes(XATTR_TEXT_CONTROLS, new String[][]{XATTR_ENABLED, XATTR_SELECTED});
    protected static final String[] XATTR_FRAMES = Automatable.appendAttributes(XATTR_NAME_POSITION_SIZE, XATTR_TITLE);
    public static final String[] INTEGER_ATTRIBUTES = XATTR_INDEX_POSITION_SIZE;
    public static final String[] BOOLEAN_ATTRIBUTES = Automatable.appendAttributes(XATTR_ENABLED, XATTR_SELECTED);
    public static final String[] TEXT_ATTRIBUTES = XATTR_TEXT;
    private static ThreadLocal<String> optimisationTarget = new ThreadLocal();
    public static Map<Class<?>, Boolean> hasStringValueCache = new ConcurrentHashMap();

    public static void optimiseForTarget(String target) {
        if (target != null && !target.isEmpty()) {
            optimisationTarget.set(target);
            AutomatableTable.optimiseForTarget(target);
        } else {
            Automatable.resetOptimisation();
        }
    }

    public static String getOptimisationTarget() {
        return optimisationTarget.get();
    }

    public static void resetOptimisation() {
        optimisationTarget.remove();
        AutomatableTable.resetOptimisation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T uiSafeExecute(final Callable<T> task) throws JavaAppException {
        try {
            if (UiThreadJobManager.isUiThread()) {
                return task.call();
            }
            final AtomicReference result = new AtomicReference();
            final AtomicReference error = new AtomicReference();
            final CountDownLatch operationCompleteLatch = new CountDownLatch(1);
            final CountDownLatch cancelLatch = new CountDownLatch(1);
            final AtomicBoolean operationStarted = new AtomicBoolean(false);
            final AtomicBoolean operationCancelled = new AtomicBoolean(false);
            final AtomicReference uiThread = new AtomicReference();
            final String optimisationTarget = Automatable.getOptimisationTarget();
            Runnable executionRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            if (operationCancelled.get()) {
                                return;
                            }
                            uiThread.set(Thread.currentThread());
                            operationStarted.set(true);
                            Automatable.optimiseForTarget(optimisationTarget);
                            result.set(task.call());
                        }
                        catch (Throwable t) {
                            error.set(t);
                        }
                        finally {
                            Automatable.resetOptimisation();
                            operationCompleteLatch.countDown();
                        }
                        cancelLatch.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            UiThreadJobManager.asyncRunOnUiThread(executionRunnable);
            try {
                operationCompleteLatch.await();
                if (error.get() != null) {
                    throw (Throwable)error.get();
                }
                Object v = result.get();
                return (T)v;
            }
            catch (InterruptedException e) {
                operationCancelled.set(true);
                if (!operationStarted.get()) throw e;
                ((Thread)uiThread.get()).interrupt();
                throw e;
            }
            finally {
                cancelLatch.countDown();
            }
        }
        catch (Throwable t) {
            throw JavaAppException.wrap(t);
        }
    }

    protected static String[] appendAttributes(String[] base, String[] ... additionalAttributes) {
        int length = base.length;
        for (String[] additionalAttributeSet : additionalAttributes) {
            length += additionalAttributeSet.length;
        }
        String[] result = new String[length];
        System.arraycopy(base, 0, result, 0, base.length);
        int resultPos = base.length;
        for (String[] additionalAttributeSet : additionalAttributes) {
            System.arraycopy(additionalAttributeSet, 0, result, resultPos, additionalAttributeSet.length);
            resultPos += additionalAttributeSet.length;
        }
        return result;
    }

    protected static String[] appendAttributes(String[] base, String ... additionalAttributes) {
        return Automatable.appendAttributes(base, new String[][]{additionalAttributes});
    }

    public static String getXPathNodeNameFromClass(Class<?> cls) {
        String simpleName = cls.getSimpleName();
        if (simpleName.equals("")) {
            simpleName = cls.getName();
            simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
        }
        String result = "";
        int length = 0;
        boolean lastCharacterClean = false;
        boolean seenLetter = false;
        for (int i = 0; i < simpleName.length(); ++i) {
            Character c = Character.valueOf(simpleName.charAt(i));
            if (Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_' && c.charValue() < '\u0080') {
                if (!seenLetter && Character.isLetter(c.charValue())) {
                    result = result + Character.toUpperCase(c.charValue());
                    seenLetter = true;
                } else {
                    result = result + c;
                }
                lastCharacterClean = true;
                ++length;
                continue;
            }
            if (!lastCharacterClean) continue;
            result = result + '-';
            lastCharacterClean = false;
        }
        if (length == 0) {
            return "Unnamed";
        }
        return result;
    }

    public static String getExtendedSimpleClassName(Component component) {
        String className = component.getClass().getName();
        return className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
    }

    public String getName() {
        return Automatable.getXPathNodeNameFromClass(this.getComponent().getClass());
    }

    public boolean equals(Object other) {
        return other == null || other.getClass() != this.getClass() ? false : this.getComponent() == ((Automatable)other).getComponent();
    }

    public void performPostAction(SetTextPostAction action) throws JavaAppException {
        switch (action) {
            case PRESS_ENTER: {
                this.sendKey(AutomatableKey.ENTER, false, false, false, false);
                break;
            }
            case PRESS_TAB: {
                this.sendKey(AutomatableKey.TAB, false, false, false, false);
                break;
            }
            case LOSE_FOCUS: {
                this.transferFocus();
                break;
            }
        }
    }

    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        Automatable.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Object component = Automatable.this.getComponent();
                    String newText = text;
                    if (append) {
                        try {
                            String existingText = (String)Reflection.safeCall(component, "getText", new Object[0]);
                            if (existingText != null && !existingText.isEmpty()) {
                                newText = existingText + text;
                            }
                        }
                        catch (Exception e) {
                            RemoteLogger.error(e);
                        }
                    }
                    Reflection.call(component, "setText", String.class, newText);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException();
                }
                return null;
            }
        });
    }

    public Object getValue() throws JavaAppException {
        return Automatable.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (Automatable.this.hasTextAttribute()) {
                        return Automatable.this.getAttributeValue("text");
                    }
                    Object component = Automatable.this.getComponent();
                    String text = (String)Reflection.call(component, "getText", new Object[0]);
                    if (text == null) {
                        text = "";
                    }
                    return text;
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException();
                }
            }
        });
    }

    public boolean hasAttribute(String name) {
        for (String attributeName : this.getAttributeNames()) {
            if (!attributeName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStringValue() {
        Object component = this.getComponent();
        Class<?> componentClass = component.getClass();
        Boolean hasStringValue = hasStringValueCache.get(componentClass);
        if (hasStringValue != null) {
            return hasStringValue;
        }
        try {
            Reflection.getMethod(componentClass, "getText", new Class[0]);
            hasStringValue = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hasStringValue == null) {
            hasStringValue = false;
        }
        hasStringValueCache.put(componentClass, hasStringValue);
        return hasStringValue;
    }

    public AutomationTarget getClickEventTarget(final Point offset) throws JavaAppException {
        return Automatable.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                List<? extends Automatable> children = Automatable.this.getChildren();
                for (Automatable automatable : children) {
                    Rectangle bounds;
                    if (!automatable.isClickable() || (bounds = automatable.getParentRelativeBounds()) == null || !bounds.contains(offset)) continue;
                    Point translatedPoint = new Point(offset.x - bounds.x, offset.y - bounds.y);
                    return automatable.getClickEventTarget(translatedPoint);
                }
                return new AutomationTarget(Automatable.this, offset.x, offset.y);
            }
        });
    }

    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return new AutomationTarget(this);
    }

    public abstract AutomationTarget getDragEventTarget(Point var1) throws JavaAppException;

    public abstract Automatable getParent() throws JavaAppException;

    public abstract List<? extends Automatable> getChildren() throws JavaAppException;

    public abstract void sendKey(AutomatableKey var1, boolean var2, boolean var3, boolean var4, boolean var5) throws JavaAppException;

    public abstract void click(AutomatableClick var1, int var2, int var3, boolean var4, boolean var5, boolean var6, AtomicBoolean var7) throws JavaAppException;

    public abstract Rectangle getComponentRelativeBounds() throws JavaAppException;

    public abstract Rectangle getParentRelativeBounds() throws JavaAppException;

    public abstract Rectangle getWindowRelativeBounds() throws JavaAppException;

    public abstract void drag(AutomationTarget var1) throws Exception;

    public abstract void getFocus() throws JavaAppException;

    public abstract void transferFocus() throws JavaAppException;

    public abstract void select(boolean var1) throws JavaAppException;

    public boolean isClickable() throws JavaAppException {
        return this.isVisible();
    }

    public abstract boolean isVisible() throws JavaAppException;

    public abstract void setSize(int var1, int var2) throws JavaAppException;

    public abstract void setLocation(int var1, int var2) throws JavaAppException;

    public abstract void maximise() throws JavaAppException;

    public abstract String[] getAttributeNames();

    public abstract String getAttributeValue(String var1) throws JavaAppException;

    public abstract boolean isPasswordField() throws JavaAppException;

    public abstract boolean isTextCurrentlyEditable() throws JavaAppException;

    public abstract Object getComponent();

    public abstract boolean isVirtualComponent();

    protected abstract boolean hasTextAttribute();
}

