/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.ibboost.orqa.automation.events.exceptions.TargetNotFoundException;
import org.ibboost.orqa.automation.events.exceptions.TargetNotValidException;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.xpath.XPath;
import org.ibboost.orqa.xpath.XPathWaitType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeManager {
    private static final long MAX_QUERY_WAIT = 5000L;
    private static final Map<UUID, Node> localContext = new ConcurrentHashMap<UUID, Node>();
    private static String sessionName;

    public static void setSessionName(String sessionName) {
        NodeManager.sessionName = sessionName;
    }

    public static ProxyNodeReference getNodeReference(Node node) {
        if (node instanceof AutomationDocument) {
            return new ProxyNodeReference(sessionName, null, node.getNodeName());
        }
        UUID id = UUID.randomUUID();
        localContext.put(id, node);
        return new ProxyNodeReference(sessionName, id, node.getNodeName());
    }

    public static void removeNodeReference(ProxyNodeReference ref) {
        if (ref != null && ref.getID() != null) {
            localContext.remove(ref.getID());
        }
    }

    public static Node getNodeFromReference(ProxyNodeReference ref) {
        if (ref == null || ref.getID() == null) {
            return new AutomationDocument();
        }
        Node node = localContext.get(ref.getID());
        if (node != null) {
            node.normalize();
        }
        return node;
    }

    public static NodeList getNodes(String target, ProxyNodeReference element, boolean allowZeroResults) throws RemoteException {
        return (NodeList)NodeManager.evaluate(target, element, XPathConstants.NODESET, allowZeroResults);
    }

    public static Object evaluate(String target, ProxyNodeReference element, boolean allowZeroResults) throws RemoteException {
        return NodeManager.evaluate(target, element, null, allowZeroResults);
    }

    public static Object evaluate(final String target, final ProxyNodeReference element, final QName returnType, final boolean allowZeroResults) throws RemoteException {
        return Automatable.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Automatable.optimiseForTarget(target);
                Object result = null;
                try {
                    Node root = NodeManager.getNodeFromReference(element);
                    if (root instanceof AutomationElement) {
                        root = ((AutomationElement)root).refresh();
                    }
                    Object object = result = allowZeroResults ? XPath.evaluate(root, target, returnType) : XPath.evaluate(root, target, returnType, 5000L);
                    if ((result == null || result instanceof NodeList && ((NodeList)result).getLength() == 0) && !allowZeroResults) {
                        throw new TargetNotFoundException(target);
                    }
                }
                finally {
                    Automatable.resetOptimisation();
                }
                if (result instanceof Node) {
                    ((Node)result).normalize();
                }
                if (result instanceof NodeList) {
                    NodeList nodeList = (NodeList)result;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        nodeList.item(i).normalize();
                    }
                }
                return result;
            }
        });
    }

    public static void waitForTarget(Node element, String target, float maxWait, XPathWaitType waitType, String targetValue) throws RemoteException {
        Automatable.optimiseForTarget(target);
        try {
            long wait = (long)(maxWait * 1000.0f);
            if (element instanceof AutomationElement) {
                element = ((AutomationElement)element).refresh();
            }
            XPath.waitForNode(element, target, waitType, targetValue, wait);
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
        finally {
            Automatable.resetOptimisation();
        }
    }

    public static boolean checkTargetExists(Node element, String target) throws Exception {
        Automatable.optimiseForTarget(target);
        try {
            if (element instanceof AutomationElement) {
                element = ((AutomationElement)element).refresh();
            }
            boolean bl = XPath.queryNode(element, target) != null;
            return bl;
        }
        finally {
            Automatable.resetOptimisation();
        }
    }

    public static Automatable getComponent(ProxyNodeReference element, String target) throws RemoteException {
        UiThreadJobManager.assertNotUIThread();
        Node node = target == null ? NodeManager.getNodeFromReference(element) : NodeManager.getNodes(target, element, false).item(0);
        if (!(node instanceof AutomationElement)) {
            throw new TargetNotValidException();
        }
        return ((AutomationElement)node).getAutomatable();
    }

    public static List<Automatable> getComponents(ProxyNodeReference element, String target) throws RemoteException {
        UiThreadJobManager.assertNotUIThread();
        ArrayList<Automatable> results = new ArrayList<Automatable>();
        NodeList nodes = NodeManager.getNodes(target, element, false);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof AutomationElement)) {
                throw new TargetNotValidException();
            }
            results.add(((AutomationElement)node).getAutomatable());
        }
        return results;
    }
}

