/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.events.enums.SetTextPostAction;
import org.ibboost.orqa.automation.events.exceptions.TargetNotFoundException;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.INodeCaptureReceiver;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.OperationTimeoutException;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;
import org.ibboost.orqa.automation.java.common.logging.FileLogger;
import org.ibboost.orqa.automation.java.common.logging.ILogCallback;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AppType;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.DebugTools;
import org.ibboost.orqa.automation.java.proxy.NodeManager;
import org.ibboost.orqa.automation.java.proxy.ProxyAgent;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtEventCapture;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.SwtEventCapture;
import org.ibboost.orqa.xpath.XPathExpression;
import org.ibboost.orqa.xpath.XPathWaitType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutomationProxyImpl
extends UnicastRemoteObject
implements IAutomationProxy {
    private static final long serialVersionUID = 1L;
    private static final RMILoopbackSocketFactory socketFactory = new RMILoopbackSocketFactory();
    private int exitStatus = 0;
    private final HashMap<UUID, Thread> interruptableOperations = new HashMap();
    private final CountDownLatch blockUntillAppClosesLatch = new CountDownLatch(1);
    private final CountDownLatch remoteShutdownLatch = new CountDownLatch(1);

    public AutomationProxyImpl(String sessionName, ILogCallback logCallback) throws RemoteException {
        super(0, socketFactory, socketFactory);
        NodeManager.setSessionName(sessionName);
        RemoteLogger.setLogCallback(logCallback);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AutomationProxyImpl.this.blockUntillAppClosesLatch.countDown();
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    AutomationProxyImpl.this.remoteShutdownLatch.await();
                    System.exit(AutomationProxyImpl.this.exitStatus);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public synchronized void shutdown(int exitStatus) {
        this.exitStatus = exitStatus;
        FileLogger.info(String.format("App closing with status %d", exitStatus));
        this.blockUntillAppClosesLatch.countDown();
        this.remoteShutdownLatch.countDown();
    }

    @Override
    public void terminate(int exitStatus) throws RemoteException {
        FileLogger.info("App shutdown requested by ORQA");
        this.shutdown(exitStatus);
    }

    @Override
    public void blockUntilAppCloses() throws RemoteException {
        try {
            this.blockUntillAppClosesLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isSessionAlive() throws RemoteException {
        return true;
    }

    @Override
    public String getWorkingDirectory() throws RemoteException {
        return System.getProperty("user.dir");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, T> R executeOperation(final OperationExecutable<R, T> task, UUID operationId, Long timeout, final boolean runOnUiThread) throws JavaAppException {
        try {
            if (operationId == null && !runOnUiThread) {
                return task.execute(task.evaluateTarget());
            }
            final Thread monitorThread = Thread.currentThread();
            final AtomicReference result = new AtomicReference();
            final AtomicReference error = new AtomicReference();
            Thread executorThread = new Thread(){

                @Override
                public void run() {
                    block5: {
                        try {
                            final Object target = task.evaluateTarget();
                            if (runOnUiThread) {
                                result.set(Automatable.uiSafeExecute(new Callable<R>(){

                                    @Override
                                    public R call() throws Exception {
                                        return task.execute(target);
                                    }
                                }));
                                break block5;
                            }
                            result.set(task.execute(target));
                        }
                        catch (Throwable t) {
                            error.set(t);
                        }
                    }
                }
            };
            Thread shutdownHook = new Thread(){

                @Override
                public void run() {
                    monitorThread.interrupt();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            executorThread.start();
            if (operationId != null) {
                this.interruptableOperations.put(operationId, monitorThread);
            }
            try {
                if (timeout != null) {
                    executorThread.join(timeout);
                    if (executorThread.isAlive()) {
                        OperationTimeoutException operationTimeoutException = new OperationTimeoutException();
                        executorThread.interrupt();
                        throw operationTimeoutException;
                    }
                } else {
                    executorThread.join();
                }
                if (error.get() != null) {
                    throw (Throwable)error.get();
                }
                Object operationTimeoutException = result.get();
                return (R)operationTimeoutException;
            }
            catch (InterruptedException e) {
                executorThread.interrupt();
                if (!AwtTools.isAppShuttingDown()) throw e;
                if (error.get() == null) throw new JavaAppException.JavaAppWarning("The Java application shut down during the operation", result.get());
                throw (Throwable)error.get();
            }
            finally {
                if (operationId != null) {
                    this.interruptableOperations.remove(operationId);
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            throw JavaAppException.wrap(t);
        }
    }

    @Override
    public void cancelOperation(UUID operationId) throws RemoteException {
        Thread operationMonitorThread = this.interruptableOperations.get(operationId);
        if (operationMonitorThread != null) {
            operationMonitorThread.interrupt();
            this.interruptableOperations.remove(operationId);
        }
    }

    @Override
    public List<String> getWindowNames() throws RemoteException {
        return ProxyAgent.getWindowNames();
    }

    @Override
    public boolean hasWindow(String windowName) throws RemoteException {
        return ProxyAgent.hasWindow(windowName);
    }

    @Override
    public int getPid() throws RemoteException {
        return ProxyAgent.getPid();
    }

    @Override
    public void bringWindowsToFront() throws RemoteException {
        block3: {
            block2: {
                if (AppType.getDetectedAppType() != AppType.AWT) break block2;
                for (Window window : AwtTools.getWindows()) {
                    if (!window.isVisible()) continue;
                    window.toFront();
                }
                break block3;
            }
            if (AppType.getDetectedAppType() != AppType.SWT) break block3;
            for (Object shell : Swt.getShells()) {
                if (!AutomatableSwtComponent.isVisible(shell)) continue;
                AutomatableSwtComponent.automatableFromComponent(shell).getFocus();
            }
        }
    }

    @Override
    public void blockUserInput() throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.blockUserInput();
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.blockUserInput();
        }
    }

    @Override
    public void unblockUserInput() throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.unblockUserInput();
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.unblockUserInput();
        }
    }

    @Override
    public void sendKey(final ProxyNodeReference element, final String target, final AutomatableKey key, final boolean shift, final boolean alt, final boolean ctrl, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, Automatable>(){

            @Override
            Automatable evaluateTarget() throws Exception {
                if (target != null || element != null) {
                    return NodeManager.getComponent(element, target);
                }
                Automatable automatable = AutomationProxyImpl.this.getKeyboardFocusAutomatable();
                if (automatable != null) {
                    return automatable;
                }
                throw new Exception("No UI component is in focus.");
            }

            @Override
            Object execute(Automatable automatable) throws Exception {
                boolean focus = target != null;
                automatable.sendKey(key, shift, alt, ctrl, focus);
                return null;
            }
        }, operationId, timeout, false);
    }

    private Automatable getKeyboardFocusAutomatable() throws Exception {
        return AutomatableAwtComponent.getKeyboardFocusAutomatable();
    }

    @Override
    public void click(final ProxyNodeReference element, final String target, final AutomatableClick clickType, final boolean shift, final boolean alt, final boolean ctrl, final int x, final int y, UUID operationId, Long timeout) throws RemoteException {
        block2: {
            final AtomicBoolean clickComplete = new AtomicBoolean();
            try {
                this.executeOperation(new OperationExecutable<Object, Automatable>(){

                    @Override
                    Automatable evaluateTarget() throws Exception {
                        return NodeManager.getComponent(element, target);
                    }

                    @Override
                    Object execute(Automatable automatable) throws Exception {
                        automatable.click(clickType, x, y, shift, alt, ctrl, clickComplete);
                        return null;
                    }
                }, operationId, timeout, false);
            }
            catch (OperationTimeoutException e) {
                if (clickComplete.get()) break block2;
                throw e;
            }
        }
    }

    @Override
    public void drag(final ProxyNodeReference element, final String dragTarget, final String dropTarget, final int xOffset, final int yOffset, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, List<Automatable>>(){

            @Override
            List<Automatable> evaluateTarget() throws Exception {
                Automatable dragAutomatable = NodeManager.getComponent(element, dragTarget);
                Automatable dropReferenceAutomatable = dropTarget != null && !dropTarget.isEmpty() ? NodeManager.getComponent(element, dropTarget) : dragAutomatable;
                return Arrays.asList(dragAutomatable, dropReferenceAutomatable);
            }

            @Override
            Object execute(List<Automatable> targets) throws Exception {
                Automatable dragAutomatable = targets.get(0);
                Automatable dropReferenceAutomatable = targets.get(1);
                AutomationTarget dropAutomationTarget = dropReferenceAutomatable.getDragEventTarget(new Point(xOffset, yOffset));
                dragAutomatable.drag(dropAutomationTarget);
                return null;
            }
        }, operationId, timeout, false);
    }

    @Override
    public void select(final ProxyNodeReference element, final String target, final boolean replace, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, List<Automatable>>(){

            @Override
            List<Automatable> evaluateTarget() throws Exception {
                return NodeManager.getComponents(element, target);
            }

            @Override
            Object execute(List<Automatable> automatables) throws Exception {
                for (int i = 0; i < automatables.size(); ++i) {
                    Automatable automatable = automatables.get(i);
                    automatable.select(i == 0 ? replace : false);
                }
                return null;
            }
        }, operationId, timeout, false);
    }

    private List<byte[]> captureImages(NodeList nodes) throws JavaAppException {
        try {
            ArrayList awtNodes = new ArrayList();
            ArrayList<AutomatableSwtComponent> swtNodes = new ArrayList<AutomatableSwtComponent>();
            ArrayList<byte[]> images = new ArrayList<byte[]>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof AutomationElement)) continue;
                Automatable automatable = ((AutomationElement)node).getAutomatable();
                if (automatable instanceof AutomatableAwtComponent) {
                    awtNodes.add((AutomatableAwtComponent)automatable);
                    continue;
                }
                if (!(automatable instanceof AutomatableSwtComponent)) continue;
                swtNodes.add((AutomatableSwtComponent)automatable);
            }
            if (!awtNodes.isEmpty()) {
                images.addAll(AutomatableAwtComponent.captureImages(awtNodes));
            }
            if (!swtNodes.isEmpty()) {
                images.addAll(AutomatableSwtComponent.captureImages(swtNodes));
            }
            return images;
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    @Override
    public List<byte[]> captureImages(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<List<byte[]>, NodeList>(){

            @Override
            NodeList evaluateTarget() throws Exception {
                return NodeManager.getNodes(target, element, false);
            }

            @Override
            List<byte[]> execute(NodeList nodes) throws Exception {
                return AutomationProxyImpl.this.captureImages(nodes);
            }
        }, operationId, timeout, true);
    }

    @Override
    public byte[] captureNodeImage(final ProxyNodeReference node, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<byte[], Object>(){

            @Override
            byte[] execute(Object o) throws Exception {
                List images = AutomationProxyImpl.this.captureImages(new NodeList(){

                    @Override
                    public Node item(int index) {
                        return NodeManager.getNodeFromReference(node);
                    }

                    @Override
                    public int getLength() {
                        return 1;
                    }
                });
                return images.size() > 0 ? (byte[])images.get(0) : null;
            }
        }, operationId, timeout, true);
    }

    @Override
    public ProxyNodeReference getSubNodeFromLocation(final ProxyNodeReference element, final int xOffset, final int yOffset, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<ProxyNodeReference, Object>(){

            @Override
            ProxyNodeReference execute(Object o) throws Exception {
                AutomationDocument document;
                AutomationElement subNode;
                Automatable automatable;
                Automatable targetAutomatable;
                Node root = NodeManager.getNodeFromReference(element);
                if (root instanceof AutomationElement && !(targetAutomatable = (automatable = ((AutomationElement)root).getAutomatable()).getClickEventTarget(new Point(xOffset, yOffset)).getAutomatable()).equals(automatable) && (subNode = (document = new AutomationDocument()).findAutomatableElement(targetAutomatable)) != null) {
                    return NodeManager.getNodeReference(subNode);
                }
                return null;
            }
        }, operationId, timeout, true);
    }

    @Override
    public void setWindowSize(final ProxyNodeReference element, final String target, final int width, final int height, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, List<Automatable>>(){

            @Override
            List<Automatable> evaluateTarget() throws Exception {
                return NodeManager.getComponents(element, target);
            }

            @Override
            Object execute(List<Automatable> automatables) throws Exception {
                for (Automatable automatable : automatables) {
                    automatable.setSize(width, height);
                }
                return null;
            }
        }, operationId, timeout, true);
    }

    @Override
    public void setWindowPosition(final ProxyNodeReference element, final String target, final int x, final int y, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, List<Automatable>>(){

            @Override
            List<Automatable> evaluateTarget() throws Exception {
                return NodeManager.getComponents(element, target);
            }

            @Override
            Object execute(List<Automatable> automatables) throws Exception {
                for (Automatable automatable : automatables) {
                    automatable.setLocation(x, y);
                }
                return null;
            }
        }, operationId, timeout, true);
    }

    @Override
    public void maximiseWindow(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, List<Automatable>>(){

            @Override
            List<Automatable> evaluateTarget() throws Exception {
                return NodeManager.getComponents(element, target);
            }

            @Override
            Object execute(List<Automatable> automatables) throws Exception {
                for (Automatable automatable : automatables) {
                    automatable.maximise();
                }
                return null;
            }
        }, operationId, timeout, true);
    }

    @Override
    public Map<String, Object> getAttributes(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<Map<String, Object>, Node>(){

            @Override
            Node evaluateTarget() throws Exception {
                return NodeManager.getNodes(target, element, false).item(0);
            }

            @Override
            Map<String, Object> execute(Node node) throws Exception {
                if (node instanceof AutomationElement) {
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                    Automatable automatable = ((AutomationElement)node).getAutomatable();
                    HashSet<String> integerAttributes = new HashSet<String>(Arrays.asList(Automatable.INTEGER_ATTRIBUTES));
                    HashSet<String> booleanAttributes = new HashSet<String>(Arrays.asList(Automatable.BOOLEAN_ATTRIBUTES));
                    HashSet<String> textAttributes = new HashSet<String>(Arrays.asList(Automatable.TEXT_ATTRIBUTES));
                    for (String attribute : automatable.getAttributeNames()) {
                        Object value = automatable.getAttributeValue(attribute);
                        if (value == null || value.toString().trim().isEmpty()) {
                            if (!textAttributes.contains(attribute)) {
                                value = null;
                            }
                        } else if (integerAttributes.contains(attribute)) {
                            value = Integer.valueOf(value.toString());
                        } else if (booleanAttributes.contains(attribute)) {
                            value = Boolean.getBoolean(value.toString());
                        }
                        result.put(attribute, value);
                    }
                    return result;
                }
                throw new Exception("Not a UI element.");
            }
        }, operationId, timeout, true);
    }

    @Override
    public List<ProxyNodeReference> getNodesFromXPath(final ProxyNodeReference element, final String target, final boolean allowZeroResults, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<List<ProxyNodeReference>, NodeList>(){

            @Override
            NodeList evaluateTarget() throws Exception {
                return NodeManager.getNodes(target, element, allowZeroResults);
            }

            @Override
            List<ProxyNodeReference> execute(NodeList nodes) throws Exception {
                ArrayList<ProxyNodeReference> results = new ArrayList<ProxyNodeReference>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    results.add(NodeManager.getNodeReference(nodes.item(i)));
                }
                return results;
            }
        }, operationId, timeout, true);
    }

    @Override
    public ProxyNodeReference getRootNode() throws RemoteException {
        Node node = NodeManager.getNodes(".", null, false).item(0);
        return NodeManager.getNodeReference(node);
    }

    @Override
    public ProxyNodeReference[] getNodePath(ProxyNodeReference node) throws RemoteException {
        ArrayList<ProxyNodeReference> path = new ArrayList<ProxyNodeReference>();
        for (Node currentNode = NodeManager.getNodeFromReference(node); currentNode != null; currentNode = currentNode.getParentNode()) {
            path.add(0, NodeManager.getNodeReference(currentNode));
        }
        return path.toArray(new ProxyNodeReference[path.size()]);
    }

    @Override
    public List<ProxyNodeReference> getNodeChildren(ProxyNodeReference parent) throws RemoteException {
        ArrayList<ProxyNodeReference> childReferences = new ArrayList<ProxyNodeReference>();
        Node node = NodeManager.getNodeFromReference(parent);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            childReferences.add(NodeManager.getNodeReference(child));
        }
        return childReferences;
    }

    @Override
    public void freeNodeReference(ProxyNodeReference nodeReference) throws RemoteException {
        NodeManager.removeNodeReference(nodeReference);
    }

    @Override
    public boolean isSameNode(ProxyNodeReference n1, ProxyNodeReference n2) throws RemoteException {
        Node node1 = NodeManager.getNodeFromReference(n1);
        Node node2 = NodeManager.getNodeFromReference(n2);
        if (node1 == null || node2 == null) {
            throw new TargetNotFoundException();
        }
        return node1.isSameNode(node2);
    }

    @Override
    public String getNodeXPath(ProxyNodeReference node, String[] preferredTextElements, String[] preferredAttributes, boolean optimize) throws JavaAppException {
        try {
            Node localNode = NodeManager.getNodeFromReference(node);
            return AutomationDocument.getNodeXPath(localNode, preferredTextElements, preferredAttributes, optimize);
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    @Override
    public String getComponentClassHeirarchy(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<String, Node>(){

            @Override
            Node evaluateTarget() throws Exception {
                return NodeManager.getNodes(target, element, false).item(0);
            }

            @Override
            String execute(Node node) throws Exception {
                if (node instanceof AutomationElement) {
                    Object component = ((AutomationElement)node).getAutomatable().getComponent();
                    if (component == null) {
                        return "null";
                    }
                    return DebugTools.getClassHeirarchy(component.getClass(), true);
                }
                throw new Exception("Not a UI element.");
            }
        }, operationId, timeout, true);
    }

    @Override
    public Rectangle getNodeWindowRelativeBounds(final ProxyNodeReference node, UUID operationId) throws RemoteException {
        return this.executeOperation(new OperationExecutable<Rectangle, Object>(){

            @Override
            Rectangle execute(Object o) throws Exception {
                Node localNode = NodeManager.getNodeFromReference(node);
                if (localNode == null) {
                    throw new TargetNotFoundException();
                }
                if (localNode instanceof AutomationElement) {
                    Automatable automatable = ((AutomationElement)localNode).getAutomatable();
                    return automatable.getWindowRelativeBounds();
                }
                return null;
            }
        }, operationId, null, true);
    }

    @Override
    public String[] getNodeAttributeNames(ProxyNodeReference node) throws RemoteException {
        Node localNode = NodeManager.getNodeFromReference(node);
        if (localNode == null) {
            throw new TargetNotFoundException();
        }
        if (localNode instanceof AutomationElement) {
            return ((AutomationElement)localNode).initAttributeNames();
        }
        return new String[0];
    }

    @Override
    public String getNodeAttribute(ProxyNodeReference node, String attributeName) throws RemoteException {
        Node localNode = NodeManager.getNodeFromReference(node);
        if (localNode == null) {
            throw new TargetNotFoundException();
        }
        if (localNode instanceof AutomationElement) {
            return ((AutomationElement)localNode).getAttribute(attributeName);
        }
        return "";
    }

    @Override
    public String getNodeTextValue(ProxyNodeReference node) throws RemoteException {
        Node localNode = NodeManager.getNodeFromReference(node);
        if (localNode == null) {
            throw new TargetNotFoundException();
        }
        NodeList children = localNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    @Override
    public void setPreferredXPathVersion(Integer preferredVersion) throws RemoteException {
        XPathExpression.setPreferredXPathVerion(preferredVersion);
    }

    @Override
    public String getNodeXml(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<String, NodeList>(){

            @Override
            NodeList evaluateTarget() throws Exception {
                return NodeManager.getNodes(target, element, false);
            }

            @Override
            String execute(NodeList targets) throws Exception {
                return AutomationDocument.nodeToXml(targets.item(0));
            }
        }, operationId, timeout, true);
    }

    @Override
    public String getNodeXml(ProxyNodeReference node) throws RemoteException {
        Node localNode = NodeManager.getNodeFromReference(node);
        if (localNode == null) {
            throw new TargetNotFoundException();
        }
        return AutomationDocument.nodeToXml(localNode);
    }

    @Override
    public void setTextValue(ProxyNodeReference element, String target, final String text, final boolean append, final SetTextPostAction postAction, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new KeyboardOperationExecutable(target, element){

            @Override
            Object execute(Automatable automatable) throws Exception {
                automatable.setTextValue(text, append);
                automatable.performPostAction(postAction);
                return null;
            }
        }, operationId, timeout, false);
    }

    @Override
    public void typeText(ProxyNodeReference element, final String target, final String text, final boolean clear, final int keystrokeDelay, final SetTextPostAction postAction, UUID operationId, Long timeout) throws RemoteException {
        this.executeOperation(new KeyboardOperationExecutable(target, element){

            @Override
            Object execute(Automatable automatable) throws Exception {
                char[] chars;
                for (char c : chars = text.replaceAll("\r\n", "\n").toCharArray()) {
                    if (AutomatableKey.fromChar(c) != null) continue;
                    throw new Exception(String.format("Unable to simulate keypress for character '%s' with code \\u%04x", Character.toString(c), (int)c));
                }
                boolean focusNext = target != null;
                boolean delayNext = false;
                if (clear) {
                    automatable.sendKey(AutomatableKey.A, false, false, true, focusNext);
                    Thread.sleep(keystrokeDelay);
                    automatable.sendKey(AutomatableKey.DELETE, false, false, false, false);
                    focusNext = false;
                    delayNext = true;
                }
                for (char c : chars) {
                    AutomatableKey key = AutomatableKey.fromChar(c);
                    boolean shift = Character.isUpperCase(c);
                    if (delayNext) {
                        Thread.sleep(keystrokeDelay);
                    }
                    automatable.sendKey(key, shift, false, false, focusNext);
                    focusNext = false;
                    delayNext = true;
                }
                automatable.performPostAction(postAction != SetTextPostAction.AUTOMATIC ? postAction : SetTextPostAction.LOSE_FOCUS);
                return null;
            }
        }, operationId, timeout, false);
    }

    @Override
    public Object getValue(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<Object, Object>(){

            @Override
            Object evaluateTarget() throws Exception {
                Object evaluateResult = NodeManager.evaluate(target, element, false);
                if (evaluateResult instanceof NodeList) {
                    evaluateResult = ((NodeList)evaluateResult).item(0);
                }
                return evaluateResult;
            }

            @Override
            Object execute(Object evaluationResult) throws Exception {
                if (evaluationResult instanceof AutomationElement) {
                    return ((AutomationElement)evaluationResult).getAutomatable().getValue();
                }
                if (evaluationResult instanceof Node) {
                    return ((Node)evaluationResult).getNodeValue();
                }
                return evaluationResult;
            }
        }, operationId, timeout, true);
    }

    @Override
    public boolean checkTargetExists(final ProxyNodeReference element, final String target, UUID operationId, Long timeout) throws RemoteException {
        return this.executeOperation(new OperationExecutable<Boolean, Boolean>(){

            @Override
            Boolean evaluateTarget() throws Exception {
                Node root = NodeManager.getNodeFromReference(element);
                return NodeManager.checkTargetExists(root, target);
            }

            @Override
            Boolean execute(Boolean exists) throws Exception {
                return exists;
            }
        }, operationId, timeout, false);
    }

    @Override
    public void waitForTarget(final ProxyNodeReference element, final String target, final float maxWait, final XPathWaitType waitType, final String targetValue, UUID operationId) throws RemoteException {
        this.executeOperation(new OperationExecutable<Object, Object>(){

            @Override
            Node evaluateTarget() throws Exception {
                Node node = NodeManager.getNodeFromReference(element);
                NodeManager.waitForTarget(node, target, maxWait, waitType, targetValue);
                return null;
            }

            @Override
            Object execute(Object o) throws Exception {
                return null;
            }
        }, operationId, null, false);
    }

    @Override
    public void registerNodeCaptureReceiver(INodeCaptureReceiver receiver, boolean captureXPaths, boolean optimizeCapturedXPaths, boolean suppressGlassPanes) throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.registerNodeCaptureReceiver(receiver, captureXPaths, optimizeCapturedXPaths, suppressGlassPanes);
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.registerNodeCaptureReceiver(receiver, captureXPaths, optimizeCapturedXPaths);
        }
    }

    @Override
    public void unregisterNodeCaptureReceiver(INodeCaptureReceiver receiver) throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.unregisterNodeCaptureReceiver(receiver);
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.unregisterNodeCaptureReceiver(receiver);
        }
    }

    @Override
    public void registerEventRecever(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots, boolean suppressGlassPanes) throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.registerEventRecever(receiver, optimizeXPaths, captureXmlSnapshots, suppressGlassPanes);
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.registerEventRecever(receiver, optimizeXPaths, captureXmlSnapshots);
        }
    }

    @Override
    public void unregisterEventReceiver(IRemoteEventReceiver receiver) throws RemoteException {
        if (AppType.getDetectedAppType() == AppType.AWT) {
            AwtEventCapture.unregisterEventReceiver(receiver);
        } else if (AppType.getDetectedAppType() == AppType.SWT) {
            SwtEventCapture.unregisterEventReceiver(receiver);
        }
    }

    private abstract class OperationExecutable<R, T> {
        private OperationExecutable() {
        }

        abstract R execute(T var1) throws Exception;

        T evaluateTarget() throws Exception {
            return null;
        }
    }

    private abstract class KeyboardOperationExecutable
    extends OperationExecutable<Object, Automatable> {
        private final String target;
        private final ProxyNodeReference element;

        public KeyboardOperationExecutable(String target, ProxyNodeReference element) {
            this.target = target;
            this.element = element;
        }

        @Override
        Automatable evaluateTarget() throws Exception {
            if (this.target != null || this.element != null) {
                return NodeManager.getComponent(this.element, this.target);
            }
            Automatable automatable = AutomationProxyImpl.this.getKeyboardFocusAutomatable();
            if (automatable != null) {
                return automatable;
            }
            throw new Exception("No UI component is in focus.");
        }
    }
}

