/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationText;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.xpath.XPathElement;
import org.ibboost.orqa.xpath.XPathNode;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutomationElement
extends XPathElement {
    private final Automatable automatable;

    public AutomationElement(Automatable automatable, XPathParentNode parent) {
        super(parent);
        this.automatable = automatable;
    }

    public Automatable getAutomatable() {
        return this.automatable;
    }

    @Override
    protected String initTagName() {
        return this.automatable.getName();
    }

    @Override
    protected String[] initAttributeNames() {
        return this.automatable.getAttributeNames();
    }

    @Override
    public String getAttribute(String name) {
        try {
            return this.automatable.getAttributeValue(name);
        }
        catch (JavaAppException e) {
            RemoteLogger.error(e);
            return "";
        }
    }

    @Override
    protected List<XPathNode> initChildren() {
        ArrayList<XPathNode> children = new ArrayList<XPathNode>();
        try {
            for (Automatable automatable : this.automatable.getChildren()) {
                children.add(new AutomationElement(automatable, this));
            }
        }
        catch (JavaAppException e) {
            RemoteLogger.error(e);
        }
        if (this.automatable.hasStringValue()) {
            children.add(new AutomationText(this.automatable, this));
        }
        return children;
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        return obj instanceof AutomationElement && this.getAutomatable().equals(((AutomationElement)obj).getAutomatable());
    }

    public Node refresh() {
        LinkedList<AutomationElement> path = new LinkedList<AutomationElement>();
        for (Node pathCursor = this; pathCursor != null; pathCursor = pathCursor.getParentNode()) {
            path.addFirst((AutomationElement)pathCursor);
        }
        if (path.size() == 1) {
            return this;
        }
        Node current = (Node)path.getFirst();
        block1: for (int i = 1; i < path.size(); ++i) {
            Node oldChild = (Node)path.get(i);
            NodeList newChildren = current.getChildNodes();
            for (int j = 0; j < newChildren.getLength(); ++j) {
                Node newChild = newChildren.item(j);
                if (newChild.isSameNode(oldChild)) {
                    if (i == path.size() - 1) {
                        return newChild;
                    }
                    current = newChild;
                    continue block1;
                }
                if (j != newChildren.getLength() - 1) continue;
                return null;
            }
        }
        return null;
    }
}

