/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.awt.Window;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ibboost.orqa.automation.events.exceptions.TargetNotFoundException;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AppType;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.xpath.XPathBuilder;
import org.ibboost.orqa.xpath.XPathDocument;
import org.ibboost.orqa.xpath.XPathNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutomationDocument
extends XPathDocument {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    @Override
    protected List<XPathNode> initChildren() {
        ArrayList<XPathNode> children;
        block4: {
            AppType appType;
            block3: {
                children = new ArrayList<XPathNode>();
                appType = AppType.getDetectedAppType();
                if (appType != AppType.AWT) break block3;
                for (Window window : AwtTools.getWindows()) {
                    if (!window.isVisible()) continue;
                    AutomatableAwtComponent<?> automatable = AutomatableAwtComponent.automatableFromComponent(window);
                    children.add(new AutomationElement(automatable, this));
                }
                break block4;
            }
            if (appType != AppType.SWT) break block4;
            try {
                children.addAll(AutomatableSwtComponent.getTopLevelElements(this));
            }
            catch (Throwable e) {
                RemoteLogger.error(e);
            }
        }
        return children;
    }

    public AutomationElement findAutomatableElement(Automatable automatable) {
        return AutomationDocument.findAutomatableElement(automatable, this);
    }

    private static AutomationElement findAutomatableElement(Automatable automatable, Node startNode) {
        AutomationElement element;
        if (startNode instanceof AutomationElement && (element = (AutomationElement)startNode).getAutomatable().equals(automatable)) {
            return element;
        }
        NodeList children = startNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            AutomationElement element2 = AutomationDocument.findAutomatableElement(automatable, children.item(i));
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        return obj instanceof AutomationDocument;
    }

    public static String getNodeXPath(Node node, String[] preferredTextElements, String[] preferredAttributes, boolean optimize) throws RemoteException {
        if (node == null) {
            throw new TargetNotFoundException();
        }
        RemoteLogger.info(String.format("Starting %s xpath builder for node %s", optimize ? "optimised" : "non optimised", node));
        XPathBuilder xPathBuilder = new XPathBuilder();
        xPathBuilder.setRootNode(new AutomationDocument());
        xPathBuilder.setAllowedElementDescendents("Row", new String[]{"Cell"});
        xPathBuilder.setPreferredTextElements(preferredTextElements);
        xPathBuilder.setPreferredAttributes(preferredAttributes);
        String result = xPathBuilder.getPathToNode(node, optimize);
        RemoteLogger.info(String.format("Built xpath '%s' for node %s", result, node));
        return result;
    }

    public static String nodeToXml(Node node) throws JavaAppException {
        try {
            DOMSource nodeSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult fileResult = new StreamResult(stringWriter);
            transformer.transform(nodeSource, fileResult);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }
}

